/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Queue;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;

public class ShurikenQueue<T>
implements Queue<T> {
    private List<T> queue;
    private boolean randomPop;
    private boolean reversePop;

    public ShurikenQueue() {
        this.clear();
    }

    public ShurikenQueue<T> responsiveMode() {
        this.reversePop = true;
        return this;
    }

    public ShurikenQueue<T> randomMode() {
        this.randomPop = true;
        return this;
    }

    @Override
    public ShurikenQueue<T> queue(T t) {
        this.queue.add(t);
        return this;
    }

    @Override
    public ShurikenQueue<T> queue(List<T> list) {
        XList.add(this.queue, list);
        return this;
    }

    @Override
    public boolean hasNext(int n) {
        return this.queue.size() >= n;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        return this.reversePop ? XList.popLast(this.queue) : (this.randomPop ? XList.popRandom(this.queue) : XList.pop(this.queue));
    }

    @Override
    public List<T> next(int n) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (int i = 0; i < n && this.hasNext(); ++i) {
            arrayList.add(this.next());
        }
        return arrayList;
    }

    @Override
    public ShurikenQueue<T> clear() {
        this.queue = new ArrayList<T>();
        return this;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean contains(T t) {
        return this.queue.contains(t);
    }

    static {
        IBootstrap.dasBoot();
    }
}

