/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.advancements.AdvancementPacketReceiver;
import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.advancements.advancement.ToastNotification;
import com.volmit.adapt.util.advancements.advancement.criteria.CriteriaType;
import com.volmit.adapt.util.advancements.advancement.progress.GenericResult;
import com.volmit.adapt.util.advancements.advancement.progress.GrantCriteriaResult;
import com.volmit.adapt.util.advancements.advancement.serialized.SerializedAdvancement;
import com.volmit.adapt.util.advancements.advancement.serialized.SerializedAdvancementDisplay;
import com.volmit.adapt.util.advancements.command.ProgressChangeOperation;
import com.volmit.adapt.util.advancements.item.CustomItem;
import com.volmit.adapt.util.advancements.item.SerializedCustomItem;
import com.volmit.adapt.util.advancements.manager.AdvancementManager;
import com.volmit.adapt.util.advancements.packet.AdvancementsPacket;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CrazyAdvancementsAPI
extends JavaPlugin
implements Listener {
    public static final String API_NAMESPACE = "crazy_advancements";
    public static final Criterion CRITERION;
    private static final Gson gson;
    private static final List<String> SELECTORS;
    private static final HashMap<String, NameKey> activeTabs;
    private static CrazyAdvancementsAPI instance;
    private static AdvancementPacketReceiver packetReciever;
    private final List<CustomItem> customItems = new ArrayList<CustomItem>();
    private final String noPermission = "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.";
    private final String commandIncompatible = "This Command is incompatible with your Arguments!";
    private AdvancementManager fileAdvancementManager;

    public static CrazyAdvancementsAPI getInstance() {
        return instance;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void clearActiveTab(Player player) {
        CrazyAdvancementsAPI.setActiveTab(player, null, true);
    }

    public static void setActiveTab(Player player, String string) {
        CrazyAdvancementsAPI.setActiveTab(player, new NameKey(string));
    }

    public static void setActiveTab(Player player, @Nullable NameKey nameKey) {
        CrazyAdvancementsAPI.setActiveTab(player, nameKey, true);
    }

    static void setActiveTab(Player player, NameKey nameKey, boolean bl) {
        if (bl) {
            PacketPlayOutSelectAdvancementTab packetPlayOutSelectAdvancementTab = new PacketPlayOutSelectAdvancementTab(nameKey == null ? null : nameKey.getMinecraftKey());
            ((CraftPlayer)player).getHandle().b.a((Packet)packetPlayOutSelectAdvancementTab);
        }
        activeTabs.put(player.getUniqueId().toString(), nameKey);
    }

    public static NameKey getActiveTab(Player player) {
        return activeTabs.get(player.getUniqueId().toString());
    }

    public void reload() {
        this.loadCustomItems();
        this.reloadFileAdvancements();
    }

    private void reloadFileAdvancements() {
        if (this.fileAdvancementManager != null) {
            for (Player player : new ArrayList<Player>(this.fileAdvancementManager.getPlayers())) {
                this.fileAdvancementManager.removePlayer(player);
            }
            this.fileAdvancementManager.resetAccessible();
        }
        this.fileAdvancementManager = new AdvancementManager(new NameKey(API_NAMESPACE, "file"), new Player[0]);
        this.fileAdvancementManager.makeAccessible();
        this.loadFileAdvancements();
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReciever.initPlayer(player);
            this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
            this.fileAdvancementManager.addPlayer(player);
        }
    }

    public void onLoad() {
        instance = this;
        this.loadCustomItems();
        this.fileAdvancementManager = new AdvancementManager(new NameKey(API_NAMESPACE, "file"), new Player[0]);
        this.fileAdvancementManager.makeAccessible();
        this.loadFileAdvancements();
    }

    private void loadCustomItems() {
        File[] fileArray;
        File file = new File(this.getDataFolder().getAbsolutePath() + File.separator + "custom_items" + File.separator);
        this.customItems.clear();
        file.mkdirs();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory()) continue;
            String string = file2.getName();
            this.customItems.addAll(this.loadCustomItemsFromNamespace(string, "", file2));
        }
        System.out.println("Loaded " + this.customItems.size() + " Custom Items");
    }

    private List<CustomItem> loadCustomItemsFromNamespace(String string, String string2, File file) {
        File[] fileArray = file.listFiles();
        ArrayList<CustomItem> arrayList = new ArrayList<CustomItem>();
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                arrayList.addAll(this.loadCustomItemsFromNamespace(string, string2 + file2.getName() + "/", file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".json")) continue;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file2);
                JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
                fileReader.close();
                SerializedCustomItem serializedCustomItem = (SerializedCustomItem)gson.fromJson(jsonElement, SerializedCustomItem.class);
                String string3 = file2.getName();
                String string4 = string3.substring(0, string3.length() - 5);
                arrayList.add(serializedCustomItem.deserialize(new NameKey(string, string2 + string4)));
            }
            catch (Exception exception) {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                System.err.println("Unable to load Custom Item from File " + string + "/" + file2.getName() + ": " + exception.getLocalizedMessage());
            }
        }
        return arrayList;
    }

    private void loadFileAdvancements() {
        Object object;
        File file = new File(this.getDataFolder().getAbsolutePath() + File.separator + "advancements" + File.separator);
        HashMap<NameKey, SerializedAdvancement> hashMap = new HashMap<NameKey, SerializedAdvancement>();
        file.mkdirs();
        File[] fileArray = file.listFiles();
        for (File file2 : fileArray) {
            if (!file2.isDirectory()) continue;
            object = file2.getName();
            hashMap.putAll(this.loadAdvancementsFromNamespace((String)object, "", file2));
        }
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        HashMap hashMap2 = new HashMap();
        while (arrayList.size() > 0) {
            Object object2;
            Iterator iterator = arrayList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                object = (NameKey)iterator.next();
                object2 = (SerializedAdvancement)hashMap.get(object);
                NameKey nameKey = ((SerializedAdvancement)object2).getParent();
                if (nameKey != null && !hashMap2.containsKey(nameKey)) continue;
                SerializedAdvancementDisplay serializedAdvancementDisplay = ((SerializedAdvancement)object2).getDisplay();
                ItemStack itemStack = this.getItemStack(serializedAdvancementDisplay.getIcon(), new CommandSender[0]);
                JSONMessage jSONMessage = new JSONMessage(serializedAdvancementDisplay.getTitle().deserialize());
                JSONMessage jSONMessage2 = new JSONMessage(serializedAdvancementDisplay.getDescription().deserialize());
                AdvancementDisplay.AdvancementFrame advancementFrame = AdvancementDisplay.AdvancementFrame.parse(serializedAdvancementDisplay.getFrame());
                AdvancementVisibility advancementVisibility = AdvancementVisibility.parseVisibility(serializedAdvancementDisplay.getVisibility());
                AdvancementDisplay advancementDisplay = new AdvancementDisplay(itemStack, jSONMessage, jSONMessage2, advancementFrame, advancementVisibility);
                if (serializedAdvancementDisplay.getBackgroundTexture() != null) {
                    advancementDisplay.setBackgroundTexture(serializedAdvancementDisplay.getBackgroundTexture());
                }
                advancementDisplay.setX(serializedAdvancementDisplay.getX());
                advancementDisplay.setY(serializedAdvancementDisplay.getY());
                ArrayList<AdvancementFlag> arrayList2 = new ArrayList<AdvancementFlag>();
                if (((SerializedAdvancement)object2).getFlags() != null) {
                    for (String string : ((SerializedAdvancement)object2).getFlags()) {
                        arrayList2.add(AdvancementFlag.valueOf(string.toUpperCase(Locale.ROOT)));
                    }
                }
                Advancement advancement = new Advancement(nameKey == null ? null : (Advancement)hashMap2.get(nameKey), (NameKey)object, advancementDisplay, (AdvancementFlag[])arrayList2.toArray(AdvancementFlag[]::new));
                if (((SerializedAdvancement)object2).getCriteria() != null) {
                    advancement.setCriteria(((SerializedAdvancement)object2).getCriteria().deserialize());
                }
                advancement.setReward(((SerializedAdvancement)object2).getReward());
                this.fileAdvancementManager.addAdvancement(advancement);
                iterator.remove();
                hashMap2.put(object, advancement);
                ++n;
            }
            if (n != 0) continue;
            object = arrayList.iterator();
            while (object.hasNext()) {
                object2 = (NameKey)object.next();
                System.err.println("Unable to load Advancement " + (NameKey)object2 + ": Parent does not exist");
            }
            break block1;
        }
    }

    private HashMap<NameKey, SerializedAdvancement> loadAdvancementsFromNamespace(String string, String string2, File file) {
        File[] fileArray = file.listFiles();
        HashMap<NameKey, SerializedAdvancement> hashMap = new HashMap<NameKey, SerializedAdvancement>();
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                hashMap.putAll(this.loadAdvancementsFromNamespace(string, string2 + file2.getName() + "/", file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().endsWith(".json")) continue;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file2);
                JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
                fileReader.close();
                SerializedAdvancement serializedAdvancement = (SerializedAdvancement)gson.fromJson(jsonElement, SerializedAdvancement.class);
                String string3 = file2.getName();
                String string4 = string3.substring(0, string3.length() - 5);
                hashMap.put(new NameKey(string, string2 + string4), serializedAdvancement);
            }
            catch (Exception exception) {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                System.err.println("Unable to load Advancement from File " + string + "/" + file2.getName() + ": " + exception.getLocalizedMessage());
            }
        }
        return hashMap;
    }

    public void onEnable() {
        CrazyAdvancementsAPI.loadConfig0();
        packetReciever = new AdvancementPacketReceiver();
        for (Player player : Bukkit.getOnlinePlayers()) {
            packetReciever.initPlayer(player);
            this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
            this.fileAdvancementManager.addPlayer(player);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, true, null, null);
            advancementsPacket.send();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        final Player player = playerJoinEvent.getPlayer();
        packetReciever.initPlayer(player);
        this.fileAdvancementManager.loadProgress(player, new Advancement[0]);
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                CrazyAdvancementsAPI.this.fileAdvancementManager.addPlayer(player);
            }
        }, 2L);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        packetReciever.close(player, packetReciever.getHandlers().get(player.getName()));
        this.fileAdvancementManager.unloadProgress(player.getUniqueId(), new Advancement[0]);
        this.fileAdvancementManager.unloadVisibilityStatus(player.getUniqueId(), new Advancement[0]);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (command.getName().equalsIgnoreCase("showtoast")) {
            block71: {
                if (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.showtoast")) {
                    if (stringArray.length >= 3) {
                        try {
                            ArrayList<Player> arrayList = new ArrayList<Player>();
                            for (Entity entity : Bukkit.selectEntities((CommandSender)commandSender, (String)stringArray[0])) {
                                if (!(entity instanceof Player)) continue;
                                arrayList.add((Player)entity);
                            }
                            if (arrayList.size() > 0) {
                                ItemStack itemStack = this.getItemStack(stringArray[1], commandSender);
                                if (itemStack != null) {
                                    int n = 2;
                                    AdvancementDisplay.AdvancementFrame advancementFrame = AdvancementDisplay.AdvancementFrame.parseStrict(stringArray[2]);
                                    if (advancementFrame == null) {
                                        advancementFrame = AdvancementDisplay.AdvancementFrame.TASK;
                                    } else {
                                        n = 3;
                                    }
                                    Object object = stringArray[n];
                                    if (stringArray.length > n + 1) {
                                        for (int i = n + 1; i < stringArray.length; ++i) {
                                            object = (String)object + " " + stringArray[i];
                                        }
                                    }
                                    for (Player player : arrayList) {
                                        ToastNotification toastNotification = new ToastNotification(itemStack, (String)object, advancementFrame);
                                        toastNotification.send(player);
                                    }
                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), arrayList.size() == 1 ? "Successfully displayed Toast to " + ((Player)arrayList.get(0)).getName() + "!" : "Successfully displayed Toast to " + arrayList.size() + "Players!");
                                } else {
                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "'" + stringArray[1] + "' isn't a valid Item Material");
                                }
                                break block71;
                            }
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), stringArray[0].startsWith("@") ? "No Player found for Selector " + stringArray[0] : "Can't find Player '" + stringArray[0] + "'");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Usage: " + command.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("grant") || command.getName().equalsIgnoreCase("revoke")) {
            block72: {
                boolean bl = command.getName().equalsIgnoreCase("grant");
                if (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.grantrevoke")) {
                    if (stringArray.length >= 3) {
                        try {
                            ArrayList<Player> arrayList = new ArrayList<Player>();
                            for (Object object : Bukkit.selectEntities((CommandSender)commandSender, (String)stringArray[0])) {
                                if (!(object instanceof Player)) continue;
                                arrayList.add((Player)object);
                            }
                            if (arrayList.size() > 0) {
                                AdvancementManager advancementManager = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]));
                                if (advancementManager != null) {
                                    for (Player player : arrayList) {
                                        if (advancementManager.getPlayers().contains(player)) {
                                            Advancement advancement = advancementManager.getAdvancement(new NameKey(stringArray[2]));
                                            if (advancement != null) {
                                                if (stringArray.length >= 4) {
                                                    Object object;
                                                    String[] stringArray2 = Arrays.copyOfRange(stringArray, 3, stringArray.length);
                                                    boolean bl2 = false;
                                                    if (bl) {
                                                        if (!advancement.isGranted(player)) {
                                                            object = advancementManager.grantCriteria(player, advancement, stringArray2);
                                                            bl2 = object == GrantCriteriaResult.CHANGED;
                                                        }
                                                    } else {
                                                        object = advancementManager.revokeCriteria(player, advancement, stringArray2);
                                                        bl2 = object == GenericResult.CHANGED;
                                                    }
                                                    object = stringArray2[0];
                                                    if (stringArray2.length > 1) {
                                                        for (String string2 : Arrays.copyOfRange(stringArray2, 1, stringArray2.length - 1)) {
                                                            object = (String)object + ", " + string2;
                                                        }
                                                        object = (String)object + " and " + stringArray2[stringArray2.length - 1];
                                                    }
                                                    if (bl2) {
                                                        if (this.fileAdvancementManager.equals(advancementManager)) {
                                                            this.fileAdvancementManager.saveProgress(player, advancement);
                                                        }
                                                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Successfully " + (bl ? "granted" : "revoked") + " Criteria " + (String)object + " for '" + advancement.getName() + "' " + (bl ? "to" : "from") + " " + player.getName());
                                                        continue;
                                                    }
                                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Criteria " + (String)object + " for '" + advancement.getName() + "' " + (bl ? "is already granted to" : "is already not granted to") + " " + player.getName());
                                                    continue;
                                                }
                                                boolean bl3 = false;
                                                if (bl) {
                                                    if (!advancement.isGranted(player)) {
                                                        GenericResult genericResult = advancementManager.grantAdvancement(player, advancement);
                                                        bl3 = genericResult == GenericResult.CHANGED;
                                                    }
                                                } else {
                                                    GenericResult genericResult = advancementManager.revokeAdvancement(player, advancement);
                                                    boolean bl4 = bl3 = genericResult == GenericResult.CHANGED;
                                                }
                                                if (bl3) {
                                                    if (this.fileAdvancementManager.equals(advancementManager)) {
                                                        this.fileAdvancementManager.saveProgress(player, advancement);
                                                    }
                                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Successfully " + (bl ? "granted" : "revoked") + " Advancement '" + advancement.getName() + "' " + (bl ? "to" : "from") + " " + player.getName());
                                                    continue;
                                                }
                                                Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Advancement '" + advancement.getName() + "' " + (bl ? "is already granted to" : "is already not granted to") + " " + player.getName());
                                                continue;
                                            }
                                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Advancement with Name '" + stringArray[2] + "' does not exist in '" + stringArray[1] + "'");
                                            continue;
                                        }
                                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "'" + stringArray[1] + "' does not contain Player '" + stringArray[0] + "'");
                                    }
                                } else {
                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Manager with Name '" + stringArray[1] + "' does not exist");
                                }
                                break block72;
                            }
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), stringArray[0].startsWith("@") ? "No Player found for Selector " + stringArray[0] : "Can't find Player '" + stringArray[0] + "'");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Usage: " + command.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("setprogress")) {
            block73: {
                if (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.grantrevoke")) {
                    if (stringArray.length >= 3) {
                        try {
                            ArrayList<Player> arrayList = new ArrayList<Player>();
                            for (Object object : Bukkit.selectEntities((CommandSender)commandSender, (String)stringArray[0])) {
                                if (!(object instanceof Player)) continue;
                                arrayList.add((Player)object);
                            }
                            if (arrayList.size() > 0) {
                                AdvancementManager advancementManager = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]));
                                if (advancementManager != null) {
                                    for (Player player : arrayList) {
                                        if (advancementManager.getPlayers().contains(player)) {
                                            Advancement advancement = advancementManager.getAdvancement(new NameKey(stringArray[2]));
                                            if (advancement != null) {
                                                if (stringArray.length < 4) continue;
                                                int n = Integer.parseInt(stringArray[3]);
                                                ProgressChangeOperation progressChangeOperation = stringArray.length >= 5 ? ProgressChangeOperation.parse(stringArray[4]) : ProgressChangeOperation.SET;
                                                int n2 = advancement.getProgress(player).getCriteriaProgress();
                                                int n3 = progressChangeOperation.apply(n2, n);
                                                advancementManager.setCriteriaProgress(player, advancement, n3);
                                                if (this.fileAdvancementManager.equals(advancementManager)) {
                                                    this.fileAdvancementManager.saveProgress(player, advancement);
                                                }
                                                Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Successfully updated Criteria Progress for Advancement '" + advancement.getName() + "' for Player " + player.getName());
                                                continue;
                                            }
                                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Advancement with Name '" + stringArray[2] + "' does not exist in '" + stringArray[1] + "'");
                                            continue;
                                        }
                                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "'" + stringArray[1] + "' does not contain Player '" + stringArray[0] + "'");
                                    }
                                } else {
                                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Manager with Name '" + stringArray[1] + "' does not exist");
                                }
                                break block73;
                            }
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), stringArray[0].startsWith("@") ? "No Player found for Selector " + stringArray[0] : "Can't find Player '" + stringArray[0] + "'");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "This Command is incompatible with your Arguments!");
                        }
                    } else {
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Usage: " + command.getUsage());
                    }
                } else {
                    Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "I'm sorry but you do not have permission to perform this command. Please contact the server administrator if you believe that this is an error.");
                }
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("careload") && (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.reload"))) {
            if (stringArray.length > 0) {
                switch (stringArray[0].toLowerCase()) {
                    case "all": {
                        this.reload();
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Crazy Advancements API was reloaded");
                        break;
                    }
                    case "advancements": {
                        this.reloadFileAdvancements();
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "JSON Advancements have been reloaded");
                        break;
                    }
                    case "items": {
                        this.loadCustomItems();
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Custom Items have been reloaded");
                        break;
                    }
                    default: {
                        Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Invalid Reload Category '" + stringArray[0] + "'. Valid categories are all, advancements, items");
                        break;
                    }
                }
            } else {
                this.reload();
                Adapt.messagePlayer(commandSender.getServer().getPlayer(commandSender.getName()), "Crazy Advancements API was reloaded");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("showtoast") && (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.showtoast"))) {
            if (stringArray.length == 1) {
                for (String string2 : SELECTORS) {
                    if (!string2.toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(string2);
                }
                object = Bukkit.getOnlinePlayers().iterator();
                while (object.hasNext()) {
                    String string2;
                    string2 = (Player)object.next();
                    if (!string2.getName().toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(string2.getName());
                }
            } else if (stringArray.length == 2) {
                for (Material object2 : Material.values()) {
                    if (!object2.isItem() || !object2.name().toLowerCase().startsWith(stringArray[1].toLowerCase())) continue;
                    arrayList.add(object2.name().toLowerCase());
                }
                object = this.customItems.iterator();
                while (object.hasNext()) {
                    CustomItem customItem = (CustomItem)object.next();
                    if (!customItem.getName().toString().startsWith(stringArray[1].toLowerCase())) continue;
                    arrayList.add(customItem.getName().toString());
                }
            } else if (stringArray.length == 3) {
                object = AdvancementDisplay.AdvancementFrame.values();
                int n = ((Material[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object n2 = object[i];
                    if (!((Enum)n2).name().toLowerCase().startsWith(stringArray[2].toLowerCase())) continue;
                    arrayList.add(((Enum)n2).name().toLowerCase());
                }
            }
        }
        if ((command.getName().equalsIgnoreCase("grant") || command.getName().equalsIgnoreCase("revoke")) && (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.grantrevoke"))) {
            Advancement advancement;
            if (stringArray.length == 1) {
                for (String string3 : SELECTORS) {
                    if (!string3.toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(string3);
                }
                object = Bukkit.getOnlinePlayers().iterator();
                while (object.hasNext()) {
                    Player player = (Player)object.next();
                    if (!player.getName().toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(player.getName());
                }
            } else if (stringArray.length == 2) {
                object = AdvancementManager.getAccessibleManagers().iterator();
                while (object.hasNext()) {
                    AdvancementManager advancementManager = (AdvancementManager)object.next();
                    if (!advancementManager.getName().toString().startsWith(stringArray[1].toLowerCase())) continue;
                    arrayList.add(advancementManager.getName().toString());
                }
            } else if (stringArray.length == 3) {
                object = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]));
                if (object != null) {
                    for (Advancement advancement2 : ((AdvancementManager)object).getAdvancements()) {
                        if (!advancement2.getName().toString().startsWith(stringArray[2].toLowerCase()) && !advancement2.getName().getKey().startsWith(stringArray[2].toLowerCase())) continue;
                        arrayList.add(advancement2.getName().toString());
                    }
                }
            } else if (stringArray.length >= 4 && (object = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]))) != null && (advancement = ((AdvancementManager)object).getAdvancement(new NameKey(stringArray[2]))) != null) {
                String[] stringArray2 = advancement.getCriteria().getActionNames();
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = stringArray2[i];
                    if (!string2.toLowerCase().startsWith(stringArray[stringArray.length - 1].toLowerCase())) continue;
                    arrayList.add(string2);
                }
            }
        }
        if (command.getName().equalsIgnoreCase("setprogress") && (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.grantrevoke"))) {
            Advancement advancement;
            if (stringArray.length == 1) {
                for (String string4 : SELECTORS) {
                    if (!string4.toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(string4);
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(stringArray[0].toLowerCase())) continue;
                    arrayList.add(player.getName());
                }
            } else if (stringArray.length == 2) {
                for (AdvancementManager advancementManager : AdvancementManager.getAccessibleManagers()) {
                    if (!advancementManager.getName().toString().startsWith(stringArray[1].toLowerCase())) continue;
                    arrayList.add(advancementManager.getName().toString());
                }
            } else if (stringArray.length == 3) {
                object = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]));
                if (object != null) {
                    for (Advancement advancement3 : ((AdvancementManager)object).getAdvancements()) {
                        if (!advancement3.getName().toString().startsWith(stringArray[2].toLowerCase()) && !advancement3.getName().getKey().startsWith(stringArray[2].toLowerCase()) || advancement3.getCriteria().getType() != CriteriaType.NUMBER) continue;
                        arrayList.add(advancement3.getName().toString());
                    }
                }
            } else if (stringArray.length == 4) {
                Advancement advancement4;
                object = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]));
                if (object != null && (advancement4 = ((AdvancementManager)object).getAdvancement(new NameKey(stringArray[2]))) != null && advancement4.getCriteria().getType() == CriteriaType.NUMBER) {
                    arrayList.add(stringArray[3]);
                    arrayList.add("" + advancement4.getCriteria().getRequiredNumber());
                }
            } else if (stringArray.length == 5 && (object = AdvancementManager.getAccessibleManager(new NameKey(stringArray[1]))) != null && (advancement = ((AdvancementManager)object).getAdvancement(new NameKey(stringArray[2]))) != null && advancement.getCriteria().getType() == CriteriaType.NUMBER) {
                for (ProgressChangeOperation progressChangeOperation : ProgressChangeOperation.values()) {
                    if (!progressChangeOperation.name().toLowerCase().startsWith(stringArray[4].toLowerCase())) continue;
                    arrayList.add(progressChangeOperation.name().toLowerCase());
                }
            }
        }
        if (command.getName().equalsIgnoreCase("careload") && (commandSender.hasPermission("crazyadvancements.command.*") || commandSender.hasPermission("crazyadvancements.command.reload"))) {
            if ("all".startsWith(stringArray[0])) {
                arrayList.add("all");
            }
            if ("advancements".startsWith(stringArray[0])) {
                arrayList.add("advancements");
            }
            if ("items".startsWith(stringArray[0])) {
                arrayList.add("items");
            }
        }
        return arrayList;
    }

    private Material getMaterial(String string) {
        for (Material material : Material.values()) {
            if (!material.name().equalsIgnoreCase(string)) continue;
            return material;
        }
        return Material.matchMaterial((String)string);
    }

    private CustomItem getCustomItem(String string) {
        NameKey nameKey = new NameKey(string);
        for (CustomItem customItem : this.customItems) {
            if (!customItem.getName().isSimilar(nameKey)) continue;
            return customItem;
        }
        return null;
    }

    private ItemStack getItemStack(String string, CommandSender ... commandSenderArray) {
        ItemStack itemStack;
        Object object2;
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : string.substring(0, n);
        String string3 = n == -1 ? "" : string.substring(n + 1);
        Material material = this.getMaterial(string2);
        if (material == null || !material.isItem()) {
            object2 = this.getCustomItem(string);
            if (object2 == null) {
                return null;
            }
            material = ((CustomItem)object2).getType();
            itemStack = new ItemStack(material);
            ItemMeta object3 = itemStack.getItemMeta();
            object3.setCustomModelData(Integer.valueOf(((CustomItem)object2).getCustomModelData()));
            itemStack.setItemMeta(object3);
        } else {
            itemStack = new ItemStack(material);
        }
        switch (material) {
            case PLAYER_HEAD: {
                if (string3.isEmpty()) break;
                if (commandSenderArray.length > 0) {
                    for (String string4 : SELECTORS) {
                        if (!string3.startsWith(string4)) continue;
                        ArrayList<Player> arrayList = new ArrayList<Player>();
                        for (Entity entity : Bukkit.selectEntities((CommandSender)commandSenderArray[0], (String)string3)) {
                            if (!(entity instanceof Player)) continue;
                            arrayList.add((Player)entity);
                        }
                        if (arrayList.size() > 0) {
                            Entity entity;
                            Player player = (Player)arrayList.get(0);
                            entity = (SkullMeta)itemStack.getItemMeta();
                            entity.setOwningPlayer((OfflinePlayer)player);
                            itemStack.setItemMeta((ItemMeta)entity);
                        }
                        return itemStack;
                    }
                }
                object2 = Bukkit.getOfflinePlayer((String)string3);
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                skullMeta.setOwningPlayer((OfflinePlayer)object2);
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
        }
        if (!string3.isEmpty() && material.getMaxDurability() > 0) {
            try {
                short s = Short.parseShort(string3);
                Damageable damageable = (Damageable)itemStack.getItemMeta();
                damageable.setDamage((int)s);
                itemStack.setItemMeta((ItemMeta)damageable);
            }
            catch (ClassCastException | NumberFormatException runtimeException) {
                Adapt.verbose("Invalid damage value for item " + string);
            }
        }
        return itemStack;
    }

    static {
        IBootstrap.dasBoot();
        CRITERION = new Criterion(new CriterionInstance(){

            public JsonObject a(LootSerializationContext lootSerializationContext) {
                return null;
            }

            public MinecraftKey a() {
                return new MinecraftKey("", "");
            }
        });
        SELECTORS = Arrays.asList("@a", "@p", "@s", "@r");
        activeTabs = new HashMap();
        gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection uRLConnection = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=826291&resource_id=%%__RESOURCE__%%&nonce=-116268714").openConnection();
            uRLConnection.setConnectTimeout(1000);
            uRLConnection.setReadTimeout(1000);
            ((HttpURLConnection)uRLConnection).setInstanceFollowRedirects(true);
            String string = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream())).readLine();
            if ("false".equals(string)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

