/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.AbstractLongIterator;
import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LongRange
extends NumberRange<Long, LongRange> {
    public LongRange(Long l, Long l2) {
        this(l, l2, 1L, true, true, false);
    }

    public LongRange(Long l, Long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
        super(l, l2, l3, bl, bl2, bl3);
        if (l3 <= 0L) {
            throw new IllegalArgumentException("The step must be greater than 0: " + l3);
        }
    }

    @Override
    public Iterator<Long> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Long> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Long getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        long l = (Long)this.getLeftEndpoint() + (Long)this.getStep() * (long)n;
        if (this.isRightClosed() ? l <= (Long)this.getRightEndpoint() : l < (Long)this.getRightEndpoint()) {
            return l;
        }
        return null;
    }

    public LongRange unaryMinus() {
        Long l = (Long)this.getLeftEndpoint();
        Long l2 = (Long)this.getRightEndpoint();
        if (this.isReversed()) {
            return new LongRange(l, l2, (Long)this.getStep(), true, true, false);
        }
        return new LongRange(l2, l, (Long)this.getStep(), true, true, true);
    }

    @Override
    public Long getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        long l = (Long)this.getRightEndpoint() - (Long)this.getStep() * (long)n;
        if (this.isLeftClosed() ? l >= (Long)this.getLeftEndpoint() : l > (Long)this.getLeftEndpoint()) {
            return l;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    extends AbstractLongIterator {
        private long _csr;

        public ForwardIterator() {
            this._csr = (Long)LongRange.this.getLeftEndpoint();
            if (!LongRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Long)LongRange.this.getRightEndpoint() || LongRange.this.isRightClosed() && this._csr == (Long)LongRange.this.getRightEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr > (Long)LongRange.this.getRightEndpoint() || !LongRange.this.isRightClosed() && this._csr == (Long)LongRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            long l = this._csr;
            this._csr += ((Long)LongRange.this.getStep()).longValue();
            return l;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    extends AbstractLongIterator {
        private long _csr;

        public ReverseIterator() {
            this._csr = (Long)LongRange.this.getRightEndpoint();
            if (!LongRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Long)LongRange.this.getLeftEndpoint() || LongRange.this.isLeftClosed() && this._csr == (Long)LongRange.this.getLeftEndpoint();
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (this._csr < (Long)LongRange.this.getLeftEndpoint() || !LongRange.this.isLeftClosed() && this._csr == (Long)LongRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            long l = this._csr;
            this._csr -= ((Long)LongRange.this.getStep()).longValue();
            return l;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

