/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse;

import com.strobel.decompiler.Decompiler;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.volmit.adapt.util.arcane.curse.model.CursedComponent;
import com.volmit.adapt.util.arcane.curse.model.CursedConstructor;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedField;
import com.volmit.adapt.util.arcane.curse.model.CursedMethod;
import com.volmit.adapt.util.arcane.curse.model.FuzzyField;
import com.volmit.adapt.util.arcane.curse.model.FuzzyMethod;
import com.volmit.adapt.util.arcane.curse.util.JarLoader;
import com.volmit.adapt.util.arcane.curse.util.poet.JavaFile;
import com.volmit.adapt.util.arcane.curse.util.poet.MethodSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ParameterSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeSpec;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import me.coley.recaf.metadata.InsnComment;
import spoon.reflect.cu.SourcePosition;
import sun.misc.Unsafe;

public class Curse {
    public static Stream<CursedMethod> withMethod(Class<?> clazz2, String string, Class<?> ... classArray) {
        try {
            return new JarLoader(clazz2).all().filter(clazz -> Curse.on(clazz).optionalMethod(string, classArray).isPresent()).map(clazz -> Curse.on(clazz).method(string, classArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void stop(Thread thread) {
        thread.interrupt();
        thread.suspend();
        thread.stop();
    }

    public static void resume(Thread thread) {
        thread.resume();
    }

    public static void pause(Thread thread) {
        thread.suspend();
    }

    public static Unsafe unsafe() {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void unpark(Thread thread) {
        Curse.unsafe().unpark(thread);
    }

    public static void park(double d) {
        if (d == 0.0) {
            Curse.unsafe().park(true, 0L);
        } else if (d > 999.0 || (double)((long)d) == d) {
            Curse.unsafe().park(true, System.currentTimeMillis() + (long)d);
        } else {
            long l = (long)(d * 1000000.0);
            Curse.unsafe().park(false, l);
        }
    }

    public static String decompile(Class<?> clazz) {
        try {
            if (clazz.getCanonicalName() == null) {
                return "err: null canonical";
            }
            StringWriter stringWriter = new StringWriter();
            Decompiler.decompile((String)clazz.getCanonicalName().replaceAll("\\Q.\\E", "/"), (ITextOutput)new PlainTextOutput((Writer)stringWriter), (DecompilerSettings)DecompilerSettings.javaDefaults());
            return stringWriter.toString();
        }
        catch (Throwable throwable) {
            return "err: " + throwable.getClass().getCanonicalName() + " " + throwable.getMessage();
        }
    }

    public static Stream<CursedConstructor> withConstructor(Class<?> clazz2, Class<?> ... classArray) {
        try {
            return new JarLoader(clazz2).all().filter(clazz -> Curse.on(clazz).optionalConstructor(classArray).isPresent()).map(clazz -> Curse.on(clazz).constructor(classArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static File temp(String ... stringArray) {
        File file = new File(System.getProperty("java.io.tmpdir"), String.join((CharSequence)File.separator, stringArray));
        file.getParentFile().mkdirs();
        return file;
    }

    public static Stream<CursedField> withField(Class<?> clazz2, String string) {
        try {
            return new JarLoader(clazz2).all().filter(clazz -> Curse.on(clazz).optionalField(string).isPresent()).map(clazz -> Curse.on(clazz).field(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedField> withField(Class<?> clazz3, String string, Class<?> clazz4) {
        try {
            return new JarLoader(clazz3).all().filter(clazz2 -> {
                Optional<CursedField> optional = Curse.on(clazz2).optionalField(string);
                return optional.isPresent() && optional.get().field().getType().equals(clazz4);
            }).map(clazz -> Curse.on(clazz).field(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @InsnComment(At_0="wWZBllRKxGTlRjWVdTRRJ0dRJTWxMGVNh3YU9keRRlT5VUMWBFWaFXcFNTaNNTdMZDbapXN")
    public static Class<?> loadOrInstallClass(String string, String string2, String string3) {
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            return Curse.installDependency(string2, string3).filter(clazz -> clazz.getCanonicalName().equals(string)).findFirst().orElseThrow();
        }
    }

    public static Stream<Class<?>> installDependency(String string, String string2) {
        try {
            File file = Curse.downloadCachedFile(Curse.getJarDependencyUrl(string, string2), "jar").get();
            return Curse.load(file);
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String getJarDependencyUrl(String string, String string2) {
        String[] stringArray = string.split("\\Q:\\E");
        return string2 + "/" + stringArray[0].replaceAll("\\Q.\\E", "/") + "/" + stringArray[1] + "/" + stringArray[2] + "/" + stringArray[1] + "-" + stringArray[2] + ".jar";
    }

    public static Future<File> downloadCachedFile(String string, String string2) {
        File file = Curse.temp("dlc", UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8)) + "." + string2);
        if (file.exists()) {
            return CompletableFuture.completedFuture(file);
        }
        return Curse.downloadFile(string, file);
    }

    public static Future<File> downloadFile(String string, File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ReadableByteChannel readableByteChannel = Channels.newChannel(new URL(string).openStream());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                fileOutputStream.close();
                return file;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    public static Class<?> compile(JavaFile javaFile) {
        return Curse.compile(javaFile.packageName + "." + javaFile.typeSpec.name, javaFile.toString());
    }

    public static Stream<Class<?>> containingSource(Class<?> clazz2, String string) {
        return Curse.all(clazz2).map(cursedComponent -> cursedComponent.type()).filter(clazz -> Curse.decompile(clazz).contains(string)).map(clazz -> clazz);
    }

    public static Class<?> compile(String string, String string2) {
        File file = Curse.temp("compile", UUID.randomUUID().toString(), "src");
        File file2 = new File(file, string.replaceAll("\\Q.\\E", "/") + ".java");
        file2.getParentFile().mkdirs();
        Files.writeString(file2.toPath(), (CharSequence)string2, new OpenOption[0]);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        javaCompiler.run(null, null, null, file2.getPath());
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{file.toURI().toURL()}, Curse.class.getClassLoader());
        return uRLClassLoader.loadClass(string);
    }

    public static Stream<CursedComponent> all(Class<?> clazz) {
        try {
            return new JarLoader(clazz).all().filter(Objects::nonNull).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void shove(Object object, Object object2) {
        Curse.implode(object2, Curse.explode(object));
    }

    public static void implode(Object object, Map<String, Object> map) {
        CursedComponent cursedComponent = Curse.on(object);
        for (String string : map.keySet()) {
            cursedComponent.set(string, map.get(string));
        }
    }

    public static Map<String, Object> explode(Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Curse.on(object).instanceFields().forEach(cursedField -> {
            Object t = cursedField.get();
            if (t != null) {
                hashMap.put(cursedField.field().getName(), t);
            }
        });
        return hashMap;
    }

    public static Stream<Class<?>> load(File file) {
        return Curse.load(Curse.class.getClassLoader(), file);
    }

    public static Stream<Class<?>> load(ClassLoader classLoader, File file) {
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, classLoader);
            return new JarLoader(uRLClassLoader, file).all();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> where(Class<?> clazz, Predicate<Class<?>> predicate) {
        try {
            return new JarLoader(clazz).all().map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> whereInPackage(Class<?> clazz, Predicate<Class<?>> predicate, String string) {
        try {
            return new JarLoader(clazz).inPackageNested(string).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> implemented(Class<?> clazz, Class<?> clazz2) {
        try {
            return new JarLoader(clazz).all(clazz2).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> implemented(File file, Class<?> clazz) {
        try {
            return new JarLoader(file).all(clazz).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> implementedInPackage(Class<?> clazz, Class<?> clazz2, String string) {
        try {
            return new JarLoader(clazz).inPackageNested(string, clazz2).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> implementedInPackage(File file, Class<?> clazz, String string) {
        try {
            return new JarLoader(file).inPackageNested(string, clazz).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> annotated(Class<?> clazz, Class<? extends Annotation> clazz3) {
        try {
            return new JarLoader(clazz).all().filter(clazz2 -> clazz2.isAnnotationPresent(clazz3)).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> annotatedName(Class<?> clazz2, String string) {
        try {
            return new JarLoader(clazz2).all().filter(clazz -> {
                for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                    if (!annotation.annotationType().getSimpleName().equals(string)) continue;
                    return true;
                }
                for (Annotation annotation : clazz.getAnnotations()) {
                    if (!annotation.annotationType().getSimpleName().equals(string)) continue;
                    return true;
                }
                return false;
            }).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Stream<CursedComponent> annotatedInPackage(Class<?> clazz, Class<? extends Annotation> clazz3, String string) {
        try {
            return new JarLoader(clazz).inPackageNested(string).filter(clazz2 -> clazz2.isAnnotationPresent(clazz3)).map(Curse::on);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static CursedComponent on(Object object) {
        return new CursedComponent(new CursedContext().instance(object).type(object.getClass()));
    }

    public static CursedComponent on(Class<?> clazz) {
        return new CursedComponent(new CursedContext().type(clazz));
    }

    public static void write(File file, String string) {
        try {
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print(string);
            printStream.close();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String deepStackTrace(StackTraceElement[] stackTraceElementArray) {
        return Arrays.stream(stackTraceElementArray).map(stackTraceElement -> {
            try {
                String string = Curse.deepStackTraceElement(stackTraceElement);
                if (string != null) {
                    return string;
                }
                return "No source found for " + stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + " at line " + stackTraceElement.getLineNumber();
            }
            catch (Throwable throwable) {
                return "No source found for " + stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName() + " at line " + stackTraceElement.getLineNumber();
            }
        }).collect(Collectors.joining("\n\n"));
    }

    public static String deepStackTraceElement(StackTraceElement stackTraceElement) {
        AtomicInteger atomicInteger = new AtomicInteger();
        return Curse.on(Class.forName(stackTraceElement.getClassName())).methods().filter(cursedMethod -> cursedMethod.method().getName().equals(stackTraceElement.getMethodName())).filter(cursedMethod -> {
            SourcePosition sourcePosition = cursedMethod.getSourcePosition();
            atomicInteger.set(sourcePosition.getLine());
            return stackTraceElement.getLineNumber() >= sourcePosition.getLine() && stackTraceElement.getLineNumber() <= sourcePosition.getEndLine();
        }).findFirst().map(cursedMethod -> {
            CharSequence[] charSequenceArray = cursedMethod.model().prettyprint().split("\\Q\n\\E");
            charSequenceArray[stackTraceElement.getLineNumber() - atomicInteger.get()] = ">>> " + charSequenceArray[stackTraceElement.getLineNumber() - atomicInteger.get()];
            return String.join((CharSequence)"\n", charSequenceArray);
        }).orElse(null);
    }

    public static void cursify(Class<?> clazz2) {
        String string;
        ArrayList<FuzzyField> arrayList = new ArrayList<FuzzyField>();
        ArrayList<FuzzyMethod> arrayList2 = new ArrayList<FuzzyMethod>();
        CursedComponent cursedComponent = Curse.on(clazz2);
        for (CursedField object22 : cursedComponent.fields().toList()) {
            System.out.println("F " + object22.field().getName());
            arrayList.add(FuzzyField.builder().possibleNames(List.of(object22.field().getName())).staticField(object22.isStatic()).type(object22.type()).build());
        }
        for (CursedMethod cursedMethod : cursedComponent.methods().toList()) {
            arrayList2.add(FuzzyMethod.builder().possibleNames(List.of(cursedMethod.method().getName())).staticMethod(Modifier.isStatic(cursedMethod.method().getModifiers())).returns(cursedMethod.method().getReturnType()).parameters(List.of(cursedMethod.method().getParameterTypes())).build());
        }
        Object object3 = TypeSpec.classBuilder("Cursed" + clazz2.getSimpleName());
        System.out.println("F " + arrayList.size() + " M " + arrayList2.size() + " C " + clazz2.getSimpleName());
        for (FuzzyField fuzzyField : arrayList) {
            if (fuzzyField.isStaticField()) {
                object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder("get_" + fuzzyField.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns((Type)((Object)Object.class)).addParameter(ParameterSpec.builder(Class.class, "c", new javax.lang.model.element.Modifier[0]).build()).addStatement("return Curse.on(c).fuzzyField(FuzzyField.builder().possibleNames(List.of($S)).staticField(true).type($T.class).build()).map(CursedField::get).orElse(null)", fuzzyField.getPossibleNames().get(0), fuzzyField.getType()).build());
                object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder("set_" + fuzzyField.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns(Void.TYPE).addParameter(ParameterSpec.builder(Class.class, "c", new javax.lang.model.element.Modifier[0]).build()).addParameter(ParameterSpec.builder(Object.class, "i", new javax.lang.model.element.Modifier[0]).build()).addStatement("Curse.on(c).fuzzyField(FuzzyField.builder().possibleNames(List.of($S)).staticField(true).type($T.class).build()).ifPresent(f -> f.set(i))", fuzzyField.getPossibleNames().get(0), fuzzyField.getType()).build());
                continue;
            }
            object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder("get_" + fuzzyField.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns((Type)((Object)Object.class)).addParameter(ParameterSpec.builder(Object.class, "i", new javax.lang.model.element.Modifier[0]).build()).addStatement("return Curse.on(i).fuzzyField(FuzzyField.builder().possibleNames(List.of($S)).staticField(false).type($T.class).build()).map(CursedField::get).orElse(null)", fuzzyField.getPossibleNames().get(0), fuzzyField.getType()).build());
            object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder("set_" + fuzzyField.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns(Void.TYPE).addParameter(ParameterSpec.builder(Object.class, "i", new javax.lang.model.element.Modifier[0]).build()).addParameter(ParameterSpec.builder(Object.class, "v", new javax.lang.model.element.Modifier[0]).build()).addStatement("Curse.on(i).fuzzyField(FuzzyField.builder().possibleNames(List.of($S)).staticField(false).type($T.class).build()).ifPresent(f -> f.set(v))", fuzzyField.getPossibleNames().get(0), fuzzyField.getType()).build());
        }
        for (FuzzyMethod fuzzyMethod : arrayList2) {
            AtomicInteger atomicInteger;
            String string2;
            string = fuzzyMethod.getReturns().equals(Void.TYPE) ? "" : "return ";
            String string3 = string2 = fuzzyMethod.getReturns().equals(Void.TYPE) ? "" : ".orElse(null)";
            if (fuzzyMethod.isStaticMethod()) {
                atomicInteger = new AtomicInteger(0);
                object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder(fuzzyMethod.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns(fuzzyMethod.getReturns().equals(Void.TYPE) ? Void.TYPE : Object.class).addParameter(ParameterSpec.builder(Class.class, "c", new javax.lang.model.element.Modifier[0]).build()).addParameters(fuzzyMethod.getParameters().stream().map(clazz -> ParameterSpec.builder(Object.class, "p" + atomicInteger.getAndIncrement(), new javax.lang.model.element.Modifier[0]).build()).collect(Collectors.toList())).addStatement(string + "Curse.on(c).fuzzyMethod(FuzzyMethod.builder().possibleNames(List.of($S)).staticMethod(true).returns($T.class).build()).map(CursedMethod::invoke)" + string2, fuzzyMethod.getPossibleNames().get(0), fuzzyMethod.getReturns()).build());
                continue;
            }
            atomicInteger = new AtomicInteger(0);
            object3 = ((TypeSpec.Builder)object3).addMethod(MethodSpec.methodBuilder(fuzzyMethod.getPossibleNames().get(0)).addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC).returns(fuzzyMethod.getReturns().equals(Void.TYPE) ? Void.TYPE : Object.class).addParameter(ParameterSpec.builder(Object.class, "i", new javax.lang.model.element.Modifier[0]).build()).addParameters(fuzzyMethod.getParameters().stream().map(clazz -> ParameterSpec.builder(Object.class, "p" + atomicInteger.getAndIncrement(), new javax.lang.model.element.Modifier[0]).build()).collect(Collectors.toList())).addStatement(string + "Curse.on(i).fuzzyMethod(FuzzyMethod.builder().possibleNames(List.of($S)).staticMethod(false).returns($T.class).build()).map(CursedMethod::invoke)" + string2, fuzzyMethod.getPossibleNames().get(0), fuzzyMethod.getReturns()).build());
        }
        JavaFile javaFile = JavaFile.builder("com.volmit.adapt.util.arcane.curse.gen.cursed", ((TypeSpec.Builder)object3).build()).build();
        ArrayList<String> arrayList3 = new ArrayList<String>(Arrays.asList(javaFile.toString().split("\\Q;\\E")));
        arrayList3.add(1, "\nimport art.arcane.curse.model.FuzzyField");
        arrayList3.add(1, "\nimport art.arcane.curse.model.FuzzyMethod");
        arrayList3.add(1, "\nimport art.arcane.curse.model.CursedField");
        arrayList3.add(1, "\nimport art.arcane.curse.model.CursedMethod");
        arrayList3.add(1, "\nimport art.arcane.curse.Curse");
        arrayList3.add(1, "\nimport java.lang.Object");
        arrayList3.add(1, "\nimport java.lang.String");
        arrayList3.add(1, "\nimport java.util.List");
        string = String.join((CharSequence)";", arrayList3);
        System.out.println(string);
    }
}

