/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor8;

public final class ClassName
extends TypeName
implements Comparable<ClassName> {
    public static final ClassName OBJECT = ClassName.get(Object.class);
    private static final String NO_PACKAGE = "";
    final String packageName;
    final ClassName enclosingClassName;
    final String simpleName;
    private List<String> simpleNames;
    final String canonicalName;

    private ClassName(String string, ClassName className, String string2) {
        this(string, className, string2, Collections.emptyList());
    }

    private ClassName(String string, ClassName className, String string2, List<AnnotationSpec> list) {
        super(list);
        this.packageName = Objects.requireNonNull(string, "packageName == null");
        this.enclosingClassName = className;
        this.simpleName = string2;
        this.canonicalName = className != null ? className.canonicalName + "." + string2 : (string.isEmpty() ? string2 : string + "." + string2);
    }

    @Override
    public ClassName annotated(List<AnnotationSpec> list) {
        return new ClassName(this.packageName, this.enclosingClassName, this.simpleName, this.concatAnnotations(list));
    }

    @Override
    public ClassName withoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        ClassName className = this.enclosingClassName != null ? this.enclosingClassName.withoutAnnotations() : null;
        return new ClassName(this.packageName, className, this.simpleName);
    }

    @Override
    public boolean isAnnotated() {
        return super.isAnnotated() || this.enclosingClassName != null && this.enclosingClassName.isAnnotated();
    }

    public String packageName() {
        return this.packageName;
    }

    public ClassName enclosingClassName() {
        return this.enclosingClassName;
    }

    public ClassName topLevelClassName() {
        return this.enclosingClassName != null ? this.enclosingClassName.topLevelClassName() : this;
    }

    public String reflectionName() {
        return this.enclosingClassName != null ? this.enclosingClassName.reflectionName() + "$" + this.simpleName : (this.packageName.isEmpty() ? this.simpleName : this.packageName + "." + this.simpleName);
    }

    public List<String> simpleNames() {
        if (this.simpleNames != null) {
            return this.simpleNames;
        }
        if (this.enclosingClassName == null) {
            this.simpleNames = Collections.singletonList(this.simpleName);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.enclosingClassName().simpleNames());
            arrayList.add(this.simpleName);
            this.simpleNames = Collections.unmodifiableList(arrayList);
        }
        return this.simpleNames;
    }

    public ClassName peerClass(String string) {
        return new ClassName(this.packageName, this.enclosingClassName, string);
    }

    public ClassName nestedClass(String string) {
        return new ClassName(this.packageName, this, string);
    }

    public String simpleName() {
        return this.simpleName;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public static ClassName get(Class<?> clazz) {
        Util.checkNotNull(clazz, "clazz == null", new Object[0]);
        Util.checkArgument(!clazz.isPrimitive(), "primitive types cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!Void.TYPE.equals(clazz), "'void' type cannot be represented as a ClassName", new Object[0]);
        Util.checkArgument(!clazz.isArray(), "array types cannot be represented as a ClassName", new Object[0]);
        Object object = NO_PACKAGE;
        while (clazz.isAnonymousClass()) {
            int n = clazz.getName().lastIndexOf(36);
            object = clazz.getName().substring(n) + (String)object;
            clazz = clazz.getEnclosingClass();
        }
        String string = clazz.getSimpleName() + (String)object;
        if (clazz.getEnclosingClass() == null) {
            int n = clazz.getName().lastIndexOf(46);
            String string2 = n != -1 ? clazz.getName().substring(0, n) : NO_PACKAGE;
            return new ClassName(string2, null, string);
        }
        return ClassName.get(clazz.getEnclosingClass()).nestedClass(string);
    }

    public static ClassName bestGuess(String string) {
        int n = 0;
        while (n < string.length() && Character.isLowerCase(string.codePointAt(n))) {
            Util.checkArgument((n = string.indexOf(46, n) + 1) != 0, "couldn't make a guess for %s", string);
        }
        String string2 = n == 0 ? NO_PACKAGE : string.substring(0, n - 1);
        ClassName className = null;
        for (String string3 : string.substring(n).split("\\.", -1)) {
            Util.checkArgument(!string3.isEmpty() && Character.isUpperCase(string3.codePointAt(0)), "couldn't make a guess for %s", string);
            className = new ClassName(string2, className, string3);
        }
        return className;
    }

    public static ClassName get(String string, String string2, String ... stringArray) {
        ClassName className = new ClassName(string, null, string2);
        for (String string3 : stringArray) {
            className = className.nestedClass(string3);
        }
        return className;
    }

    public static ClassName get(final TypeElement typeElement) {
        Util.checkNotNull(typeElement, "element == null", new Object[0]);
        final String string = typeElement.getSimpleName().toString();
        return typeElement.getEnclosingElement().accept(new SimpleElementVisitor8<ClassName, Void>(){

            @Override
            public ClassName visitPackage(PackageElement packageElement, Void void_) {
                return new ClassName(packageElement.getQualifiedName().toString(), null, string);
            }

            @Override
            public ClassName visitType(TypeElement typeElement2, Void void_) {
                return ClassName.get(typeElement2).nestedClass(string);
            }

            @Override
            public ClassName visitUnknown(Element element, Void void_) {
                return ClassName.get(ClassName.NO_PACKAGE, string, new String[0]);
            }

            @Override
            public ClassName defaultAction(Element element, Void void_) {
                throw new IllegalArgumentException("Unexpected type nesting: " + typeElement);
            }
        }, null);
    }

    @Override
    public int compareTo(ClassName className) {
        return this.canonicalName.compareTo(className.canonicalName);
    }

    @Override
    CodeWriter emit(CodeWriter codeWriter) {
        boolean bl = false;
        for (ClassName className : this.enclosingClasses()) {
            String string;
            if (bl) {
                codeWriter.emit(".");
                string = className.simpleName;
            } else {
                if (!className.isAnnotated() && className != this) continue;
                String string2 = codeWriter.lookupName(className);
                int n = string2.lastIndexOf(46);
                if (n != -1) {
                    codeWriter.emitAndIndent(string2.substring(0, n + 1));
                    string = string2.substring(n + 1);
                    bl = true;
                } else {
                    string = string2;
                }
            }
            if (className.isAnnotated()) {
                if (bl) {
                    codeWriter.emit(" ");
                }
                className.emitAnnotations(codeWriter);
            }
            codeWriter.emit(string);
            bl = true;
        }
        return codeWriter;
    }

    private List<ClassName> enclosingClasses() {
        ArrayList<ClassName> arrayList = new ArrayList<ClassName>();
        ClassName className = this;
        while (className != null) {
            arrayList.add(className);
            className = className.enclosingClassName;
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

