/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.FieldSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.MethodSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ParameterSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public final class CodeBlock {
    private static final Pattern NAMED_ARGUMENT = Pattern.compile("\\$(?<argumentName>[\\w_]+):(?<typeChar>[\\w]).*");
    private static final Pattern LOWERCASE = Pattern.compile("[a-z]+[\\w_]*");
    final List<String> formatParts;
    final List<Object> args;

    private CodeBlock(Builder builder) {
        this.formatParts = Util.immutableList(builder.formatParts);
        this.args = Util.immutableList(builder.args);
    }

    public boolean isEmpty() {
        return this.formatParts.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            new CodeWriter(stringBuilder).emit(this);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public static CodeBlock of(String string, Object ... objectArray) {
        return new Builder().add(string, objectArray).build();
    }

    public static CodeBlock join(Iterable<CodeBlock> iterable, String string) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(CodeBlock.joining(string));
    }

    public static Collector<CodeBlock, ?, CodeBlock> joining(String string) {
        return Collector.of(() -> new CodeBlockJoiner(string, CodeBlock.builder()), CodeBlockJoiner::add, CodeBlockJoiner::merge, CodeBlockJoiner::join, new Collector.Characteristics[0]);
    }

    public static Collector<CodeBlock, ?, CodeBlock> joining(String string, String string2, String string3) {
        Builder builder = CodeBlock.builder().add("$N", string2);
        return Collector.of(() -> new CodeBlockJoiner(string, builder), CodeBlockJoiner::add, CodeBlockJoiner::merge, (A codeBlockJoiner) -> {
            builder.add(CodeBlock.of("$N", string3));
            return codeBlockJoiner.join();
        }, new Collector.Characteristics[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.formatParts.addAll(this.formatParts);
        builder.args.addAll(this.args);
        return builder;
    }

    public static final class Builder {
        final List<String> formatParts = new ArrayList<String>();
        final List<Object> args = new ArrayList<Object>();

        private Builder() {
        }

        public boolean isEmpty() {
            return this.formatParts.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public Builder addNamed(String string, Map<String, ?> map) {
            int n = 0;
            for (String object : map.keySet()) {
                Util.checkArgument(LOWERCASE.matcher(object).matches(), "argument '%s' must start with a lowercase character", object);
            }
            while (n < string.length()) {
                void var5_10;
                int n2 = string.indexOf("$", n);
                if (n2 == -1) {
                    this.formatParts.add(string.substring(n));
                    break;
                }
                if (n != n2) {
                    this.formatParts.add(string.substring(n, n2));
                    n = n2;
                }
                Object var5_8 = null;
                int n3 = string.indexOf(58, n);
                if (n3 != -1) {
                    int n4 = Math.min(n3 + 2, string.length());
                    Matcher matcher = NAMED_ARGUMENT.matcher(string.substring(n, n4));
                }
                if (var5_10 != null && var5_10.lookingAt()) {
                    String string2 = var5_10.group("argumentName");
                    Util.checkArgument(map.containsKey(string2), "Missing named argument for $%s", string2);
                    char c = var5_10.group("typeChar").charAt(0);
                    this.addArgument(string, c, map.get(string2));
                    this.formatParts.add("$" + c);
                    n += var5_10.regionEnd();
                    continue;
                }
                Util.checkArgument(n < string.length() - 1, "dangling $ at end", new Object[0]);
                Util.checkArgument(this.isNoArgPlaceholder(string.charAt(n + 1)), "unknown format $%s at %s in '%s'", Character.valueOf(string.charAt(n + 1)), n + 1, string);
                this.formatParts.add(string.substring(n, n + 2));
                n += 2;
            }
            return this;
        }

        public Builder add(String string, Object ... objectArray) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            int[] nArray = new int[objectArray.length];
            int n3 = 0;
            while (n3 < string.length()) {
                int n4;
                char c;
                if (string.charAt(n3) != '$') {
                    n = string.indexOf(36, n3 + 1);
                    if (n == -1) {
                        n = string.length();
                    }
                    this.formatParts.add(string.substring(n3, n));
                    n3 = n;
                    continue;
                }
                n = ++n3;
                do {
                    Util.checkArgument(n3 < string.length(), "dangling format characters in '%s'", string);
                } while ((c = string.charAt(n3++)) >= '0' && c <= '9');
                int n5 = n3 - 1;
                if (this.isNoArgPlaceholder(c)) {
                    Util.checkArgument(n == n5, "$$, $>, $<, $[, $], $W, and $Z may not have an index", new Object[0]);
                    this.formatParts.add("$" + c);
                    continue;
                }
                if (n < n5) {
                    n4 = Integer.parseInt(string.substring(n, n5)) - 1;
                    bl2 = true;
                    if (objectArray.length > 0) {
                        int n6 = n4 % objectArray.length;
                        nArray[n6] = nArray[n6] + 1;
                    }
                } else {
                    n4 = n2++;
                    bl = true;
                }
                Util.checkArgument(n4 >= 0 && n4 < objectArray.length, "index %d for '%s' not in range (received %s arguments)", n4 + 1, string.substring(n - 1, n5 + 1), objectArray.length);
                Util.checkArgument(!bl2 || !bl, "cannot mix indexed and positional parameters", new Object[0]);
                this.addArgument(string, c, objectArray[n4]);
                this.formatParts.add("$" + c);
            }
            if (bl) {
                Util.checkArgument(n2 >= objectArray.length, "unused arguments: expected %s, received %s", n2, objectArray.length);
            }
            if (bl2) {
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (n = 0; n < objectArray.length; ++n) {
                    if (nArray[n] != 0) continue;
                    arrayList.add((CallSite)((Object)("$" + (n + 1))));
                }
                String string2 = arrayList.size() == 1 ? "" : "s";
                Util.checkArgument(arrayList.isEmpty(), "unused argument%s: %s", string2, String.join((CharSequence)", ", arrayList));
            }
            return this;
        }

        private boolean isNoArgPlaceholder(char c) {
            return c == '$' || c == '>' || c == '<' || c == '[' || c == ']' || c == 'W' || c == 'Z';
        }

        private void addArgument(String string, char c, Object object) {
            switch (c) {
                case 'N': {
                    this.args.add(this.argToName(object));
                    break;
                }
                case 'L': {
                    this.args.add(this.argToLiteral(object));
                    break;
                }
                case 'S': {
                    this.args.add(this.argToString(object));
                    break;
                }
                case 'T': {
                    this.args.add(this.argToType(object));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("invalid format string: '%s'", string));
                }
            }
        }

        private String argToName(Object object) {
            if (object instanceof CharSequence) {
                return object.toString();
            }
            if (object instanceof ParameterSpec) {
                return ((ParameterSpec)object).name;
            }
            if (object instanceof FieldSpec) {
                return ((FieldSpec)object).name;
            }
            if (object instanceof MethodSpec) {
                return ((MethodSpec)object).name;
            }
            if (object instanceof TypeSpec) {
                return ((TypeSpec)object).name;
            }
            throw new IllegalArgumentException("expected name but was " + object);
        }

        private Object argToLiteral(Object object) {
            return object;
        }

        private String argToString(Object object) {
            return object != null ? String.valueOf(object) : null;
        }

        private TypeName argToType(Object object) {
            if (object instanceof TypeName) {
                return (TypeName)object;
            }
            if (object instanceof TypeMirror) {
                return TypeName.get((TypeMirror)object);
            }
            if (object instanceof Element) {
                return TypeName.get(((Element)object).asType());
            }
            if (object instanceof Type) {
                return TypeName.get((Type)object);
            }
            throw new IllegalArgumentException("expected type but was " + object);
        }

        public Builder beginControlFlow(String string, Object ... objectArray) {
            this.add(string + " {\n", objectArray);
            this.indent();
            return this;
        }

        public Builder nextControlFlow(String string, Object ... objectArray) {
            this.unindent();
            this.add("} " + string + " {\n", objectArray);
            this.indent();
            return this;
        }

        public Builder endControlFlow() {
            this.unindent();
            this.add("}\n", new Object[0]);
            return this;
        }

        public Builder endControlFlow(String string, Object ... objectArray) {
            this.unindent();
            this.add("} " + string + ";\n", objectArray);
            return this;
        }

        public Builder addStatement(String string, Object ... objectArray) {
            this.add("$[", new Object[0]);
            this.add(string, objectArray);
            this.add(";\n$]", new Object[0]);
            return this;
        }

        public Builder addStatement(CodeBlock codeBlock) {
            return this.addStatement("$L", codeBlock);
        }

        public Builder add(CodeBlock codeBlock) {
            this.formatParts.addAll(codeBlock.formatParts);
            this.args.addAll(codeBlock.args);
            return this;
        }

        public Builder indent() {
            this.formatParts.add("$>");
            return this;
        }

        public Builder unindent() {
            this.formatParts.add("$<");
            return this;
        }

        public Builder clear() {
            this.formatParts.clear();
            this.args.clear();
            return this;
        }

        public CodeBlock build() {
            return new CodeBlock(this);
        }
    }

    private static final class CodeBlockJoiner {
        private final String delimiter;
        private final Builder builder;
        private boolean first = true;

        CodeBlockJoiner(String string, Builder builder) {
            this.delimiter = string;
            this.builder = builder;
        }

        CodeBlockJoiner add(CodeBlock codeBlock) {
            if (!this.first) {
                this.builder.add(this.delimiter, new Object[0]);
            }
            this.first = false;
            this.builder.add(codeBlock);
            return this;
        }

        CodeBlockJoiner merge(CodeBlockJoiner codeBlockJoiner) {
            CodeBlock codeBlock = codeBlockJoiner.builder.build();
            if (!codeBlock.isEmpty()) {
                this.add(codeBlock);
            }
            return this;
        }

        CodeBlock join() {
            return this.builder.build();
        }
    }
}

