/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public final class WildcardTypeName
extends TypeName {
    public final List<TypeName> upperBounds;
    public final List<TypeName> lowerBounds;

    private WildcardTypeName(List<TypeName> list, List<TypeName> list2) {
        this(list, list2, new ArrayList<AnnotationSpec>());
    }

    private WildcardTypeName(List<TypeName> list, List<TypeName> list2, List<AnnotationSpec> list3) {
        super(list3);
        this.upperBounds = Util.immutableList(list);
        this.lowerBounds = Util.immutableList(list2);
        Util.checkArgument(this.upperBounds.size() == 1, "unexpected extends bounds: %s", list);
        for (TypeName typeName : this.upperBounds) {
            Util.checkArgument(!typeName.isPrimitive() && typeName != VOID, "invalid upper bound: %s", typeName);
        }
        for (TypeName typeName : this.lowerBounds) {
            Util.checkArgument(!typeName.isPrimitive() && typeName != VOID, "invalid lower bound: %s", typeName);
        }
    }

    @Override
    public WildcardTypeName annotated(List<AnnotationSpec> list) {
        return new WildcardTypeName(this.upperBounds, this.lowerBounds, this.concatAnnotations(list));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new WildcardTypeName(this.upperBounds, this.lowerBounds);
    }

    @Override
    CodeWriter emit(CodeWriter codeWriter) {
        if (this.lowerBounds.size() == 1) {
            return codeWriter.emit("? super $T", this.lowerBounds.get(0));
        }
        return this.upperBounds.get(0).equals(OBJECT) ? codeWriter.emit("?") : codeWriter.emit("? extends $T", this.upperBounds.get(0));
    }

    public static WildcardTypeName subtypeOf(TypeName typeName) {
        return new WildcardTypeName(Collections.singletonList(typeName), Collections.emptyList());
    }

    public static WildcardTypeName subtypeOf(Type type) {
        return WildcardTypeName.subtypeOf(WildcardTypeName.get(type));
    }

    public static WildcardTypeName supertypeOf(TypeName typeName) {
        return new WildcardTypeName(Collections.singletonList(OBJECT), Collections.singletonList(typeName));
    }

    public static WildcardTypeName supertypeOf(Type type) {
        return WildcardTypeName.supertypeOf(WildcardTypeName.get(type));
    }

    public static TypeName get(javax.lang.model.type.WildcardType wildcardType) {
        return WildcardTypeName.get(wildcardType, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static TypeName get(javax.lang.model.type.WildcardType wildcardType, Map<TypeParameterElement, TypeVariableName> map) {
        TypeMirror typeMirror = wildcardType.getExtendsBound();
        if (typeMirror == null) {
            TypeMirror typeMirror2 = wildcardType.getSuperBound();
            if (typeMirror2 == null) {
                return WildcardTypeName.subtypeOf(Object.class);
            }
            return WildcardTypeName.supertypeOf(WildcardTypeName.get(typeMirror2, map));
        }
        return WildcardTypeName.subtypeOf(WildcardTypeName.get(typeMirror, map));
    }

    public static TypeName get(WildcardType wildcardType) {
        return WildcardTypeName.get(wildcardType, new LinkedHashMap<Type, TypeVariableName>());
    }

    static TypeName get(WildcardType wildcardType, Map<Type, TypeVariableName> map) {
        return new WildcardTypeName(WildcardTypeName.list(wildcardType.getUpperBounds(), map), WildcardTypeName.list(wildcardType.getLowerBounds(), map));
    }
}

