/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HashPalette<T>
implements Palette<T> {
    private final Map<T, Integer> palette;
    private final Map<Integer, T> lookup;
    private final AtomicInteger size = new AtomicInteger(0);

    public HashPalette() {
        this.palette = new LinkedHashMap<T, Integer>();
        this.lookup = new ConcurrentHashMap<Integer, T>();
        this.add(null);
    }

    @Override
    public T get(int n) {
        if (n < 0 || n >= this.size.get()) {
            return null;
        }
        return this.lookup.get(n);
    }

    @Override
    public int add(T t) {
        int n = this.size.getAndIncrement();
        this.palette.put(t, n);
        if (t != null) {
            this.lookup.put(n, t);
        }
        return n;
    }

    @Override
    public int id(T t) {
        if (t == null) {
            return 0;
        }
        Integer n = this.palette.get(t);
        return n != null ? n : -1;
    }

    @Override
    public int size() {
        return this.size.get() - 1;
    }

    @Override
    public void iterate(Consume.Two<T, Integer> two) {
        for (T t : this.palette.keySet()) {
            if (t == null) continue;
            two.accept(t, this.id(t));
        }
    }
}

