/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter;

import com.volmit.adapt.util.arcane.spatial.matter.MatterHeader;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.arcane.spatial.util.Pos;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface Matter {
    public static final int VERSION = 1;

    public static Matter read(File f) throws IOException, ClassNotFoundException {
        FileInputStream in = new FileInputStream(f);
        Matter m = Matter.read(in);
        in.close();
        return m;
    }

    public static Matter read(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Matter m = Matter.read(in);
        ((InputStream)in).close();
        return m;
    }

    default public Matter copy() {
        SpatialMatter m = new SpatialMatter(this.getWidth(), this.getHeight(), this.getDepth());
        this.getSliceMap().forEach((k, v) -> m.slice((Class<?>)k).forceInject((MatterSlice<?>)v));
        return m;
    }

    public static Matter read(InputStream in) throws IOException, ClassNotFoundException {
        return Matter.read(in, b -> new SpatialMatter(b.getX(), b.getY(), b.getZ()));
    }

    public static Matter readDin(DataInputStream in) throws IOException, ClassNotFoundException {
        return Matter.readDin(in, b -> new SpatialMatter(b.getX(), b.getY(), b.getZ()));
    }

    public static Matter read(InputStream in, Function<Pos, Matter> matterFactory) throws IOException, ClassNotFoundException {
        return Matter.readDin(new DataInputStream(in), matterFactory);
    }

    public static Matter readDin(DataInputStream din, Function<Pos, Matter> matterFactory) throws IOException, ClassNotFoundException {
        Matter matter = matterFactory.apply(new Pos(din.readInt(), din.readInt(), din.readInt()));
        int sliceCount = din.readByte();
        matter.getHeader().read(din);
        for (int i = 0; i < sliceCount; ++i) {
            String cn = din.readUTF();
            try {
                Class<?> type = Class.forName(cn);
                MatterSlice<?> slice = matter.createSlice(matter.getClass(type), matter);
                slice.read(din);
                matter.putSlice(matter.getClass(type), slice);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IOException("Can't read class '" + cn + "' (slice count reverse at " + sliceCount + ")");
            }
        }
        return matter;
    }

    public MatterHeader getHeader();

    public int getWidth();

    public int getHeight();

    public int getDepth();

    default public Pos getCenter() {
        return new Pos(this.getCenterX(), this.getCenterY(), this.getCenterZ());
    }

    public <T> MatterSlice<T> createSlice(Class<T> var1, Matter var2);

    default public Pos getSize() {
        return new Pos(this.getWidth(), this.getHeight(), this.getDepth());
    }

    default public int getCenterX() {
        return (int)Math.round((double)this.getWidth() / 2.0);
    }

    default public int getCenterY() {
        return (int)Math.round((double)this.getHeight() / 2.0);
    }

    default public int getCenterZ() {
        return (int)Math.round((double)this.getDepth() / 2.0);
    }

    default public <T> MatterSlice<T> getSlice(Class<T> t) {
        return this.getSliceMap().get(this.getClass(t));
    }

    default public <T> MatterSlice<T> deleteSlice(Class<?> c) {
        return this.getSliceMap().remove(this.getClass(c));
    }

    default public <T> MatterSlice<T> putSlice(Class<?> c, MatterSlice<T> slice) {
        return this.getSliceMap().put(this.getClass(c), slice);
    }

    default public Class<?> getClass(Object w) {
        if (w instanceof Integer) {
            return Integer.class;
        }
        if (w instanceof Double) {
            return Double.class;
        }
        if (w instanceof Boolean) {
            return Boolean.class;
        }
        if (w instanceof Short) {
            return Short.class;
        }
        if (w instanceof Long) {
            return Long.class;
        }
        if (w instanceof Float) {
            return Float.class;
        }
        if (w instanceof Byte) {
            return Byte.class;
        }
        if (w instanceof Character) {
            return Character.class;
        }
        return w.getClass();
    }

    default public Class<?> getClass(Class<?> w) {
        if (w.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (w.equals(Double.TYPE)) {
            return Double.class;
        }
        if (w.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (w.equals(Short.TYPE)) {
            return Short.class;
        }
        if (w.equals(Long.TYPE)) {
            return Long.class;
        }
        if (w.equals(Float.TYPE)) {
            return Float.class;
        }
        if (w.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (w.equals(Character.TYPE)) {
            return Character.class;
        }
        return w;
    }

    default public <T> MatterSlice<T> slice(Class<?> c) {
        MatterSlice<?> slice = this.getSlice(this.getClass(c));
        if (slice == null) {
            slice = this.createSlice(this.getClass(c), this);
            if (slice == null) {
                try {
                    throw new RuntimeException("Bad slice " + c.getCanonicalName() + ". Did you use SpatialMatter.register?");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }
            this.putSlice(this.getClass(c), slice);
        }
        return slice;
    }

    default public boolean hasSlice(Class<?> c) {
        return this.getSlice(c) != null;
    }

    default public void clearSlices() {
        this.getSliceMap().clear();
    }

    default public Set<Class<?>> getSliceTypes() {
        return this.getSliceMap().keySet();
    }

    public Map<Class<?>, MatterSlice<?>> getSliceMap();

    default public void write(File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        this.write(out);
        ((OutputStream)out).close();
    }

    default public byte[] write() throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        this.write(boas);
        return boas.toByteArray();
    }

    default public void trimSlices() {
        HashSet drop = null;
        for (Class<Object> i : this.getSliceTypes()) {
            if (this.getSlice(i).getEntryCount() != 0) continue;
            if (drop == null) {
                drop = new HashSet();
            }
            drop.add(i);
        }
        if (drop != null) {
            for (Class<Object> i : drop) {
                this.deleteSlice(i);
            }
        }
    }

    default public void write(OutputStream out) throws IOException {
        this.writeDos(new DataOutputStream(out));
    }

    default public void writeDos(DataOutputStream dos) throws IOException {
        this.trimSlices();
        dos.writeInt(this.getWidth());
        dos.writeInt(this.getHeight());
        dos.writeInt(this.getDepth());
        dos.writeByte(this.getSliceTypes().size());
        this.getHeader().write(dos);
        for (Class<?> i : this.getSliceTypes()) {
            this.getSlice(i).write(dos);
        }
    }

    default public int getTotalCount() {
        int m = 0;
        for (MatterSlice<?> i : this.getSliceMap().values()) {
            m += i.getEntryCount();
        }
        return m;
    }
}

