/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.util;

import java.io.DataInput;
import java.io.DataOutput;

public final class Varint {
    private Varint() {
    }

    public static void writeSignedVarLong(long l, DataOutput dataOutput) {
        Varint.writeUnsignedVarLong(l << 1 ^ l >> 63, dataOutput);
    }

    public static void writeUnsignedVarLong(long l, DataOutput dataOutput) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            dataOutput.writeByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
        dataOutput.writeByte((int)l & 0x7F);
    }

    public static void writeSignedVarInt(int n, DataOutput dataOutput) {
        Varint.writeUnsignedVarInt(n << 1 ^ n >> 31, dataOutput);
    }

    public static void writeUnsignedVarInt(int n, DataOutput dataOutput) {
        while ((long)(n & 0xFFFFFF80) != 0L) {
            dataOutput.writeByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
        dataOutput.writeByte(n & 0x7F);
    }

    public static byte[] writeSignedVarInt(int n) {
        return Varint.writeUnsignedVarInt(n << 1 ^ n >> 31);
    }

    public static byte[] writeUnsignedVarInt(int n) {
        byte[] byArray = new byte[10];
        int n2 = 0;
        while ((long)(n & 0xFFFFFF80) != 0L) {
            byArray[n2++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        byArray[n2] = (byte)(n & 0x7F);
        byte[] byArray2 = new byte[n2 + 1];
        while (n2 >= 0) {
            byArray2[n2] = byArray[n2];
            --n2;
        }
        return byArray2;
    }

    public static long readSignedVarLong(DataInput dataInput) {
        long l = Varint.readUnsignedVarLong(dataInput);
        long l2 = (l << 63 >> 63 ^ l) >> 1;
        return l2 ^ l & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput dataInput) {
        long l;
        long l2 = 0L;
        int n = 0;
        while (((l = (long)dataInput.readByte()) & 0x80L) != 0L) {
            l2 |= (l & 0x7FL) << n;
            if ((n += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return l2 | l << n;
    }

    public static int readSignedVarInt(DataInput dataInput) {
        int n = Varint.readUnsignedVarInt(dataInput);
        int n2 = (n << 31 >> 31 ^ n) >> 1;
        return n2 ^ n & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput dataInput) {
        byte by;
        int n = 0;
        int n2 = 0;
        while (((by = dataInput.readByte()) & 0x80) != 0) {
            n |= (by & 0x7F) << n2;
            if ((n2 += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return n | by << n2;
    }

    public static int readSignedVarInt(byte[] byArray) {
        int n = Varint.readUnsignedVarInt(byArray);
        int n2 = (n << 31 >> 31 ^ n) >> 1;
        return n2 ^ n & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -128;
        byte[] byArray2 = byArray;
        int n4 = byArray2.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            n3 = n5 = byArray2[i];
            if ((n5 & 0x80) == 0) break;
            n |= (n5 & 0x7F) << n2;
            if ((n2 += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long");
        }
        return n | n3 << n2;
    }
}

