/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.util.Set;

import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.stream.Stream.XStream;
import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.ext.rt.api.Self;
import com.volmit.adapt.util.manifold.ext.rt.api.This;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import com.volmit.adapt.util.manifold.util.concurrent.ConcurrentHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@Extension
public class XSet {
    @Self
    public static <E> Set<E> copy(@This Set<E> set) {
        return XSet.copy(set, HashSet::new);
    }

    @Self
    public static <E> Set<E> unmodifiable(@This Set<E> set) {
        return Collections.unmodifiableSet(set);
    }

    @Self
    public static <E> Set<E> copy(@This Set<E> set, Supplier<Set<E>> supplier) {
        Set<E> set2 = supplier.get();
        set2.addAll(set);
        return set2;
    }

    public static <E> boolean isNotEmpty(@This Set<E> set) {
        return !set.isEmpty();
    }

    @SafeVarargs
    @Self
    public static <E> Set<E> add(@This Set<E> set, E ... EArray) {
        Collections.addAll(set, EArray);
        return set;
    }

    @Self
    public static <E> Set<E> add(@This Set<E> set, Set<E> set2) {
        set.addAll(set2);
        return set;
    }

    @SafeVarargs
    @Self
    public static <E> Set<E> remove(@This Set<E> set, E ... EArray) {
        for (E e : EArray) {
            set.remove(e);
        }
        return set;
    }

    @Self
    public static <E> Set<E> remove(@This Set<E> set, Set<E> set2) {
        for (E e : set2) {
            set.remove(e);
        }
        return set;
    }

    @Self
    public static <E> Set<E> removeWhere(@This Set<E> set, Predicate<E> predicate) {
        if (set.isEmpty()) {
            return set;
        }
        Set set2 = XStream.toSet(set.stream().filter(predicate.negate()));
        set.clear();
        set.addAll(set2);
        return set;
    }

    @Self
    public static <E> Set<E> keepWhere(@This Set<E> set, Predicate<E> predicate) {
        return XSet.removeWhere(set, predicate.negate());
    }

    @Self
    public static <E, R> Set<R> convert(@This Set<E> set, Function<E, R> function) {
        HashSet<R> hashSet = new HashSet<R>();
        for (E e : set) {
            R r = function.apply(e);
            if (r == null) continue;
            hashSet.add(r);
        }
        return hashSet;
    }

    public static <E> E pop(@This Set<E> set) {
        if (set.isEmpty()) {
            return null;
        }
        Iterator<E> iterator = set.iterator();
        E e = iterator.next();
        iterator.remove();
        return e;
    }

    public static <E> E getFirst(@This Set<E> set) {
        if (set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    @Extension
    public static <E> ConcurrentHashSet<E> concurrent() {
        return new ConcurrentHashSet();
    }

    @Extension
    public static <E> HashSet<E> hash() {
        return new HashSet();
    }

    @Extension
    public static <E> LinkedHashSet<E> linked() {
        return new LinkedHashSet();
    }

    @Extension
    public static <E> CopyOnWriteArraySet<E> copyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @Extension
    public static <E> Set<E> from(Collection<E> collection) {
        return XSet.from(collection, HashSet::new);
    }

    @Extension
    public static <E> Set<E> from(Collection<E> collection, Supplier<Set<E>> supplier) {
        Set<E> set = supplier.get();
        set.addAll(collection);
        return set;
    }

    @SafeVarargs
    @Extension
    public static <E> Set<E> from(E ... EArray) {
        return XSet.from(HashSet::new, EArray);
    }

    @SafeVarargs
    public static <E> Set<E> from(Supplier<Set<E>> supplier, E ... EArray) {
        Set<E> set = supplier.get();
        XSet.add(set, EArray);
        return set;
    }

    @Self
    public static <E> Set<E> qclear(@This Set<E> set) {
        set.clear();
        return set;
    }

    public static <E> List<E> list(@This Set<E> set) {
        return XList.from(set);
    }

    @Self
    public static <E> Set<E> minus(@This Set<E> set, E e) {
        Set<E> set2 = XSet.from(set);
        set2.remove(e);
        return set2;
    }

    @Self
    public static <E> Set<E> minus(@This Set<E> set, Collection<E> collection) {
        Set<E> set2 = XSet.from(set);
        set2.removeAll(collection);
        return set2;
    }

    public static <E> String toString(@This Set<E> set, String string) {
        if (set.isEmpty()) {
            return "";
        }
        if (set.size() == 1) {
            return "" + XSet.getFirst(set);
        }
        Iterator<E> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            E e = iterator.next();
            stringBuilder.append(string).append(e);
        }
        return stringBuilder.substring(string.length());
    }

    static {
        IBootstrap.dasBoot();
    }
}

