/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.adaptation;

import com.google.common.collect.ImmutableSet;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.Component;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.potion.BrewingRecipe;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.content.event.AdaptAdaptationUseEvent;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.UIElement;
import com.volmit.adapt.util.UIWindow;
import com.volmit.adapt.util.WindowResolution;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Recipe;

public interface Adaptation<T>
extends Ticked,
Component {
    public int getMaxLevel();

    default public void xp(Player p, double amount) {
        this.getSkill().xp(p, amount);
    }

    default public void xp(Player p, Location l, double amount) {
        this.getSkill().xp(p, l, amount);
    }

    default public <F> F getStorage(Player p, String key, F defaultValue) {
        PlayerData data = this.getPlayer(p).getData();
        if (data.getSkillLines().containsKey(this.getSkill().getName()) && data.getSkillLines().get(this.getSkill().getName()).getAdaptations().containsKey(this.getName())) {
            Object o = data.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getStorage().get(key);
            return (F)(o == null ? defaultValue : o);
        }
        return defaultValue;
    }

    default public <F> F getStorage(Player p, String key) {
        return this.getStorage(p, key, null);
    }

    default public boolean setStorage(Player p, String key, Object value) {
        PlayerData data = this.getPlayer(p).getData();
        if (data.getSkillLines().containsKey(this.getSkill().getName()) && data.getSkillLines().get(this.getSkill().getName()).getAdaptations().containsKey(this.getName())) {
            data.getSkillLines().get(this.getSkill().getName()).getAdaptations().get(this.getName()).getStorage().put(key, value);
            return true;
        }
        return false;
    }

    default public boolean canUse(AdaptPlayer player) {
        Adapt.verbose("Checking if " + player.getPlayer().getName() + " can use " + this.getName() + "...");
        AdaptAdaptationUseEvent e = new AdaptAdaptationUseEvent(!Bukkit.isPrimaryThread(), player, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)e);
        return !e.isCancelled();
    }

    default public boolean canUse(Player player) {
        return this.canUse(this.getPlayer(player));
    }

    default public boolean hasBlacklistPermission(Player p, Adaptation a) {
        if (p.isOp()) {
            return false;
        }
        String blacklistPermission = "adapt.blacklist." + a.getName().replaceAll("-", "");
        Adapt.verbose("Checking if player " + p.getName() + " has blacklist permission " + blacklistPermission);
        return p.hasPermission(blacklistPermission);
    }

    default public String getStorageString(Player p, String key, String defaultValue) {
        return this.getStorage(p, key, defaultValue);
    }

    default public String getStorageString(Player p, String key) {
        return (String)this.getStorage(p, key);
    }

    default public Integer getStorageInt(Player p, String key, Integer defaultValue) {
        return this.getStorage(p, key, defaultValue);
    }

    default public Integer getStorageInt(Player p, String key) {
        return (Integer)this.getStorage(p, key);
    }

    default public Double getStorageDouble(Player p, String key, Double defaultValue) {
        return this.getStorage(p, key, defaultValue);
    }

    default public Double getStorageDouble(Player p, String key) {
        return (Double)this.getStorage(p, key);
    }

    default public Boolean getStorageBoolean(Player p, String key, Boolean defaultValue) {
        return this.getStorage(p, key, defaultValue);
    }

    default public Boolean getStorageBoolean(Player p, String key) {
        return (Boolean)this.getStorage(p, key);
    }

    default public Long getStorageLong(Player p, String key, Long defaultValue) {
        return this.getStorage(p, key, defaultValue);
    }

    default public Long getStorageLong(Player p, String key) {
        return (Long)this.getStorage(p, key);
    }

    public Class<T> getConfigurationClass();

    public void registerConfiguration(Class<T> var1);

    public boolean isEnabled();

    public boolean isPermanent();

    public T getConfig();

    public AdaptAdvancement buildAdvancements();

    public void addStats(int var1, Element var2);

    public int getBaseCost();

    public String getDescription();

    public Material getIcon();

    public Skill<?> getSkill();

    public void setSkill(Skill<?> var1);

    public String getName();

    public int getInitialCost();

    public double getCostFactor();

    public List<AdaptRecipe> getRecipes();

    public List<BrewingRecipe> getBrewingRecipes();

    public void onRegisterAdvancements(List<AdaptAdvancement> var1);

    default public Set<Protector> getProtectors() {
        HashSet<Protector> protectors = new HashSet<Protector>(Adapt.instance.getProtectorRegistry().getDefaultProtectors());
        Map<String, Boolean> overrides = AdaptConfig.get().getProtectionOverrides().getOrDefault(this.getName(), Collections.emptyMap());
        overrides.forEach((protector, enabled) -> {
            if (enabled.booleanValue()) {
                Protector p = Adapt.instance.getProtectorRegistry().getAllProtectors().stream().filter(pr -> pr.getName().equals(protector)).findFirst().orElse(null);
                if (p == null) {
                    Adapt.error("Could not find protector " + protector + " for adaptation " + this.getName() + ". Skipping...");
                } else {
                    protectors.add(p);
                }
            } else {
                protectors.removeIf(pr -> pr.getName().equals(protector));
            }
        });
        return ImmutableSet.copyOf(protectors);
    }

    default public boolean canBlockBreak(Player player, Location blockLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canBlockBreak(player, blockLocation, this));
    }

    default public boolean canBlockPlace(Player player, Location blockLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canBlockPlace(player, blockLocation, this));
    }

    default public boolean canPVP(Player player, Location victimLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canPVP(player, victimLocation, this));
    }

    default public boolean canPVE(Player player, Location victimLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canPVE(player, victimLocation, this));
    }

    default public boolean canInteract(Player player, Location targetLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canInteract(player, targetLocation, this));
    }

    default public boolean canAccessChest(Player player, Location chestLocation) {
        return this.getProtectors().stream().allMatch(protector -> protector.canAccessChest(player, chestLocation, this));
    }

    default public boolean checkRegion(Player player) {
        return this.getProtectors().stream().allMatch(protector -> protector.checkRegion(player, player.getLocation(), this));
    }

    default public boolean hasAdaptation(Player p) {
        try {
            if (p == null || p.isDead()) {
                return false;
            }
            if (!this.getSkill().isEnabled()) {
                Adapt.verbose("Skill " + this.getSkill().getName() + " is disabled. Skipping adaptation " + this.getName());
                this.unregister();
            }
            if (this.getLevel(p) > 0) {
                if (AdaptConfig.get().blacklistedWorlds.contains(p.getWorld().getName())) {
                    Adapt.verbose("Player " + p.getName() + " is in a blacklisted world. Skipping adaptation " + this.getName());
                    return false;
                }
                if (p.getGameMode().equals((Object)GameMode.CREATIVE) || p.getGameMode().equals((Object)GameMode.SPECTATOR)) {
                    Adapt.verbose("Player " + p.getName() + " is in creative or spectator mode. Skipping adaptation " + this.getName());
                    return false;
                }
                if (!this.checkRegion(p)) {
                    Adapt.verbose("Player " + p.getName() + " don't have adaptation - " + this.getName() + " permission.");
                    return false;
                }
                if (this.hasBlacklistPermission(p, this)) {
                    Adapt.verbose("Player " + p.getName() + " has blacklist permission for adaptation " + this.getName());
                    return false;
                }
                if (!this.canUse(p)) {
                    Adapt.verbose("Player " + p.getName() + " can't use adaptation, This is an API restriction" + this.getName());
                    return false;
                }
                Adapt.verbose("Player " + p.getName() + " used adaptation " + this.getName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) {
                Adapt.verbose("Citizens/PacketSpoofing is Messing stuff up again. I hate it.");
                Adapt.verbose(e.getMessage());
            } else {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    default public int getLevel(Player p) {
        if (p == null) {
            return 0;
        }
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            Adapt.verbose("Simple name: " + p.getClass().getSimpleName());
            return 0;
        }
        if (!this.getSkill().isEnabled()) {
            this.unregister();
            return 0;
        }
        PlayerSkillLine line = this.getPlayer(p).getData().getSkillLine(this.getSkill().getName());
        if (line == null) {
            return 0;
        }
        return this.getPlayer(p).getData().getSkillLine(this.getSkill().getName()).getAdaptationLevel(this.getName());
    }

    default public double getLevelPercent(Player p) {
        if (!this.getSkill().isEnabled()) {
            this.unregister();
        }
        if (!p.getClass().getSimpleName().equals("CraftPlayer")) {
            return 0.0;
        }
        return Math.min(Math.max(0.0, M.lerpInverse(0.0, this.getMaxLevel(), this.getLevel(p))), 1.0);
    }

    default public double getLevelPercent(int p) {
        return Math.min(Math.max(0.0, M.lerpInverse(0.0, this.getMaxLevel(), p)), 1.0);
    }

    default public int getCostFor(int level) {
        return (int)Math.max(1.0, (double)this.getBaseCost() + (double)this.getBaseCost() * ((double)level * this.getCostFactor())) + (level == 1 ? this.getInitialCost() : 0);
    }

    default public int getPowerCostFor(int level, int myLevel) {
        return level - myLevel;
    }

    default public int getCostFor(int level, int myLevel) {
        if (myLevel >= level) {
            return 0;
        }
        int c = 0;
        for (int i = myLevel + 1; i <= level; ++i) {
            c += this.getCostFor(i);
        }
        return c;
    }

    default public int getRefundCostFor(int level, int myLevel) {
        if (myLevel <= level) {
            return 0;
        }
        int c = 0;
        for (int i = level + 1; i <= myLevel; ++i) {
            c += this.getCostFor(i);
        }
        return c;
    }

    default public String getDisplayName() {
        if (!this.getSkill().isEnabled()) {
            this.unregister();
        }
        return C.RESET + C.BOLD + this.getSkill().getColor().toString() + Form.capitalizeWords(this.getName().replaceAll("\\Q" + this.getSkill().getName() + "-\\E", "").replaceAll("\\Q-\\E", " "));
    }

    default public String getDisplayName(int level) {
        if (!this.getSkill().isEnabled()) {
            this.unregister();
        }
        if (level >= 1) {
            return this.getDisplayName() + C.RESET + " " + C.UNDERLINE + C.WHITE + Form.toRoman(level) + C.RESET;
        }
        return this.getDisplayName();
    }

    default public String getDisplayNameNoRoman(int level) {
        if (level >= 1) {
            return this.getDisplayName() + C.RESET + " " + C.UNDERLINE + C.WHITE + level + C.RESET;
        }
        return this.getDisplayName();
    }

    default public BlockFace getBlockFace(Player player, int maxrange) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, maxrange);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    default public boolean openGui(Player player, boolean checkPermissions) {
        if (this.hasBlacklistPermission(player, this)) {
            return false;
        }
        this.openGui(player);
        return true;
    }

    default public void openGui(Player player) {
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.1f, 1.255f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.7f, 0.655f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.3f, 0.855f);
        UIWindow w = new UIWindow(player);
        w.setTag("skill/" + this.getSkill().getName() + "/" + this.getName());
        w.setDecorator((window, position, row) -> new UIElement("bg").setName(" ").setMaterial(new MaterialBlock(Material.BLACK_STAINED_GLASS_PANE)));
        w.setResolution(WindowResolution.W9_H6);
        int o = 0;
        if (this.getMaxLevel() == 1 || this.getMaxLevel() == 2) {
            o = 4;
        }
        if (this.getMaxLevel() == 3 || this.getMaxLevel() == 4) {
            o = 3;
        }
        if (this.getMaxLevel() == 5 || this.getMaxLevel() == 6) {
            o = 2;
        }
        if (this.getMaxLevel() == 7 || this.getMaxLevel() == 8) {
            o = 1;
        }
        int mylevel = this.getPlayer(player).getSkillLine(this.getSkill().getName()).getAdaptationLevel(this.getName());
        long k = this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).getKnowledge();
        for (int i = 1; i <= this.getMaxLevel(); ++i) {
            int pos = w.getPosition(i - 1 + o);
            int row2 = 1;
            int c = this.getCostFor(i, mylevel);
            int rc = this.getRefundCostFor(i - 1, mylevel);
            int pc = this.getPowerCostFor(i, mylevel);
            int lvl = i;
            Element de = new UIElement("lp-" + i + "g").setMaterial(new MaterialBlock(this.getIcon())).setName(this.getDisplayName(i)).setEnchanted(mylevel >= lvl).setProgress(1.0).addLore(Form.wrapWordsPrefixed(this.getDescription(), "" + C.GRAY, 40)).addLore((String)(mylevel >= lvl ? "" : C.WHITE + c + C.GRAY + " " + Localizer.dLocalize("snippets", "adaptmenu", "knowledgecost") + " " + (String)(AdaptConfig.get().isHardcoreNoRefunds() ? C.DARK_RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "norefunds") : ""))).addLore((String)(mylevel >= lvl ? (AdaptConfig.get().isHardcoreNoRefunds() ? C.GREEN + Localizer.dLocalize("snippets", "adaptmenu", "alreadylearned") + " " + C.DARK_RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "norefunds") : (this.isPermanent() ? "" : C.GREEN + Localizer.dLocalize("snippets", "adaptmenu", "alreadylearned") + " " + C.GRAY + Localizer.dLocalize("snippets", "adaptmenu", "unlearnrefund") + " " + C.GREEN + rc + " " + Localizer.dLocalize("snippets", "adaptmenu", "knowledgecost"))) : (k >= (long)c ? C.BLUE + Localizer.dLocalize("snippets", "adaptmenu", "clicklearn") + " " + this.getDisplayName(i) : (k == 0L ? C.RED + Localizer.dLocalize("snippets", "adaptmenu", "noknowledge") : C.RED + "(" + Localizer.dLocalize("snippets", "adaptmenu", "youonlyhave") + " " + C.WHITE + k + C.RED + " " + Localizer.dLocalize("snippets", "adaptmenu", "knowledgeavailable") + ")")))).addLore(mylevel < lvl && this.getPlayer(player).getData().hasPowerAvailable(pc) ? C.GREEN + lvl + " " + Localizer.dLocalize("snippets", "adaptmenu", "powerdrain") : (mylevel >= lvl ? C.GREEN + lvl + " " + Localizer.dLocalize("snippets", "adaptmenu", "powerdrain") : C.RED + Localizer.dLocalize("snippets", "adaptmenu", "notenoughpower") + "\n" + C.RED + Localizer.dLocalize("snippets", "adaptmenu", "howtolevelup"))).addLore((String)(this.isPermanent() ? C.RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "maynotunlearn") : "")).onLeftClick(e -> {
                if (mylevel >= lvl) {
                    this.unlearn(player, lvl, false);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_NETHER_GOLD_ORE_PLACE, 0.7f, 1.355f);
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.4f, 0.755f);
                    w.close();
                    if (AdaptConfig.get().getLearnUnlearnButtonDelayTicks() != 0) {
                        if (this.isPermanent()) {
                            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_BLAZE_DEATH, 0.5f, 1.355f);
                            player.sendTitle(" ", C.RED + C.BOLD + Localizer.dLocalize("snippets", "adaptmenu", "maynotunlearn") + " " + this.getDisplayName(mylevel), 1, 10, 11);
                        } else {
                            player.sendTitle(" ", C.GRAY + Localizer.dLocalize("snippets", "adaptmenu", "unlearned") + " " + this.getDisplayName(mylevel), 1, 10, 11);
                        }
                    }
                    J.s(() -> this.openGui(player), AdaptConfig.get().getLearnUnlearnButtonDelayTicks());
                    return;
                }
                if (k >= (long)c && this.getPlayer(player).getData().hasPowerAvailable(pc)) {
                    if (this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).spendKnowledge(c)) {
                        this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).setAdaptation(this, lvl);
                        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_NETHER_GOLD_ORE_PLACE, 0.9f, 1.355f);
                        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.7f, 0.355f);
                        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.4f, 0.155f);
                        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.2f, 1.455f);
                        if (this.isPermanent()) {
                            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.7f, 1.355f);
                            player.getWorld().playSound(player.getLocation(), Sound.ITEM_GOAT_HORN_SOUND_1, 0.7f, 1.355f);
                        }
                        w.close();
                        if (AdaptConfig.get().getLearnUnlearnButtonDelayTicks() != 0) {
                            player.sendTitle(" ", C.GRAY + Localizer.dLocalize("snippets", "adaptmenu", "learned") + " " + this.getDisplayName(lvl), 1, 5, 11);
                        }
                        J.s(() -> this.openGui(player), AdaptConfig.get().getLearnUnlearnButtonDelayTicks());
                    } else {
                        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BAMBOO_HIT, 0.7f, 1.855f);
                    }
                } else {
                    player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BAMBOO_HIT, 0.7f, 1.855f);
                }
            });
            de.addLore(" ");
            this.addStats(lvl, de);
            w.setElement(pos, row2, de);
        }
        if (AdaptConfig.get().isGuiBackButton()) {
            int backPos = w.getResolution().getWidth() - 1;
            int backRow = w.getViewportHeight() - 1;
            w.setElement(backPos, backRow, new UIElement("back").setMaterial(new MaterialBlock(Material.RED_BED)).setName(C.RESET + C.GRAY + Localizer.dLocalize("snippets", "gui", "back")).onLeftClick(e -> {
                w.close();
                this.onGuiClose(player, true);
            }));
        }
        AdaptPlayer a = Adapt.instance.getAdaptServer().getPlayer(player);
        w.setTitle(this.getDisplayName() + " " + C.DARK_GRAY + " " + Form.f(a.getSkillLine(this.getSkill().getName()).getKnowledge()) + " " + Localizer.dLocalize("snippets", "adaptmenu", "knowledge"));
        w.onClosed(vv -> J.s(() -> this.onGuiClose(player, !AdaptConfig.get().isEscClosesAllGuis())));
        w.open();
        Adapt.instance.getGuiLeftovers().put(player.getUniqueId().toString(), w);
    }

    private void onGuiClose(Player player, boolean openPrevGui) {
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.1f, 1.255f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.7f, 0.655f);
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.3f, 0.855f);
        if (openPrevGui) {
            this.getSkill().openGui(player);
        }
    }

    default public void unlearn(Player player, int lvl, boolean force) {
        if (this.isPermanent() && !force) {
            return;
        }
        int myLevel = this.getPlayer(player).getSkillLine(this.getSkill().getName()).getAdaptationLevel(this.getName());
        int rc = this.getRefundCostFor(lvl - 1, myLevel);
        if (!AdaptConfig.get().isHardcoreNoRefunds()) {
            this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).giveKnowledge(rc);
        }
        this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).setAdaptation(this, lvl - 1);
    }

    default public void learn(Player player, int lvl, boolean force) {
        int myLevel = this.getPlayer(player).getSkillLine(this.getSkill().getName()).getAdaptationLevel(this.getName());
        int c = this.getCostFor(lvl, myLevel);
        if ((this.getPlayer(player).getData().hasPowerAvailable(c) || force) && (this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).spendKnowledge(c) || force)) {
            this.getPlayer(player).getData().getSkillLine(this.getSkill().getName()).setAdaptation(this, lvl);
        }
    }

    default public boolean isAdaptationRecipe(Recipe recipe) {
        if (!this.getSkill().isEnabled()) {
            this.unregister();
        }
        for (AdaptRecipe i : this.getRecipes()) {
            if (!i.is(recipe)) continue;
            return true;
        }
        return false;
    }
}

