/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.notification;

import com.volmit.adapt.api.notification.Notification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Sound;

public class SoundNotification
implements Notification {
    private final long isolation;
    private final long predelay;
    private final Sound sound;
    private final float volume;
    private final float pitch;
    private final String group;

    public SoundNotification withXP(double d) {
        double d2 = d / 1000.0;
        float f = this.pitch;
        float f2 = this.volume;
        f = (double)(f = (float)((double)f - d2 / 6.6)) < 0.1 ? 0.1f : f;
        double d3 = d2 / 5.0;
        d3 = Math.min(d3, 0.8);
        f2 = (float)((double)f2 + d3);
        f = (double)f < 0.1 ? 0.1f : f;
        return SoundNotification.builder().sound(this.sound).isolation(this.isolation).predelay(this.predelay).volume(f2).pitch(f).build();
    }

    @Override
    public long getTotalDuration() {
        return this.isolation;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void play(AdaptPlayer adaptPlayer) {
        J.s(() -> adaptPlayer.getPlayer().playSound(adaptPlayer.getPlayer().getLocation(), this.sound, this.volume, this.pitch));
    }

    private static long $default$isolation() {
        return 0L;
    }

    private static long $default$predelay() {
        return 0L;
    }

    private static Sound $default$sound() {
        return Sound.BLOCK_LEVER_CLICK;
    }

    private static float $default$volume() {
        return 1.0f;
    }

    private static float $default$pitch() {
        return 1.0f;
    }

    private static String $default$group() {
        return "default";
    }

    SoundNotification(long l, long l2, Sound sound, float f, float f2, String string) {
        this.isolation = l;
        this.predelay = l2;
        this.sound = sound;
        this.volume = f;
        this.pitch = f2;
        this.group = string;
    }

    public static SoundNotificationBuilder builder() {
        return new SoundNotificationBuilder();
    }

    public long getIsolation() {
        return this.isolation;
    }

    public long getPredelay() {
        return this.predelay;
    }

    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SoundNotification)) {
            return false;
        }
        SoundNotification soundNotification = (SoundNotification)object;
        if (!soundNotification.canEqual(this)) {
            return false;
        }
        if (this.getIsolation() != soundNotification.getIsolation()) {
            return false;
        }
        if (this.getPredelay() != soundNotification.getPredelay()) {
            return false;
        }
        if (Float.compare(this.getVolume(), soundNotification.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), soundNotification.getPitch()) != 0) {
            return false;
        }
        Sound sound = this.getSound();
        Sound sound2 = soundNotification.getSound();
        if (sound == null ? sound2 != null : !sound.equals(sound2)) {
            return false;
        }
        String string = this.getGroup();
        String string2 = soundNotification.getGroup();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SoundNotification;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getIsolation();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getPredelay();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        n2 = n2 * 59 + Float.floatToIntBits(this.getVolume());
        n2 = n2 * 59 + Float.floatToIntBits(this.getPitch());
        Sound sound = this.getSound();
        n2 = n2 * 59 + (sound == null ? 43 : sound.hashCode());
        String string = this.getGroup();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "SoundNotification(isolation=" + this.getIsolation() + ", predelay=" + this.getPredelay() + ", sound=" + this.getSound() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", group=" + this.getGroup() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SoundNotificationBuilder {
        private boolean isolation$set;
        private long isolation$value;
        private boolean predelay$set;
        private long predelay$value;
        private boolean sound$set;
        private Sound sound$value;
        private boolean volume$set;
        private float volume$value;
        private boolean pitch$set;
        private float pitch$value;
        private boolean group$set;
        private String group$value;

        SoundNotificationBuilder() {
        }

        public SoundNotificationBuilder isolation(long l) {
            this.isolation$value = l;
            this.isolation$set = true;
            return this;
        }

        public SoundNotificationBuilder predelay(long l) {
            this.predelay$value = l;
            this.predelay$set = true;
            return this;
        }

        public SoundNotificationBuilder sound(Sound sound) {
            this.sound$value = sound;
            this.sound$set = true;
            return this;
        }

        public SoundNotificationBuilder volume(float f) {
            this.volume$value = f;
            this.volume$set = true;
            return this;
        }

        public SoundNotificationBuilder pitch(float f) {
            this.pitch$value = f;
            this.pitch$set = true;
            return this;
        }

        public SoundNotificationBuilder group(String string) {
            this.group$value = string;
            this.group$set = true;
            return this;
        }

        public SoundNotification build() {
            long l = this.isolation$value;
            if (!this.isolation$set) {
                l = SoundNotification.$default$isolation();
            }
            long l2 = this.predelay$value;
            if (!this.predelay$set) {
                l2 = SoundNotification.$default$predelay();
            }
            Sound sound = this.sound$value;
            if (!this.sound$set) {
                sound = SoundNotification.$default$sound();
            }
            float f = this.volume$value;
            if (!this.volume$set) {
                f = SoundNotification.$default$volume();
            }
            float f2 = this.pitch$value;
            if (!this.pitch$set) {
                f2 = SoundNotification.$default$pitch();
            }
            String string = this.group$value;
            if (!this.group$set) {
                string = SoundNotification.$default$group();
            }
            return new SoundNotification(l, l2, sound, f, f2, string);
        }

        public String toString() {
            return "SoundNotification.SoundNotificationBuilder(isolation$value=" + this.isolation$value + ", predelay$value=" + this.predelay$value + ", sound$value=" + this.sound$value + ", volume$value=" + this.volume$value + ", pitch$value=" + this.pitch$value + ", group$value=" + this.group$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

