/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.potion.BrewingManager;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.content.skill.SkillAgility;
import com.volmit.adapt.content.skill.SkillArchitect;
import com.volmit.adapt.content.skill.SkillAxes;
import com.volmit.adapt.content.skill.SkillBlocking;
import com.volmit.adapt.content.skill.SkillBrewing;
import com.volmit.adapt.content.skill.SkillChronos;
import com.volmit.adapt.content.skill.SkillCrafting;
import com.volmit.adapt.content.skill.SkillDiscovery;
import com.volmit.adapt.content.skill.SkillEnchanting;
import com.volmit.adapt.content.skill.SkillExcavation;
import com.volmit.adapt.content.skill.SkillHerbalism;
import com.volmit.adapt.content.skill.SkillHunter;
import com.volmit.adapt.content.skill.SkillNether;
import com.volmit.adapt.content.skill.SkillPickaxes;
import com.volmit.adapt.content.skill.SkillRanged;
import com.volmit.adapt.content.skill.SkillRift;
import com.volmit.adapt.content.skill.SkillSeaborne;
import com.volmit.adapt.content.skill.SkillStealth;
import com.volmit.adapt.content.skill.SkillSwords;
import com.volmit.adapt.content.skill.SkillTaming;
import com.volmit.adapt.content.skill.SkillTragOul;
import com.volmit.adapt.content.skill.SkillUnarmed;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class SkillRegistry
extends TickedObject {
    public static final Map<String, Skill<?>> skills;

    public SkillRegistry() {
        super("registry", UUID.randomUUID() + "-sk", 1250L);
        this.registerSkill(SkillAgility.class);
        this.registerSkill(SkillArchitect.class);
        this.registerSkill(SkillAxes.class);
        this.registerSkill(SkillBlocking.class);
        this.registerSkill(SkillChronos.class);
        this.registerSkill(SkillCrafting.class);
        this.registerSkill(SkillDiscovery.class);
        this.registerSkill(SkillEnchanting.class);
        this.registerSkill(SkillHerbalism.class);
        this.registerSkill(SkillHunter.class);
        this.registerSkill(SkillPickaxes.class);
        this.registerSkill(SkillRanged.class);
        this.registerSkill(SkillRift.class);
        this.registerSkill(SkillSeaborne.class);
        this.registerSkill(SkillStealth.class);
        this.registerSkill(SkillSwords.class);
        this.registerSkill(SkillTaming.class);
        this.registerSkill(SkillTragOul.class);
        this.registerSkill(SkillUnarmed.class);
        this.registerSkill(SkillExcavation.class);
        this.registerSkill(SkillBrewing.class);
        this.registerSkill(SkillNether.class);
    }

    @EventHandler
    public void on(PlayerExpChangeEvent playerExpChangeEvent) {
        Player player = playerExpChangeEvent.getPlayer();
        if (playerExpChangeEvent.getAmount() > 0) {
            this.getPlayer(player).boostXPToRecents(0.03, 10000);
        }
    }

    private boolean canInteract(Player player, Location location) {
        return Adapt.instance.getProtectorRegistry().getAllProtectors().stream().allMatch(protector -> protector.canInteract(player, location, null));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent playerInteractEvent) {
        ItemStack itemStack;
        boolean bl;
        Player player = playerInteractEvent.getPlayer();
        boolean bl2 = player.isSneaking() && playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && playerInteractEvent.getClickedBlock() != null;
        boolean bl3 = bl2 && playerInteractEvent.getClickedBlock().getType().equals((Object)Material.LECTERN);
        boolean bl4 = bl2 && playerInteractEvent.getClickedBlock().getType().equals((Object)Material.OBSERVER);
        boolean bl5 = bl = !(playerInteractEvent.getBlockFace().equals((Object)BlockFace.UP) || playerInteractEvent.getBlockFace().equals((Object)BlockFace.DOWN) || player.isSneaking() || !playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || playerInteractEvent.getClickedBlock() == null || !this.canInteract(player, playerInteractEvent.getClickedBlock().getLocation()) || !playerInteractEvent.getClickedBlock().getType().equals((Object)Material.valueOf((String)AdaptConfig.get().adaptActivatorBlock)) || !player.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR) && player.getInventory().getItemInMainHand().getType().isBlock() || !player.getInventory().getItemInOffHand().getType().equals((Object)Material.AIR) && player.getInventory().getItemInOffHand().getType().isBlock());
        if (bl) {
            playerInteractEvent.getClickedBlock().getWorld().playSound(playerInteractEvent.getClickedBlock().getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 0.72f);
            playerInteractEvent.getClickedBlock().getWorld().playSound(playerInteractEvent.getClickedBlock().getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.35f, 0.755f);
            SkillsGui.open(player);
            playerInteractEvent.setCancelled(true);
            player.getWorld().spawnParticle(Particle.CRIT_MAGIC, playerInteractEvent.getClickedBlock().getLocation().clone().add(0.5, 1.0, 0.5), 25, 0.0, 0.0, 0.0, 1.1);
            player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, playerInteractEvent.getClickedBlock().getLocation().clone().add(0.5, 1.0, 0.5), 12, 0.0, 0.0, 0.0, 1.1);
        }
        if (bl3 && (itemStack = player.getInventory().getItemInMainHand()).getItemMeta() != null && !itemStack.getItemMeta().getPersistentDataContainer().getKeys().isEmpty()) {
            playerInteractEvent.setCancelled(true);
            this.playDebug(player);
            itemStack.getItemMeta().getPersistentDataContainer().getKeys().forEach(namespacedKey -> Bukkit.getServer().getConsoleSender().sendMessage(namespacedKey + " = " + (String)itemStack.getItemMeta().getPersistentDataContainer().getOrDefault(namespacedKey, PersistentDataType.STRING, (Object)"Not a String")));
        }
        if (bl4 && (itemStack = player.getInventory().getItemInMainHand()).getType().equals((Object)Material.EXPERIENCE_BOTTLE)) {
            Object object;
            playerInteractEvent.setCancelled(true);
            Bukkit.getServer().getConsoleSender().sendMessage("   ");
            player.setCooldown(Material.ENCHANTED_BOOK, 3);
            AdaptPlayer adaptPlayer = this.getPlayer(player);
            this.playDebug(player);
            Object object2 = adaptPlayer.getData().getMultiplier() - 1.0 > 0.0 ? "+" + Form.pc(adaptPlayer.getData().getMultiplier() - 1.0) : Form.pc(adaptPlayer.getData().getMultiplier() - 1.0);
            Bukkit.getServer().getConsoleSender().sendMessage("Global" + C.GRAY + ": " + C.GREEN + (String)object2);
            for (XPMultiplier object3 : adaptPlayer.getData().getMultipliers()) {
                object = object3.getMultiplier() > 0.0 ? "+" + Form.pc(object3.getMultiplier()) : Form.pc(object3.getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage(C.GREEN + "* " + (String)object + C.GRAY + " for " + Form.duration(object3.getGoodFor() - M.ms(), 0));
            }
            for (XPMultiplier xPMultiplier : Adapt.instance.getAdaptServer().getData().getMultipliers()) {
                object = xPMultiplier.getMultiplier() > 0.0 ? "+" + Form.pc(xPMultiplier.getMultiplier()) : Form.pc(xPMultiplier.getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage(C.GREEN + "* " + (String)object + C.GRAY + " for " + Form.duration(xPMultiplier.getGoodFor() - M.ms(), 0));
            }
            for (PlayerSkillLine playerSkillLine : XMap.v(adaptPlayer.getData().getSkillLines())) {
                object = playerSkillLine.getRawSkill(adaptPlayer);
                Object object3 = playerSkillLine.getMultiplier() - adaptPlayer.getData().getMultiplier() > 0.0 ? "+" + Form.pc(playerSkillLine.getMultiplier() - adaptPlayer.getData().getMultiplier()) : Form.pc(playerSkillLine.getMultiplier() - adaptPlayer.getData().getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage("  " + object.getDisplayName() + C.GRAY + ": " + object.getColor() + (String)object3);
                for (XPMultiplier xPMultiplier : playerSkillLine.getMultipliers()) {
                    Object object4 = xPMultiplier.getMultiplier() > 0.0 ? "+" + Form.pc(xPMultiplier.getMultiplier()) : Form.pc(xPMultiplier.getMultiplier());
                    Bukkit.getServer().getConsoleSender().sendMessage("  " + object.getShortName() + C.GRAY + " " + (String)object4 + " for " + Form.duration(xPMultiplier.getGoodFor() - M.ms(), 0));
                }
            }
        }
    }

    private void playDebug(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 0.6f);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 0.1f);
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.6f);
        player.playSound(player.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
    }

    public Skill<?> getSkill(String string) {
        return skills.get(string);
    }

    public List<Skill<?>> getSkills() {
        return XMap.v(skills);
    }

    public void registerSkill(Class<? extends Skill<?>> clazz) {
        try {
            Skill<?> skill = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!skill.isEnabled()) {
                return;
            }
            skills.put(skill.getName(), skill);
            this.registerRecipes(skill);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    private void unregisterRecipes(Skill<?> skill) {
        skill.getRecipes().forEach(AdaptRecipe::unregister);
        skill.getAdaptations().forEach(adaptation -> adaptation.getRecipes().forEach(AdaptRecipe::unregister));
    }

    private void registerRecipes(Skill<?> skill) {
        skill.getRecipes().forEach(AdaptRecipe::register);
        skill.getAdaptations().forEach(adaptation -> {
            adaptation.getRecipes().forEach(AdaptRecipe::register);
            adaptation.getBrewingRecipes().forEach(brewingRecipe -> BrewingManager.registerRecipe(adaptation.getName(), brewingRecipe));
        });
    }

    @Override
    public void unregister() {
        for (Skill<?> skill : XMap.v(skills)) {
            skill.unregister();
            this.unregisterRecipes(skill);
        }
    }

    @Override
    public void onTick() {
    }

    static {
        IBootstrap.dasBoot();
        skills = new ConcurrentHashMap();
    }
}

