/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.tick;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.event.Listener;

public abstract class TickedObject
implements Ticked,
Listener {
    private final AtomicLong lastTick;
    private final AtomicLong interval;
    private final AtomicInteger skip;
    private final AtomicInteger burst;
    private final AtomicLong ticks;
    private final AtomicInteger dieIn;
    private final AtomicBoolean die;
    private final long start;
    private final String group;
    private final String id;

    public TickedObject() {
        this("null");
    }

    public TickedObject(String string, String string2) {
        this(string, string2, 1000L);
    }

    public TickedObject(String string) {
        this(string, UUID.randomUUID().toString(), 1000L);
    }

    public TickedObject(String string, long l) {
        this(string, UUID.randomUUID().toString(), l);
    }

    public TickedObject(String string, String string2, long l) {
        this.group = string;
        this.id = string2;
        this.die = new AtomicBoolean(false);
        this.dieIn = new AtomicInteger(0);
        this.interval = new AtomicLong(l);
        this.lastTick = new AtomicLong(M.ms());
        this.burst = new AtomicInteger(0);
        this.skip = new AtomicInteger(0);
        this.ticks = new AtomicLong(0L);
        this.start = M.ms();
        Adapt.instance.getTicker().register(this);
        Adapt.instance.registerListener(this);
    }

    public void dieAfter(int n) {
        this.dieIn.set(n);
        this.die.set(true);
    }

    @Override
    public void unregister() {
        Adapt.instance.getTicker().unregister(this);
        Adapt.instance.unregisterListener(this);
    }

    @Override
    public long getLastTick() {
        return this.lastTick.get();
    }

    @Override
    public long getInterval() {
        if (this.burst.get() > 0) {
            return 0L;
        }
        return this.interval.get();
    }

    @Override
    public void setInterval(long l) {
        this.interval.set(l);
    }

    @Override
    public void tick() {
        if (this.skip.getAndDecrement() > 0) {
            return;
        }
        if (this.die.get() && this.dieIn.decrementAndGet() <= 0) {
            this.unregister();
            return;
        }
        this.lastTick.set(M.ms());
        this.burst.decrementAndGet();
        this.onTick();
    }

    public abstract void onTick();

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getTickCount() {
        return this.ticks.get();
    }

    @Override
    public long getAge() {
        return M.ms() - this.start;
    }

    @Override
    public boolean isBursting() {
        return this.burst.get() > 0;
    }

    @Override
    public void burst(int n) {
        if (this.burst.get() < 0) {
            this.burst.set(n);
            return;
        }
        this.burst.addAndGet(n);
    }

    @Override
    public boolean isSkipping() {
        return this.skip.get() > 0;
    }

    @Override
    public void stopBursting() {
        this.burst.set(0);
    }

    @Override
    public void stopSkipping() {
        this.skip.set(0);
    }

    @Override
    public void skip(int n) {
        if (this.skip.get() < 0) {
            this.skip.set(n);
            return;
        }
        this.skip.addAndGet(n);
    }

    static {
        IBootstrap.dasBoot();
    }
}

