/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.notification.TitleNotification;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.Discovery;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;

public class PlayerData {
    private final Map<String, PlayerSkillLine> skillLines = new HashMap<String, PlayerSkillLine>();
    private Map<String, Double> stats = new HashMap<String, Double>();
    private String last = "none";
    private Set<String> advancements = new HashSet<String>();
    private Discovery<Biome> seenBiomes = new Discovery();
    private Discovery<EntityType> seenMobs = new Discovery();
    private Discovery<Material> seenFoods = new Discovery();
    private Discovery<Material> seenItems = new Discovery();
    private Discovery<String> seenRecipes = new Discovery();
    private Discovery<String> seenEnchants = new Discovery();
    private Discovery<String> seenWorlds = new Discovery();
    private Discovery<String> seenPeople = new Discovery();
    private Discovery<World.Environment> seenEnvironments = new Discovery();
    private Discovery<String> seenPotionEffects = new Discovery();
    private Discovery<String> seenBlocks = new Discovery();
    private List<XPMultiplier> multipliers = new ArrayList<XPMultiplier>();
    private long wisdom = 0L;
    private double multiplier = 0.0;
    private long lastLogin = 0L;
    private double masterXp = 1.0;
    private double lastMasterXp = 0.0;

    public void giveMasterXp(double d) {
        this.masterXp += d;
    }

    public void globalXPMultiplier(double d, int n) {
        this.multipliers.add(new XPMultiplier(d, n));
    }

    public boolean isGranted(String string) {
        return this.advancements.contains(string);
    }

    public void ensureGranted(String string) {
        this.advancements.add(string);
    }

    public double getStat(String string) {
        Double d = this.stats.get(string);
        return d == null ? 0.0 : d;
    }

    public void addStat(String string, double d) {
        if (!this.stats.containsKey(string)) {
            this.stats.put(string, d);
        } else {
            this.stats.put(string, this.stats.get(string) + d);
        }
    }

    public void update(AdaptPlayer adaptPlayer) {
        int n;
        double d = 1.0;
        for (XPMultiplier object : XList.copy(this.multipliers)) {
            if (object.isExpired()) {
                this.multipliers.remove(object);
                continue;
            }
            d += object.getMultiplier();
        }
        for (XPMultiplier xPMultiplier : XList.copy(Adapt.instance.getAdaptServer().getData().getMultipliers())) {
            if (xPMultiplier.isExpired()) {
                Adapt.instance.getAdaptServer().getData().getMultipliers().remove(xPMultiplier);
                continue;
            }
            d += xPMultiplier.getMultiplier();
        }
        if (d <= 0.0) {
            d = 0.01;
        }
        if (d > 1000.0) {
            d = 1000.0;
        }
        this.multiplier = d;
        for (String string : XMap.k(this.skillLines)) {
            if (this.getSkillLine(string) == null) {
                this.skillLines.remove(string);
                Adapt.warn("Removed unknown skill line '" + string + "' from " + adaptPlayer.getPlayer().getName());
                continue;
            }
            if (this.getSkillLine(string).getXp() == 0.0 && this.getSkillLine(string).getKnowledge() == 0L) {
                this.skillLines.remove(string);
                continue;
            }
            this.getSkillLine(string).update(adaptPlayer, string, this);
        }
        int n2 = (int)XP.getLevelForXp(this.getLastMasterXp());
        if (n2 != (n = (int)XP.getLevelForXp(this.getMasterXp()))) {
            this.setLastMasterXp(this.getMasterXp());
            adaptPlayer.getNot().queue(SoundNotification.builder().sound(Sound.BLOCK_ENCHANTMENT_TABLE_USE).volume(1.0f).pitch(0.54f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.44f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.74f).group("lvl").build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(1.34f).group("lvl").build(), TitleNotification.builder().in(250L).stay(1450L).out(2250L).group("lvl").title("").subtitle(C.GOLD + "Level " + n).build());
            adaptPlayer.getActionBarNotifier().queue(ActionBarNotification.builder().duration(450L).group("power").title(C.GOLD + Form.f((double)n * AdaptConfig.get().getPowerPerLevel(), 0) + C.GRAY + " Maximum Ability Power").build());
        }
    }

    public int getAvailablePower() {
        return this.getMaxPower() - this.getUsedPower();
    }

    public boolean hasPowerAvailable() {
        return this.hasPowerAvailable(1);
    }

    public boolean hasPowerAvailable(int n) {
        return this.getAvailablePower() >= n;
    }

    public int getUsedPower() {
        return this.getSkillLines().values().stream().mapToInt(playerSkillLine -> playerSkillLine.getAdaptations().values().stream().mapToInt(PlayerAdaptation::getLevel).sum()).sum();
    }

    public int getLevel() {
        return (int)XP.getLevelForXp(this.getMasterXp());
    }

    public int getMaxPower() {
        return (int)(XP.getLevelForXp(this.getMasterXp()) * AdaptConfig.get().getPowerPerLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerSkillLine getSkillLine(String string) {
        if (Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(string) == null) {
            return null;
        }
        Map<String, PlayerSkillLine> map = this.skillLines;
        synchronized (map) {
            PlayerSkillLine playerSkillLine;
            try {
                playerSkillLine = this.skillLines.get(string);
                if (playerSkillLine != null) {
                    return playerSkillLine;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Adapt.error("Failed to get skill line " + string);
            }
            playerSkillLine = new PlayerSkillLine();
            playerSkillLine.setLine(string);
            this.skillLines.put(string, playerSkillLine);
            return playerSkillLine;
        }
    }

    public void addWisdom() {
        ++this.wisdom;
    }

    public Map<String, PlayerSkillLine> getSkillLines() {
        return this.skillLines;
    }

    public Map<String, Double> getStats() {
        return this.stats;
    }

    public String getLast() {
        return this.last;
    }

    public Set<String> getAdvancements() {
        return this.advancements;
    }

    public Discovery<Biome> getSeenBiomes() {
        return this.seenBiomes;
    }

    public Discovery<EntityType> getSeenMobs() {
        return this.seenMobs;
    }

    public Discovery<Material> getSeenFoods() {
        return this.seenFoods;
    }

    public Discovery<Material> getSeenItems() {
        return this.seenItems;
    }

    public Discovery<String> getSeenRecipes() {
        return this.seenRecipes;
    }

    public Discovery<String> getSeenEnchants() {
        return this.seenEnchants;
    }

    public Discovery<String> getSeenWorlds() {
        return this.seenWorlds;
    }

    public Discovery<String> getSeenPeople() {
        return this.seenPeople;
    }

    public Discovery<World.Environment> getSeenEnvironments() {
        return this.seenEnvironments;
    }

    public Discovery<String> getSeenPotionEffects() {
        return this.seenPotionEffects;
    }

    public Discovery<String> getSeenBlocks() {
        return this.seenBlocks;
    }

    public List<XPMultiplier> getMultipliers() {
        return this.multipliers;
    }

    public long getWisdom() {
        return this.wisdom;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public double getMasterXp() {
        return this.masterXp;
    }

    public double getLastMasterXp() {
        return this.lastMasterXp;
    }

    public void setStats(Map<String, Double> map) {
        this.stats = map;
    }

    public void setLast(String string) {
        this.last = string;
    }

    public void setAdvancements(Set<String> set) {
        this.advancements = set;
    }

    public void setSeenBiomes(Discovery<Biome> discovery) {
        this.seenBiomes = discovery;
    }

    public void setSeenMobs(Discovery<EntityType> discovery) {
        this.seenMobs = discovery;
    }

    public void setSeenFoods(Discovery<Material> discovery) {
        this.seenFoods = discovery;
    }

    public void setSeenItems(Discovery<Material> discovery) {
        this.seenItems = discovery;
    }

    public void setSeenRecipes(Discovery<String> discovery) {
        this.seenRecipes = discovery;
    }

    public void setSeenEnchants(Discovery<String> discovery) {
        this.seenEnchants = discovery;
    }

    public void setSeenWorlds(Discovery<String> discovery) {
        this.seenWorlds = discovery;
    }

    public void setSeenPeople(Discovery<String> discovery) {
        this.seenPeople = discovery;
    }

    public void setSeenEnvironments(Discovery<World.Environment> discovery) {
        this.seenEnvironments = discovery;
    }

    public void setSeenPotionEffects(Discovery<String> discovery) {
        this.seenPotionEffects = discovery;
    }

    public void setSeenBlocks(Discovery<String> discovery) {
        this.seenBlocks = discovery;
    }

    public void setMultipliers(List<XPMultiplier> list) {
        this.multipliers = list;
    }

    public void setWisdom(long l) {
        this.wisdom = l;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public void setLastLogin(long l) {
        this.lastLogin = l;
    }

    public void setMasterXp(double d) {
        this.masterXp = d;
    }

    public void setLastMasterXp(double d) {
        this.lastMasterXp = d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlayerData)) {
            return false;
        }
        PlayerData playerData = (PlayerData)object;
        if (!playerData.canEqual(this)) {
            return false;
        }
        if (this.getWisdom() != playerData.getWisdom()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), playerData.getMultiplier()) != 0) {
            return false;
        }
        if (this.getLastLogin() != playerData.getLastLogin()) {
            return false;
        }
        if (Double.compare(this.getMasterXp(), playerData.getMasterXp()) != 0) {
            return false;
        }
        if (Double.compare(this.getLastMasterXp(), playerData.getLastMasterXp()) != 0) {
            return false;
        }
        Map<String, PlayerSkillLine> map = this.getSkillLines();
        Map<String, PlayerSkillLine> map2 = playerData.getSkillLines();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        Map<String, Double> map3 = this.getStats();
        Map<String, Double> map4 = playerData.getStats();
        if (map3 == null ? map4 != null : !((Object)map3).equals(map4)) {
            return false;
        }
        String string = this.getLast();
        String string2 = playerData.getLast();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Set<String> set = this.getAdvancements();
        Set<String> set2 = playerData.getAdvancements();
        if (set == null ? set2 != null : !((Object)set).equals(set2)) {
            return false;
        }
        Discovery<Biome> discovery = this.getSeenBiomes();
        Discovery<Biome> discovery2 = playerData.getSeenBiomes();
        if (discovery == null ? discovery2 != null : !discovery.equals(discovery2)) {
            return false;
        }
        Discovery<EntityType> discovery3 = this.getSeenMobs();
        Discovery<EntityType> discovery4 = playerData.getSeenMobs();
        if (discovery3 == null ? discovery4 != null : !discovery3.equals(discovery4)) {
            return false;
        }
        Discovery<Material> discovery5 = this.getSeenFoods();
        Discovery<Material> discovery6 = playerData.getSeenFoods();
        if (discovery5 == null ? discovery6 != null : !discovery5.equals(discovery6)) {
            return false;
        }
        Discovery<Material> discovery7 = this.getSeenItems();
        Discovery<Material> discovery8 = playerData.getSeenItems();
        if (discovery7 == null ? discovery8 != null : !discovery7.equals(discovery8)) {
            return false;
        }
        Discovery<String> discovery9 = this.getSeenRecipes();
        Discovery<String> discovery10 = playerData.getSeenRecipes();
        if (discovery9 == null ? discovery10 != null : !discovery9.equals(discovery10)) {
            return false;
        }
        Discovery<String> discovery11 = this.getSeenEnchants();
        Discovery<String> discovery12 = playerData.getSeenEnchants();
        if (discovery11 == null ? discovery12 != null : !discovery11.equals(discovery12)) {
            return false;
        }
        Discovery<String> discovery13 = this.getSeenWorlds();
        Discovery<String> discovery14 = playerData.getSeenWorlds();
        if (discovery13 == null ? discovery14 != null : !discovery13.equals(discovery14)) {
            return false;
        }
        Discovery<String> discovery15 = this.getSeenPeople();
        Discovery<String> discovery16 = playerData.getSeenPeople();
        if (discovery15 == null ? discovery16 != null : !discovery15.equals(discovery16)) {
            return false;
        }
        Discovery<World.Environment> discovery17 = this.getSeenEnvironments();
        Discovery<World.Environment> discovery18 = playerData.getSeenEnvironments();
        if (discovery17 == null ? discovery18 != null : !discovery17.equals(discovery18)) {
            return false;
        }
        Discovery<String> discovery19 = this.getSeenPotionEffects();
        Discovery<String> discovery20 = playerData.getSeenPotionEffects();
        if (discovery19 == null ? discovery20 != null : !discovery19.equals(discovery20)) {
            return false;
        }
        Discovery<String> discovery21 = this.getSeenBlocks();
        Discovery<String> discovery22 = playerData.getSeenBlocks();
        if (discovery21 == null ? discovery22 != null : !discovery21.equals(discovery22)) {
            return false;
        }
        List<XPMultiplier> list = this.getMultipliers();
        List<XPMultiplier> list2 = playerData.getMultipliers();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PlayerData;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getWisdom();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = Double.doubleToLongBits(this.getMultiplier());
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getLastLogin();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = Double.doubleToLongBits(this.getMasterXp());
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = Double.doubleToLongBits(this.getLastMasterXp());
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        Map<String, PlayerSkillLine> map = this.getSkillLines();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        Map<String, Double> map2 = this.getStats();
        n2 = n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
        String string = this.getLast();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Set<String> set = this.getAdvancements();
        n2 = n2 * 59 + (set == null ? 43 : ((Object)set).hashCode());
        Discovery<Biome> discovery = this.getSeenBiomes();
        n2 = n2 * 59 + (discovery == null ? 43 : discovery.hashCode());
        Discovery<EntityType> discovery2 = this.getSeenMobs();
        n2 = n2 * 59 + (discovery2 == null ? 43 : discovery2.hashCode());
        Discovery<Material> discovery3 = this.getSeenFoods();
        n2 = n2 * 59 + (discovery3 == null ? 43 : discovery3.hashCode());
        Discovery<Material> discovery4 = this.getSeenItems();
        n2 = n2 * 59 + (discovery4 == null ? 43 : discovery4.hashCode());
        Discovery<String> discovery5 = this.getSeenRecipes();
        n2 = n2 * 59 + (discovery5 == null ? 43 : discovery5.hashCode());
        Discovery<String> discovery6 = this.getSeenEnchants();
        n2 = n2 * 59 + (discovery6 == null ? 43 : discovery6.hashCode());
        Discovery<String> discovery7 = this.getSeenWorlds();
        n2 = n2 * 59 + (discovery7 == null ? 43 : discovery7.hashCode());
        Discovery<String> discovery8 = this.getSeenPeople();
        n2 = n2 * 59 + (discovery8 == null ? 43 : discovery8.hashCode());
        Discovery<World.Environment> discovery9 = this.getSeenEnvironments();
        n2 = n2 * 59 + (discovery9 == null ? 43 : discovery9.hashCode());
        Discovery<String> discovery10 = this.getSeenPotionEffects();
        n2 = n2 * 59 + (discovery10 == null ? 43 : discovery10.hashCode());
        Discovery<String> discovery11 = this.getSeenBlocks();
        n2 = n2 * 59 + (discovery11 == null ? 43 : discovery11.hashCode());
        List<XPMultiplier> list = this.getMultipliers();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "PlayerData(skillLines=" + this.getSkillLines() + ", stats=" + this.getStats() + ", last=" + this.getLast() + ", advancements=" + this.getAdvancements() + ", seenBiomes=" + this.getSeenBiomes() + ", seenMobs=" + this.getSeenMobs() + ", seenFoods=" + this.getSeenFoods() + ", seenItems=" + this.getSeenItems() + ", seenRecipes=" + this.getSeenRecipes() + ", seenEnchants=" + this.getSeenEnchants() + ", seenWorlds=" + this.getSeenWorlds() + ", seenPeople=" + this.getSeenPeople() + ", seenEnvironments=" + this.getSeenEnvironments() + ", seenPotionEffects=" + this.getSeenPotionEffects() + ", seenBlocks=" + this.getSeenBlocks() + ", multipliers=" + this.getMultipliers() + ", wisdom=" + this.getWisdom() + ", multiplier=" + this.getMultiplier() + ", lastLogin=" + this.getLastLogin() + ", masterXp=" + this.getMasterXp() + ", lastMasterXp=" + this.getLastMasterXp() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

