/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.notification.ActionBarNotification;
import com.volmit.adapt.api.notification.Notifier;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.notification.TitleNotification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Sound;

public class PlayerSkillLine {
    private String line = "";
    private double xp = 0.0;
    private double lastXP = 0.0;
    private long knowledge = 0L;
    private double multiplier = 1.0;
    private double freshness = 1.0;
    private double rfreshness = 1.0;
    private int lastLevel = 0;
    private long last = M.ms();
    private Map<String, Object> storage = new HashMap<String, Object>();
    private Map<String, PlayerAdaptation> adaptations = new HashMap<String, PlayerAdaptation>();
    private List<XPMultiplier> multipliers = new ArrayList<XPMultiplier>();

    private static double diff(long l, long l2) {
        return Math.abs((double)l - (double)l2 / (double)(l == 0L ? 1L : l));
    }

    public void update(AdaptPlayer adaptPlayer, String string, PlayerData playerData) {
        this.grantSkillsAndAdaptations(adaptPlayer, string);
        this.checkMaxLevel(adaptPlayer, string);
        this.updateFreshness();
        this.updateMultiplier(playerData);
        this.updateEarnedXP(adaptPlayer, string);
        this.updateLevel(adaptPlayer, string, playerData);
    }

    private void grantSkillsAndAdaptations(AdaptPlayer adaptPlayer, String string) {
        if (!adaptPlayer.getData().isGranted("skill_" + string) && AdaptConfig.get().isAdvancements()) {
            adaptPlayer.getAdvancementHandler().grant("skill_" + string);
        }
        for (String string2 : this.getAdaptations().keySet()) {
            if (adaptPlayer.getData().isGranted("adaptation_" + string2) || !AdaptConfig.get().isAdvancements()) continue;
            adaptPlayer.getAdvancementHandler().grant("adaptation_" + string2);
        }
    }

    private void checkMaxLevel(AdaptPlayer adaptPlayer, String string) {
        if (!adaptPlayer.isBusy() && this.getXp() > XP.getXpForLevel(AdaptConfig.get().experienceMaxLevel)) {
            adaptPlayer.getData().addWisdom();
            Adapt.warn("A Player has reached the maximum level of " + AdaptConfig.get().experienceMaxLevel + " and has been granted 1 wisdom, Dropping Level to " + this.lastLevel);
            this.setXp(XP.getXpForLevel(AdaptConfig.get().experienceMaxLevel - 1));
        }
    }

    private void updateFreshness() {
        double d = 1.0 + (double)this.getLevel() * 0.004;
        this.freshness += 0.1 * this.freshness + 0.00124;
        if (this.freshness > d) {
            this.freshness = d;
        }
        if (this.freshness < 0.01) {
            this.freshness = 0.01;
        }
        if (this.freshness < this.rfreshness) {
            this.rfreshness -= (this.rfreshness - this.freshness) * 0.003;
        }
        if (this.freshness > this.rfreshness) {
            this.rfreshness += (this.freshness - this.rfreshness) * 0.265;
        }
    }

    private void updateMultiplier(PlayerData playerData) {
        double d = this.rfreshness;
        for (XPMultiplier xPMultiplier : XList.copy(this.multipliers)) {
            if (xPMultiplier.isExpired()) {
                this.multipliers.remove(xPMultiplier);
                continue;
            }
            d += xPMultiplier.getMultiplier();
        }
        d = Math.max(0.01, Math.min(d, 1000.0));
        this.multiplier = d * playerData.getMultiplier();
    }

    private void updateEarnedXP(AdaptPlayer adaptPlayer, String string) {
        double d = this.xp - this.lastXP;
        if (d > adaptPlayer.getServer().getSkillRegistry().getSkill(string).getMinXp()) {
            this.lastXP = this.xp;
        }
    }

    private void updateLevel(AdaptPlayer adaptPlayer, String string, PlayerData playerData) {
        if (this.lastLevel < this.getLevel()) {
            long l = this.getKnowledge();
            for (int i = this.lastLevel; i < this.getLevel(); ++i) {
                this.giveKnowledge(i / 13 + 1);
                adaptPlayer.getData().giveMasterXp((double)i * AdaptConfig.get().getPlayerXpPerSkillLevelUpLevelMultiplier() + AdaptConfig.get().getPlayerXpPerSkillLevelUpBase());
            }
            if (AdaptConfig.get().isActionbarNotifyLevel()) {
                this.notifyLevel(adaptPlayer, this.getLevel(), this.getKnowledge());
            }
            this.lastLevel = this.getLevel();
        }
    }

    public void giveXP(Notifier notifier, double d) {
        this.freshness -= Math.pow(d, 2.0) * 1.0E-4;
        d = this.multiplier * d;
        this.xp += d;
        if (notifier != null) {
            this.last = M.ms();
            if (AdaptConfig.get().isActionbarNotifyXp()) {
                notifier.notifyXP(this.line, d);
            }
        }
    }

    public void giveXPFresh(Notifier notifier, double d) {
        d = this.multiplier * d;
        this.xp += d;
        if (notifier != null) {
            this.last = M.ms();
            if (AdaptConfig.get().isActionbarNotifyXp()) {
                notifier.notifyXP(this.line, d);
            }
        }
    }

    public boolean hasEarnedWithin(long l) {
        return M.ms() - this.last < l;
    }

    public PlayerAdaptation getAdaptation(String string) {
        return this.adaptations.get(string);
    }

    public int getAdaptationLevel(String string) {
        PlayerAdaptation playerAdaptation = this.getAdaptation(string);
        if (playerAdaptation == null) {
            return 0;
        }
        return playerAdaptation.getLevel();
    }

    public void setAdaptation(Adaptation adaptation, int n) {
        if (n <= 1) {
            this.adaptations.remove(adaptation.getName());
        }
        PlayerAdaptation playerAdaptation = new PlayerAdaptation();
        playerAdaptation.setId(adaptation.getName());
        playerAdaptation.setLevel(Math.min(n, adaptation.getMaxLevel()));
        this.adaptations.put(adaptation.getName(), playerAdaptation);
    }

    public Skill getRawSkill(AdaptPlayer adaptPlayer) {
        return adaptPlayer.getServer().getSkillRegistry().getSkill(this.line);
    }

    private void notifyLevel(AdaptPlayer adaptPlayer, double d, long l) {
        if (d % 10.0 == 0.0) {
            adaptPlayer.getNot().queue(SoundNotification.builder().sound(Sound.UI_TOAST_CHALLENGE_COMPLETE).volume(1.0f).pitch(1.35f).group("lvl" + this.getLine()).build(), SoundNotification.builder().sound(Sound.UI_TOAST_CHALLENGE_COMPLETE).volume(1.0f).pitch(0.75f).group("lvl" + this.getLine()).build(), TitleNotification.builder().in(250L).stay(1450L).out(2250L).group("lvl" + this.getLine()).title("").subtitle(adaptPlayer.getServer().getSkillRegistry().getSkill(this.getLine()).getDisplayName(this.getLevel())).build());
            adaptPlayer.getActionBarNotifier().queue(ActionBarNotification.builder().duration(450L).group("know" + this.getLine()).title(l + " " + adaptPlayer.getServer().getSkillRegistry().getSkill(this.getLine()).getShortName() + " Knowledge").build());
        } else {
            adaptPlayer.getActionBarNotifier().queue(SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_BREAK).volume(1.0f).pitch(1.74f).group("lvl" + this.getLine()).build(), SoundNotification.builder().sound(Sound.BLOCK_AMETHYST_BLOCK_CHIME).volume(1.0f).pitch(0.74f).group("lvl" + this.getLine()).build(), ActionBarNotification.builder().duration(450L).group("lvl" + this.getLine()).title(adaptPlayer.getServer().getSkillRegistry().getSkill(this.getLine()).getDisplayName(this.getLevel())).build());
        }
        this.lastLevel = (int)Math.floor(XP.getLevelForXp(this.getXp()));
    }

    public void giveKnowledge(long l) {
        this.knowledge += l;
    }

    public double getMinimumXPForLevel() {
        return XP.getXpForLevel(this.getLevel());
    }

    public double getXPForLevelUpAbsolute() {
        return this.getMaximumXPForLevel() - this.getXp();
    }

    public double getXPForLevelUp() {
        return this.getMaximumXPForLevel() - this.getMinimumXPForLevel();
    }

    public double getMaximumXPForLevel() {
        return XP.getXpForLevel(this.getLevel());
    }

    public double getAbsoluteLevel() {
        return XP.getLevelForXp(this.xp);
    }

    public double getLevelProgress() {
        return this.getAbsoluteLevel() - (double)this.getLevel();
    }

    public double getLevelProgressRemaining() {
        return 1.0 - this.getLevelProgress();
    }

    public int getLevel() {
        return (int)Math.floor(this.getAbsoluteLevel());
    }

    public void boost(double d, int n) {
        this.multipliers.add(new XPMultiplier(d, n));
    }

    public boolean spendKnowledge(int n) {
        if (this.getKnowledge() >= (long)n) {
            this.setKnowledge(this.getKnowledge() - (long)n);
            return true;
        }
        return false;
    }

    public String getLine() {
        return this.line;
    }

    public double getXp() {
        return this.xp;
    }

    public double getLastXP() {
        return this.lastXP;
    }

    public long getKnowledge() {
        return this.knowledge;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getFreshness() {
        return this.freshness;
    }

    public double getRfreshness() {
        return this.rfreshness;
    }

    public int getLastLevel() {
        return this.lastLevel;
    }

    public long getLast() {
        return this.last;
    }

    public Map<String, Object> getStorage() {
        return this.storage;
    }

    public Map<String, PlayerAdaptation> getAdaptations() {
        return this.adaptations;
    }

    public List<XPMultiplier> getMultipliers() {
        return this.multipliers;
    }

    public void setLine(String string) {
        this.line = string;
    }

    public void setXp(double d) {
        this.xp = d;
    }

    public void setLastXP(double d) {
        this.lastXP = d;
    }

    public void setKnowledge(long l) {
        this.knowledge = l;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public void setFreshness(double d) {
        this.freshness = d;
    }

    public void setRfreshness(double d) {
        this.rfreshness = d;
    }

    public void setLastLevel(int n) {
        this.lastLevel = n;
    }

    public void setLast(long l) {
        this.last = l;
    }

    public void setStorage(Map<String, Object> map) {
        this.storage = map;
    }

    public void setAdaptations(Map<String, PlayerAdaptation> map) {
        this.adaptations = map;
    }

    public void setMultipliers(List<XPMultiplier> list) {
        this.multipliers = list;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlayerSkillLine)) {
            return false;
        }
        PlayerSkillLine playerSkillLine = (PlayerSkillLine)object;
        if (!playerSkillLine.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getXp(), playerSkillLine.getXp()) != 0) {
            return false;
        }
        if (Double.compare(this.getLastXP(), playerSkillLine.getLastXP()) != 0) {
            return false;
        }
        if (this.getKnowledge() != playerSkillLine.getKnowledge()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), playerSkillLine.getMultiplier()) != 0) {
            return false;
        }
        if (Double.compare(this.getFreshness(), playerSkillLine.getFreshness()) != 0) {
            return false;
        }
        if (Double.compare(this.getRfreshness(), playerSkillLine.getRfreshness()) != 0) {
            return false;
        }
        if (this.getLastLevel() != playerSkillLine.getLastLevel()) {
            return false;
        }
        if (this.getLast() != playerSkillLine.getLast()) {
            return false;
        }
        String string = this.getLine();
        String string2 = playerSkillLine.getLine();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Map<String, Object> map = this.getStorage();
        Map<String, Object> map2 = playerSkillLine.getStorage();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        Map<String, PlayerAdaptation> map3 = this.getAdaptations();
        Map<String, PlayerAdaptation> map4 = playerSkillLine.getAdaptations();
        if (map3 == null ? map4 != null : !((Object)map3).equals(map4)) {
            return false;
        }
        List<XPMultiplier> list = this.getMultipliers();
        List<XPMultiplier> list2 = playerSkillLine.getMultipliers();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PlayerSkillLine;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.getXp());
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = Double.doubleToLongBits(this.getLastXP());
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getKnowledge();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = Double.doubleToLongBits(this.getMultiplier());
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = Double.doubleToLongBits(this.getFreshness());
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = Double.doubleToLongBits(this.getRfreshness());
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        n2 = n2 * 59 + this.getLastLevel();
        long l7 = this.getLast();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        String string = this.getLine();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Map<String, Object> map = this.getStorage();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        Map<String, PlayerAdaptation> map2 = this.getAdaptations();
        n2 = n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
        List<XPMultiplier> list = this.getMultipliers();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    public String toString() {
        return "PlayerSkillLine(line=" + this.getLine() + ", xp=" + this.getXp() + ", lastXP=" + this.getLastXP() + ", knowledge=" + this.getKnowledge() + ", multiplier=" + this.getMultiplier() + ", freshness=" + this.getFreshness() + ", rfreshness=" + this.getRfreshness() + ", lastLevel=" + this.getLastLevel() + ", last=" + this.getLast() + ", storage=" + this.getStorage() + ", adaptations=" + this.getAdaptations() + ", multipliers=" + this.getMultipliers() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

