/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.command.skill;

import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.command.FConst;
import com.volmit.adapt.util.command.suggest.AdaptAdaptationProvider;
import com.volmit.adapt.util.command.suggest.BooleanSuggestionProvider;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.github.mqzn.commands.annotations.base.Arg;
import io.github.mqzn.commands.annotations.base.Default;
import io.github.mqzn.commands.annotations.base.ExecutionMeta;
import io.github.mqzn.commands.annotations.base.Range;
import io.github.mqzn.commands.annotations.base.Suggest;
import io.github.mqzn.commands.annotations.subcommands.SubCommandExecution;
import io.github.mqzn.commands.annotations.subcommands.SubCommandInfo;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@SubCommandInfo(name="determine")
@ExecutionMeta(permission="adapt.determine", description="Assign a skill, or UnAssign a skill as if you are learning / unlearning a skill.", syntax="<adaptationTarget> <assign> <force> <level> [player]")
public final class CommandSkillDeterminator {
    @SubCommandExecution
    public void execute(CommandSender commandSender, @Arg(id="adaptationTarget") @Suggest(provider=AdaptAdaptationProvider.class) String string, @Arg(id="assign", defaultValue="true") @Suggest(provider=BooleanSuggestionProvider.class) boolean bl, @Arg(id="force", defaultValue="false") @Suggest(provider=BooleanSuggestionProvider.class) boolean bl2, @Arg(id="level", defaultValue="1") @Range(min="1", max="54") Integer n, @Arg(id="player", optional=true) @Nullable Player player) {
        Player player2 = player;
        if (player2 == null && commandSender instanceof ConsoleCommandSender) {
            FConst.error("You must specify a player when using this command from console.", new Object[0]).send(commandSender);
        } else if (player2 == null) {
            player2 = (Player)commandSender;
        }
        String[] stringArray = string.split(":");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        for (Skill<?> skill : XMap.sortV(SkillRegistry.skills)) {
            if (!skill.getName().equalsIgnoreCase(string2)) continue;
            for (Adaptation<?> adaptation : skill.getAdaptations()) {
                if (!adaptation.getName().equalsIgnoreCase(string3)) continue;
                if (player2 != null) {
                    if (bl) {
                        adaptation.learn(player, n, bl2);
                    } else {
                        adaptation.unlearn(player, n, bl2);
                    }
                } else {
                    FConst.error("You must specify a player when using this command from console.", new Object[0]).send(commandSender);
                }
                return;
            }
            return;
        }
        this.info(commandSender);
    }

    @Default
    public void info(CommandSender commandSender) {
        FConst.success(" --- === " + C.GRAY + "[" + C.DARK_RED + "Adapt GUI Help" + C.GRAY + "]:  === ---", new Object[0]).send(commandSender);
        FConst.info("/adapt determine <adaptationTarget> <assign> <level> [player] [force]", new Object[0]).send(commandSender);
    }

    static {
        IBootstrap.dasBoot();
    }
}

