/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ArchitectGlass
extends SimpleAdaptation<Config> {
    public ArchitectGlass() {
        super("architect-glass");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "glass", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "glass", "name"));
        this.setIcon(Material.GLASS);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("architect", "glass", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        if (!(!this.hasAdaptation(player) || player.getInventory().getItemInMainHand().getType() != Material.AIR && this.isTool(player.getInventory().getItemInMainHand()) || blockBreakEvent.isCancelled())) {
            if (!this.canBlockBreak(player, blockBreakEvent.getBlock().getLocation())) {
                return;
            }
            if (blockBreakEvent.getBlock().getType().toString().contains("GLASS") && !blockBreakEvent.getBlock().getType().toString().contains("TINTED_GLASS")) {
                blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), new ItemStack(blockBreakEvent.getBlock().getType(), 1));
                blockBreakEvent.getBlock().getWorld().playSound(blockBreakEvent.getBlock().getLocation(), Sound.BLOCK_LARGE_AMETHYST_BUD_BREAK, 1.0f, 1.0f);
                if (((Config)this.getConfig()).showParticles) {
                    blockBreakEvent.getBlock().getWorld().spawnParticle(Particle.SCRAPE, blockBreakEvent.getBlock().getLocation(), 1);
                    J.a(() -> this.vfxCuboidOutline(blockBreakEvent.getBlock(), Particle.REVERSE_PORTAL));
                }
                blockBreakEvent.getBlock().breakNaturally();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = true;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        int maxLevel = 1;
        int initialCost = 0;
        double costFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

