/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class AxeChop
extends SimpleAdaptation<Config> {
    public AxeChop() {
        super("axe-chop");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "chop", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "chop", "name"));
        this.setIcon(Material.IRON_AXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(6911L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + n + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore1"));
        element.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(n)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore2"));
        element.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(n)) + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        if (player.getCooldown(player.getInventory().getItemInMainHand().getType()) > 0) {
            return;
        }
        if (playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && this.isAxe(player.getInventory().getItemInMainHand()) && this.hasAdaptation(player)) {
            if (!this.canBlockBreak(player, playerInteractEvent.getClickedBlock().getLocation())) {
                return;
            }
            BlockData blockData = playerInteractEvent.getClickedBlock().getBlockData();
            if (this.isLog(new ItemStack(blockData.getMaterial()))) {
                playerInteractEvent.setCancelled(true);
                player.getLocation().getWorld().playSound(player.getLocation(), Sound.ITEM_AXE_STRIP, 1.25f, 0.6f);
                for (int i = 0; i < this.getLevel(player); ++i) {
                    if (!this.breakStuff(playerInteractEvent.getClickedBlock(), this.getRange(this.getLevel(player)), player)) continue;
                    player.setCooldown(player.getInventory().getItemInMainHand().getType(), this.getCooldownTime(this.getLevelPercent(player)));
                    this.damageHand(player, this.getDamagePerBlock(this.getLevelPercent(player)));
                }
            }
        }
    }

    private int getRange(int n) {
        return n * ((Config)this.getConfig()).rangeLevelMultiplier;
    }

    private int getCooldownTime(double d) {
        return (int)(((Config)this.getConfig()).cooldownTicksBase + ((Config)this.getConfig()).cooldownTicksInverseLevelMultiplier * (1.0 - d));
    }

    private int getDamagePerBlock(double d) {
        return (int)(((Config)this.getConfig()).damagePerBlockBase + ((Config)this.getConfig()).damagePerBlockInverseLevelMultiplier * (1.0 - d));
    }

    private boolean breakStuff(Block block, int n, Player player) {
        Block block2;
        Block block3 = block;
        for (int i = block.getY(); i < n + block.getY() && this.isLog(new ItemStack((block2 = block.getWorld().getBlockAt(block.getX(), i, block.getZ())).getType())); ++i) {
            block3 = block2;
        }
        if (!this.canBlockBreak(player, block3.getLocation())) {
            Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
            return false;
        }
        if (!this.isLog(new ItemStack(block3.getType()))) {
            return false;
        }
        Block block4 = block3;
        block.getWorld().playSound(block4.getLocation(), Sound.ITEM_AXE_STRIP, 0.75f, 1.3f);
        player.breakBlock(block4);
        return true;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.35;
        int maxLevel = 5;
        int initialCost = 2;
        int rangeLevelMultiplier = 5;
        double cooldownTicksBase = 15.0;
        double cooldownTicksInverseLevelMultiplier = 16.0;
        double damagePerBlockBase = 1.0;
        double damagePerBlockInverseLevelMultiplier = 4.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

