/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.RayTraceResult;

public class CraftingDeconstruction
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public CraftingDeconstruction() {
        super("crafting-deconstruction");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "deconstruction", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "deconstruction", "name"));
        this.setIcon(Material.SHEARS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(1);
        this.setInterval(5590L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore1"));
        element.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore2"));
    }

    public ItemStack getDeconstructionOffering(ItemStack itemStack2) {
        int n;
        Object object;
        ShapelessRecipe shapelessRecipe;
        if (itemStack2 == null) {
            return null;
        }
        int n2 = 0;
        Recipe recipe = null;
        for (Recipe recipe2 : Bukkit.getRecipesFor((ItemStack)itemStack2)) {
            int n3 = 0;
            if (recipe2 instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe2;
                n3 = shapelessRecipe.getIngredientList().stream().mapToInt(ItemStack::getAmount).sum();
            } else if (recipe2 instanceof ShapedRecipe) {
                object = (ShapedRecipe)recipe2;
                n3 = object.getIngredientMap().values().stream().mapToInt(itemStack -> itemStack == null ? 0 : itemStack.getAmount()).sum();
            }
            if (n3 <= n2) continue;
            recipe = recipe2;
            n2 = n3;
        }
        if (recipe == null) {
            return null;
        }
        int n4 = 0;
        int n5 = 1;
        ItemStack itemStack3 = null;
        if (recipe instanceof ShapelessRecipe) {
            shapelessRecipe = (ShapelessRecipe)recipe;
            for (ItemStack itemStack4 : shapelessRecipe.getIngredientList()) {
                int n6 = itemStack4.getAmount() * itemStack2.getAmount();
                if (n6 <= n4) continue;
                n4 = n6;
                itemStack3 = itemStack4;
                n5 = shapelessRecipe.getResult().getAmount();
            }
        } else {
            object = (ShapedRecipe)recipe;
            HashMap hashMap = new HashMap();
            object.getIngredientMap().values().stream().filter(Objects::nonNull).forEach(itemStack -> hashMap.merge(itemStack.getType(), itemStack.getAmount(), Integer::sum));
            for (Map.Entry entry : hashMap.entrySet()) {
                int n7 = (Integer)entry.getValue() * itemStack2.getAmount();
                if (n7 <= n4) continue;
                n4 = n7;
                itemStack3 = new ItemStack((Material)entry.getKey(), ((Integer)entry.getValue()).intValue());
                n5 = object.getResult().getAmount();
            }
        }
        if (itemStack3 != null && itemStack3.getAmount() * itemStack2.getAmount() > 1 && (n = itemStack3.getAmount() * itemStack2.getAmount() / n5 / 2) <= itemStack3.getMaxStackSize() && this.getValue(itemStack3) < this.getValue(itemStack2)) {
            itemStack3.setAmount(n);
            return itemStack3.clone();
        }
        return null;
    }

    @EventHandler
    public void on(PlayerInteractEvent playerInteractEvent) {
        Entity entity2;
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (!player.isSneaking() || itemStack.getType() != Material.SHEARS) {
            return;
        }
        RayTraceResult rayTraceResult = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getLocation().getDirection(), 6.0, entity -> entity instanceof Item);
        if (rayTraceResult != null && (entity2 = rayTraceResult.getHitEntity()) instanceof Item) {
            Item item = (Item)entity2;
            this.processItemInteraction(player, itemStack, item);
        }
    }

    private void processItemInteraction(Player player, ItemStack itemStack, Item item) {
        ItemStack itemStack2 = item.getItemStack();
        ItemStack itemStack3 = this.getDeconstructionOffering(itemStack2);
        if (itemStack3 != null) {
            item.setItemStack(itemStack3);
            player.getWorld().playSound(item.getLocation(), Sound.BLOCK_BASALT_BREAK, 1.0f, 0.2f);
            player.getWorld().playSound(item.getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 1.0f, 0.7f);
            this.getSkill().xp(player, this.getValue(itemStack3));
            Damageable damageable = (Damageable)itemStack.getItemMeta();
            int n = damageable.getDamage() + 8 * itemStack2.getAmount();
            if (n >= itemStack.getType().getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
            } else {
                damageable.setDamage(n);
                itemStack.setItemMeta((ItemMeta)damageable);
            }
        } else {
            player.getWorld().playSound(item.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 9;
        int initialCost = 8;
        double costFactor = 1.355;

        static {
            IBootstrap.dasBoot();
        }
    }
}

