/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;

public class DiscoveryXpResist
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public DiscoveryXpResist() {
        super("discovery-xp-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "resist", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "resist", "name"));
        this.setIcon(Material.EMERALD);
        this.setInterval(5215L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore0"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(n)), 0) + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore1"));
        element.addLore(C.GREEN + "+ " + this.getXpTaken(n) + " " + C.GRAY + Localizer.dLocalize("discovery", "resist", "lore2"));
    }

    private double getEffectiveness(double d) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, d * d + ((Config)this.getConfig()).effectivenessBase);
    }

    private int getXpTaken(double d) {
        double d2 = (double)((Config)this.getConfig()).levelCostAdd * ((Config)this.getConfig()).amplifier - d * (double)((Config)this.getConfig()).levelDrain;
        return (int)d2;
    }

    @EventHandler
    public void on(EntityDamageEvent entityDamageEvent) {
        Player player;
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player && this.hasAdaptation(player = (Player)entity) && player.getLevel() > 1) {
            if (player.getLevel() < player.getLevel() - this.getXpTaken(this.getLevel(player))) {
                this.vfxFastRing(player.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                player.playSound(player.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
                return;
            }
            if (!this.cooldowns.containsKey(player) || this.cooldowns.containsKey(player) && M.ms() - this.cooldowns.get(player) > 15000L) {
                entityDamageEvent.setDamage(entityDamageEvent.getDamage() - entityDamageEvent.getDamage() * this.getEffectiveness(this.getLevelPercent(this.getLevel(player))));
                this.xp(player, 5.0);
                this.cooldowns.put(player, M.ms());
                if (player.getLevel() - this.getXpTaken(this.getLevel(player)) > 0) {
                    player.setLevel(player.getLevel() - this.getXpTaken(this.getLevel(player)));
                    this.vfxFastRing(player.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.LIME);
                    player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_REPAIR, 3.0f, 0.01f);
                    player.playSound(player.getLocation(), Sound.BLOCK_SHROOMLIGHT_HIT, 15.0f, 0.01f);
                } else {
                    this.vfxFastRing(player.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                    player.playSound(player.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
                }
            } else {
                this.vfxFastRing(player.getLocation().add(0.0, 0.05, 0.0), 1.0, Color.RED);
                player.playSound(player.getLocation(), Sound.BLOCK_FUNGUS_BREAK, 15.0f, 0.01f);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int initialCost = 3;
        double costFactor = 0.8;
        int maxLevel = 5;
        double effectivenessBase = 0.15;
        double maxEffectiveness = 0.95;
        int levelDrain = 2;
        int levelCostAdd = 12;
        double amplifier = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

