/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.enchanting;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EnchantingQuickEnchant
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public EnchantingQuickEnchant() {
        super("enchanting-quick-enchant");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("enchanting", "quickenchant", "description"));
        this.setDisplayName(Localizer.dLocalize("enchanting", "quickenchant", "name"));
        this.setIcon(Material.WRITABLE_BOOK);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(15100L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    private int getTotalLevelCount(int n) {
        return n + (n > ((Config)this.getConfig()).maxPowerBonusLimit ? n / ((Config)this.getConfig()).maxPowerBonus1PerLevels : 0);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + this.getTotalLevelCount(n) + C.GRAY + " " + Localizer.dLocalize("enchanting", "quickenchant", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent inventoryClickEvent) {
        Player player;
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = inventoryClickEvent.getWhoClicked();
        if (humanEntity instanceof Player && this.hasAdaptation(player = (Player)humanEntity) && inventoryClickEvent.getAction().equals((Object)InventoryAction.SWAP_WITH_CURSOR) && inventoryClickEvent.getClick().equals((Object)ClickType.LEFT) && (inventoryClickEvent.getSlotType().equals((Object)InventoryType.SlotType.CONTAINER) || inventoryClickEvent.getSlotType().equals((Object)InventoryType.SlotType.ARMOR) || inventoryClickEvent.getSlotType().equals((Object)InventoryType.SlotType.QUICKBAR)) && inventoryClickEvent.getCursor() != null && inventoryClickEvent.getCurrentItem() != null && inventoryClickEvent.getCursor().getType().equals((Object)Material.ENCHANTED_BOOK) && !inventoryClickEvent.getCurrentItem().getType().equals((Object)Material.BOOK) && !inventoryClickEvent.getCurrentItem().getType().equals((Object)Material.ENCHANTED_BOOK) && inventoryClickEvent.getCursor().getItemMeta() != null && (humanEntity = inventoryClickEvent.getCursor().getItemMeta()) instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)humanEntity;
            if (inventoryClickEvent.getCurrentItem().getItemMeta() != null && inventoryClickEvent.getCurrentItem().getAmount() == 1 && inventoryClickEvent.getCursor().getAmount() == 1) {
                humanEntity = inventoryClickEvent.getCurrentItem();
                ItemStack itemStack = inventoryClickEvent.getCursor();
                HashMap hashMap = new HashMap(humanEntity.getType().equals((Object)Material.ENCHANTED_BOOK) ? ((EnchantmentStorageMeta)humanEntity.getItemMeta()).getStoredEnchants() : humanEntity.getEnchantments());
                HashMap<Enchantment, Integer> hashMap2 = new HashMap<Enchantment, Integer>(enchantmentStorageMeta.getStoredEnchants());
                Map<Enchantment, Integer> map = XMap.copy(hashMap);
                HashMap<Enchantment, Integer> hashMap3 = new HashMap<Enchantment, Integer>();
                int n2 = hashMap.values().stream().mapToInt(n -> n).sum();
                if (hashMap2.isEmpty()) {
                    return;
                }
                for (Enchantment enchantment2 : XMap.k(hashMap2)) {
                    if (hashMap.containsKey(enchantment2)) continue;
                    n2 += ((Integer)hashMap2.get(enchantment2)).intValue();
                    map.put(enchantment2, (Integer)hashMap2.get(enchantment2));
                    hashMap3.put(enchantment2, (Integer)hashMap2.get(enchantment2));
                    hashMap2.remove(enchantment2);
                }
                if (n2 > this.getTotalLevelCount(this.getLevel(player))) {
                    Adapt.actionbar(player, C.RED + Localizer.dLocalize("enchanting", "quickenchant", "lore2") + this.getTotalLevelCount(this.getLevel(player)) + " " + Localizer.dLocalize("enchanting", "quickenchant", "lore3"));
                    player.playSound(player.getLocation(), Sound.BLOCK_CONDUIT_DEACTIVATE, 0.5f, 1.7f);
                    return;
                }
                if (!hashMap.equals(map)) {
                    ItemMeta itemMeta = humanEntity.getItemMeta();
                    if (itemMeta instanceof EnchantmentStorageMeta) {
                        Enchantment enchantment2;
                        enchantment2 = (EnchantmentStorageMeta)itemMeta;
                        enchantment2.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)enchantment2).removeStoredEnchant(arg_0));
                        map.forEach((arg_0, arg_1) -> EnchantingQuickEnchant.lambda$on$1((EnchantmentStorageMeta)enchantment2, arg_0, arg_1));
                        Adapt.messagePlayer(player, "---");
                        enchantment2.getStoredEnchants().forEach((enchantment, n) -> Adapt.messagePlayer(player, enchantment.getKey().getKey() + " " + n));
                    } else {
                        itemMeta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)itemMeta).removeEnchant(arg_0));
                        map.forEach((enchantment, n) -> itemMeta.addEnchant(enchantment, n.intValue(), true));
                    }
                    this.xp(player, 50.0);
                    humanEntity.setItemMeta(itemMeta);
                    inventoryClickEvent.setCurrentItem((ItemStack)humanEntity);
                    inventoryClickEvent.setCancelled(true);
                    player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.7f);
                    player.playSound(player.getLocation(), Sound.BLOCK_DEEPSLATE_TILES_BREAK, 0.5f, 0.7f);
                    this.getSkill().xp(player, 320 * hashMap3.values().stream().mapToInt(n -> n).sum());
                    if (hashMap2.isEmpty()) {
                        inventoryClickEvent.setCursor(null);
                    } else if (!enchantmentStorageMeta.getStoredEnchants().equals(hashMap2)) {
                        enchantmentStorageMeta.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)enchantmentStorageMeta).removeStoredEnchant(arg_0));
                        hashMap2.forEach((enchantment, n) -> enchantmentStorageMeta.addStoredEnchant(enchantment, n.intValue(), true));
                        itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
                        inventoryClickEvent.setCursor(itemStack);
                    }
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    private static /* synthetic */ void lambda$on$1(EnchantmentStorageMeta enchantmentStorageMeta, Enchantment enchantment, Integer n) {
        enchantmentStorageMeta.addStoredEnchant(enchantment, n.intValue(), true);
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 7;
        int initialCost = 8;
        double costFactor = 1.355;
        int maxPowerBonusLimit = 4;
        int maxPowerBonus1PerLevels = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

