/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.RNG;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class HerbalismGrowthAura
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public HerbalismGrowthAura() {
        super("herbalism-growth-aura");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "growthaura", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "growthaura", "name"));
        this.setIcon(Material.BONE_MEAL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(850L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.f(this.getRadius(this.getLevelPercent(n)), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore1"));
        element.addLore(C.GREEN + "+ " + Form.pc(this.getStrength(n), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore2"));
        element.addLore(C.YELLOW + "+ " + Form.f(this.getFoodCost(this.getLevelPercent(n)), 2) + C.GRAY + " " + Localizer.dLocalize("herbalism", "growthaura", "lore3"));
    }

    private double getRadius(double d) {
        return d * ((Config)this.getConfig()).radiusFactor;
    }

    private double getStrength(int n) {
        return (double)n * ((Config)this.getConfig()).strengthFactor;
    }

    private double getFoodCost(double d) {
        return M.lerp(1.0 - d, ((Config)this.getConfig()).maxFoodCost, ((Config)this.getConfig()).minFoodCost);
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                if (!this.hasAdaptation(player)) continue;
                double d = this.getRadius(this.getLevelPercent(player));
                double d2 = this.getStrength(this.getLevel(player));
                double d3 = Math.toRadians(Math.random() * 360.0);
                double d4 = this.getFoodCost(this.getLevelPercent(player));
                int n = 0;
                while ((double)n < Math.min(Math.min(d * d, 256.0), 3.0)) {
                    Ageable ageable;
                    int n2;
                    Location location = player.getLocation().clone().add(new Vector(Math.sin(d3), (double)RNG.r.i(-1, 1), Math.cos(d3)).multiply(Math.random() * d));
                    Block block = location.getWorld().getHighestBlockAt(location).getRelative(BlockFace.UP);
                    if (block.getBlockData() instanceof Ageable && (n2 = (ageable = (Ageable)block.getBlockData()).getMaximumAge() - ageable.getAge()) > 0) {
                        int n3 = (int)Math.max(1.0, Math.min(d2, (double)n2));
                        if (ageable.getMaximumAge() > ageable.getAge() && this.getPlayer(player).canConsumeFood(d4, 10)) {
                            while (n3-- > 0) {
                                J.s(() -> {
                                    Ageable ageable;
                                    if (this.getPlayer(player).consumeFood(d4, 10) && block.getBlockData() instanceof Ageable && (ageable = (Ageable)block.getBlockData()).getAge() < ageable.getMaximumAge()) {
                                        ageable.setAge(ageable.getAge() + 1);
                                        block.setBlockData((BlockData)ageable, true);
                                        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_CHORUS_FLOWER_DEATH, 0.25f, RNG.r.f(0.3f, 0.7f));
                                        if (((Config)this.getConfig()).showParticles) {
                                            player.spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().clone().add(0.5, 0.5, 0.5), 3, 0.3, 0.3, 0.3, 0.9);
                                        }
                                    }
                                }, RNG.r.i(30, 60));
                            }
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 8;
        int maxLevel = 7;
        int initialCost = 12;
        double costFactor = 0.325;
        double minFoodCost = 0.05;
        double maxFoodCost = 0.4;
        double radiusFactor = 18.0;
        double strengthFactor = 0.75;

        static {
            IBootstrap.dasBoot();
        }
    }
}

