/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class HunterDropToInventory
extends SimpleAdaptation<Config> {
    public HunterDropToInventory() {
        super("hunter-drop-to-inventory");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "droptoinventory", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "droptoinventory", "name"));
        this.setIcon(Material.DIRT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(18440L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GRAY + Localizer.dLocalize("hunter", "droptoinventory", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockDropItemEvent blockDropItemEvent) {
        if (blockDropItemEvent.isCancelled()) {
            return;
        }
        Player player = blockDropItemEvent.getPlayer();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (player.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (!this.canInteract(player, blockDropItemEvent.getBlock().getLocation())) {
            return;
        }
        if (!this.canPVP(player, blockDropItemEvent.getBlock().getLocation())) {
            return;
        }
        if (ItemListings.toolSwords.contains(player.getInventory().getItemInMainHand().getType())) {
            List<Item> list = XList.copy(blockDropItemEvent.getItems());
            blockDropItemEvent.getItems().clear();
            player.playSound(player.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
            for (Item item : list) {
                if (player.getInventory().addItem(new ItemStack[]{item.getItemStack()}).isEmpty()) continue;
                player.getWorld().dropItem(player.getLocation(), item.getItemStack());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDeathEvent entityDeathEvent) {
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity.getKiller() == null || livingEntity.getKiller().getType() != EntityType.PLAYER) {
            return;
        }
        Player player = livingEntity.getKiller();
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (entityDeathEvent.getEntity() instanceof Player) {
            return;
        }
        if (entityDeathEvent.getEntity().getKiller() != null && entityDeathEvent.getEntity().getKiller().getClass().getSimpleName().equals("CraftPlayer")) {
            player.playSound(player.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
            entityDeathEvent.getDrops().forEach(itemStack -> {
                if (!player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) {
                    player.getWorld().dropItem(player.getLocation(), itemStack);
                }
            });
            entityDeathEvent.getDrops().clear();
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int maxLevel = 1;
        int initialCost = 2;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

