/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.nether;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;

public class NetherFireResist
extends SimpleAdaptation<Config> {
    private final Random random = new Random();

    public NetherFireResist() {
        super("nether-fire-resist");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("nether", "fireresist", "description"));
        this.setDisplayName(Localizer.dLocalize("nether", "fireresist", "name"));
        this.setIcon(Material.BLAZE_POWDER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4333L);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.RED + "+ " + Form.pc(this.getFireResist(n), 0) + C.GRAY + " " + Localizer.dLocalize("nether", "fireresist", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FIRE && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        if (this.random.nextDouble() < this.getFireResist(this.getLevel(player))) {
            entityDamageEvent.setCancelled(true);
        }
    }

    public double getFireResist(double d) {
        return ((Config)this.getConfig()).fireResistBase + ((Config)this.getConfig()).fireResistFactor * d;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 4;
        double costFactor = 0.75;
        int maxLevel = 3;
        int initialCost = 6;
        double fireResistBase = 0.1;
        double fireResistFactor = 0.25;

        public boolean isPermanent() {
            return this.permanent;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseCost() {
            return this.baseCost;
        }

        public double getCostFactor() {
            return this.costFactor;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public int getInitialCost() {
            return this.initialCost;
        }

        public double getFireResistBase() {
            return this.fireResistBase;
        }

        public double getFireResistFactor() {
            return this.fireResistFactor;
        }

        public void setPermanent(boolean bl) {
            this.permanent = bl;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setBaseCost(int n) {
            this.baseCost = n;
        }

        public void setCostFactor(double d) {
            this.costFactor = d;
        }

        public void setMaxLevel(int n) {
            this.maxLevel = n;
        }

        public void setInitialCost(int n) {
            this.initialCost = n;
        }

        public void setFireResistBase(double d) {
            this.fireResistBase = d;
        }

        public void setFireResistFactor(double d) {
            this.fireResistFactor = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            Config config = (Config)object;
            if (!config.canEqual(this)) {
                return false;
            }
            if (this.isPermanent() != config.isPermanent()) {
                return false;
            }
            if (this.isEnabled() != config.isEnabled()) {
                return false;
            }
            if (this.getBaseCost() != config.getBaseCost()) {
                return false;
            }
            if (Double.compare(this.getCostFactor(), config.getCostFactor()) != 0) {
                return false;
            }
            if (this.getMaxLevel() != config.getMaxLevel()) {
                return false;
            }
            if (this.getInitialCost() != config.getInitialCost()) {
                return false;
            }
            if (Double.compare(this.getFireResistBase(), config.getFireResistBase()) != 0) {
                return false;
            }
            return Double.compare(this.getFireResistFactor(), config.getFireResistFactor()) == 0;
        }

        protected boolean canEqual(Object object) {
            return object instanceof Config;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + (this.isPermanent() ? 79 : 97);
            n2 = n2 * 59 + (this.isEnabled() ? 79 : 97);
            n2 = n2 * 59 + this.getBaseCost();
            long l = Double.doubleToLongBits(this.getCostFactor());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            n2 = n2 * 59 + this.getMaxLevel();
            n2 = n2 * 59 + this.getInitialCost();
            long l2 = Double.doubleToLongBits(this.getFireResistBase());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getFireResistFactor());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            return n2;
        }

        public String toString() {
            return "NetherFireResist.Config(permanent=" + this.isPermanent() + ", enabled=" + this.isEnabled() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", fireResistBase=" + this.getFireResistBase() + ", fireResistFactor=" + this.getFireResistFactor() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

