/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeAutosmelt
extends SimpleAdaptation<Config> {
    public PickaxeAutosmelt() {
        super("pickaxe-autosmelt");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "autosmelt", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "autosmelt", "name"));
        this.setIcon(Material.RAW_GOLD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(7444L);
    }

    static void autosmeltBlockDTI(Block block, Player player) {
        int n = 1;
        Random random = new Random();
        if (player.getInventory().getItemInMainHand().getEnchantments().get(Enchantment.LOOT_BONUS_BLOCKS) != null) {
            n = player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + random.nextInt(3);
        }
        switch (block.getType()) {
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                if (!player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_INGOT, n)}).isEmpty()) {
                    block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.IRON_INGOT, n));
                }
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case NETHER_GOLD_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                if (!player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, n)}).isEmpty()) {
                    block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.GOLD_INGOT, n));
                }
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                if (!player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COPPER_INGOT, n)}).isEmpty()) {
                    block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.COPPER_INGOT, n));
                }
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
            }
        }
    }

    static void autosmeltBlock(Block block, Player player) {
        int n = 1;
        Random random = new Random();
        if (player.getInventory().getItemInMainHand().getEnchantments().get(Enchantment.LOOT_BONUS_BLOCKS) != null) {
            n = player.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + random.nextInt(3);
        }
        switch (block.getType()) {
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.IRON_INGOT, n));
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case NETHER_GOLD_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.GOLD_INGOT, n));
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                if (block.getLocation().getWorld() == null) {
                    return;
                }
                block.setType(Material.AIR);
                block.getLocation().getWorld().dropItemNaturally(block.getLocation(), new ItemStack(Material.COPPER_INGOT, n));
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                block.getWorld().spawnParticle(Particle.LAVA, block.getLocation(), 3, 0.5, 0.5, 0.5);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + Localizer.dLocalize("pickaxe", "autosmelt", "lore1"));
        element.addLore(C.GREEN + (double)n * 1.25 + C.GRAY + Localizer.dLocalize("pickaxe", "autosmelt", "lore2"));
    }

    @EventHandler
    public void on(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (!this.hasAdaptation(player)) {
            return;
        }
        if (!blockBreakEvent.getBlock().getBlockData().getMaterial().name().endsWith("_ORE") && !ItemListings.getSmeltOre().contains(blockBreakEvent.getBlock().getType())) {
            return;
        }
        if (!this.canBlockBreak(player, blockBreakEvent.getBlock().getLocation())) {
            return;
        }
        if (this.getPlayer(player).getData().getSkillLines() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(player).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
            PickaxeAutosmelt.autosmeltBlockDTI(blockBreakEvent.getBlock(), player);
        } else {
            PickaxeAutosmelt.autosmeltBlock(blockBreakEvent.getBlock(), player);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 4;
        int initialCost = 4;
        double costFactor = 2.325;

        static {
            IBootstrap.dasBoot();
        }
    }
}

