/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.seaborrne;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SeaborneOxygen
extends SimpleAdaptation<Config> {
    public SeaborneOxygen() {
        super("seaborne-oxygen");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("seaborn", "oxygen", "description"));
        this.setDisplayName(Localizer.dLocalize("seaborn", "oxygen", "name"));
        this.setIcon(Material.GLASS_PANE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(3750L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int n, Element element) {
        element.addLore(C.GREEN + "+ " + Form.pc(this.getAirBoost(n), 0) + C.GRAY + Localizer.dLocalize("seaborn", "oxygen", "lore1"));
    }

    public double getAirBoost(int n) {
        return this.getLevelPercent(n);
    }

    @Override
    public void onTick() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getLocation().getBlock().getType() != Material.WATER || !this.hasAdaptation(player)) continue;
            J.s(() -> player.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, this.getLevel(player) * ((Config)this.getConfig()).airPerLevelTics, this.getLevel(player))));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 0.525;
        int airPerLevelTics = 15;

        static {
            IBootstrap.dasBoot();
        }
    }
}

