/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.item.DataItem;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KnowledgeOrb
implements DataItem<Data> {
    public static KnowledgeOrb io;

    public static Data get(ItemStack itemStack) {
        return (Data)io.getData(itemStack);
    }

    public static String getSkill(ItemStack itemStack) {
        if (io.getData(itemStack) != null) {
            return ((Data)io.getData(itemStack)).getSkill();
        }
        return null;
    }

    public static long getKnowledge(ItemStack itemStack) {
        if (io.getData(itemStack) != null) {
            return ((Data)io.getData(itemStack)).getKnowledge();
        }
        return 0L;
    }

    public static void set(ItemStack itemStack, String string, int n) {
        io.setData(itemStack, new Data(string, n));
    }

    public static ItemStack with(String string, int n) {
        return io.withData(new Data(string, n));
    }

    @Override
    public Material getMaterial() {
        return Material.SNOWBALL;
    }

    @Override
    public Class<Data> getType() {
        return Data.class;
    }

    @Override
    public void applyLore(Data data, List<String> list) {
        list.add(C.WHITE + Localizer.dLocalize("snippets", "knowledgeorb", "contains") + " " + C.UNDERLINE + C.WHITE + data.knowledge + " " + Localizer.dLocalize("snippets", "knowledgeorb", "knowledge"));
        list.add(C.LIGHT_PURPLE + Localizer.dLocalize("snippets", "knowledgeorb", "rightclick") + " " + C.GRAY + Localizer.dLocalize("snippets", "knowledgeorb", "togainknowledge"));
    }

    @Override
    public void applyMeta(Data data, ItemMeta itemMeta) {
        itemMeta.addEnchant(Enchantment.BINDING_CURSE, 10, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
        itemMeta.setDisplayName(Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(data.skill).getDisplayName() + " " + Localizer.dLocalize("snippets", "knowledgeorb", "knowledgeorb"));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KnowledgeOrb)) {
            return false;
        }
        KnowledgeOrb knowledgeOrb = (KnowledgeOrb)object;
        return knowledgeOrb.canEqual(this);
    }

    protected boolean canEqual(Object object) {
        return object instanceof KnowledgeOrb;
    }

    public int hashCode() {
        boolean bl = true;
        return 1;
    }

    public String toString() {
        return "KnowledgeOrb()";
    }

    static {
        IBootstrap.dasBoot();
        io = new KnowledgeOrb();
    }

    public static class Data {
        private String skill;
        private int knowledge;

        public void apply(Player player) {
            Adapt.instance.getAdaptServer().getPlayer(player).getSkillLine(this.skill).giveKnowledge(this.knowledge);
        }

        public Data(String string, int n) {
            this.skill = string;
            this.knowledge = n;
        }

        public String getSkill() {
            return this.skill;
        }

        public int getKnowledge() {
            return this.knowledge;
        }

        public void setSkill(String string) {
            this.skill = string;
        }

        public void setKnowledge(int n) {
            this.knowledge = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Data)) {
                return false;
            }
            Data data = (Data)object;
            if (!data.canEqual(this)) {
                return false;
            }
            if (this.getKnowledge() != data.getKnowledge()) {
                return false;
            }
            String string = this.getSkill();
            String string2 = data.getSkill();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Data;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            n2 = n2 * 59 + this.getKnowledge();
            String string = this.getSkill();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        public String toString() {
            return "KnowledgeOrb.Data(skill=" + this.getSkill() + ", knowledge=" + this.getKnowledge() + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

