/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class GriefDefenderProtector
implements Protector {
    @Override
    public boolean checkRegion(Player player, Location location, Adaptation<?> adaptation) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)location);
        return this.checkPerm(player, claim, adaptation) || claim.isWilderness();
    }

    @Override
    public boolean canPVP(Player player, Location location, Adaptation<?> adaptation) {
        Claim claim = GriefDefender.getCore().getClaimAt((Object)location);
        if (this.checkPerm(player, claim, adaptation)) {
            return claim.isPvpAllowed();
        }
        return false;
    }

    private boolean checkPerm(Player player, Claim claim, Adaptation<?> adaptation) {
        if (claim == null) {
            return true;
        }
        UUID uUID = player.getUniqueId();
        return claim.isWilderness() || claim.getOwnerUniqueId().equals(uUID) || claim.getUserTrusts().contains(uUID);
    }

    @Override
    public boolean canPVE(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, GriefDefender.getCore().getClaimAt((Object)location), adaptation);
    }

    @Override
    public boolean canInteract(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, GriefDefender.getCore().getClaimAt((Object)location), adaptation);
    }

    @Override
    public boolean canAccessChest(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, GriefDefender.getCore().getClaimAt((Object)location), adaptation);
    }

    @Override
    public boolean canBlockBreak(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, GriefDefender.getCore().getClaimAt((Object)location), adaptation);
    }

    @Override
    public boolean canBlockPlace(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, GriefDefender.getCore().getClaimAt((Object)location), adaptation);
    }

    @Override
    public String getName() {
        return "GriefDefender";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isFactionsClaim();
    }

    static {
        IBootstrap.dasBoot();
    }
}

