/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Objects;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class GriefPreventionProtector
implements Protector {
    @Override
    public boolean canBlockBreak(Player player, Location location, Adaptation<?> adaptation) {
        return this.canEditClaim(player, location);
    }

    @Override
    public boolean canBlockPlace(Player player, Location location, Adaptation<?> adaptation) {
        return this.canEditClaim(player, location);
    }

    @Override
    public String getName() {
        return "GriefPrevention";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isGriefprevention();
    }

    @Override
    public void unregister() {
        Protector.super.unregister();
    }

    private boolean canEditClaim(Player player, Location location) {
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, true, null);
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (claim == null) {
            return true;
        }
        if (!claim.isAdminClaim() && Objects.equals(claim.getOwnerID(), player.getUniqueId())) {
            return true;
        }
        if (claim.getPermission(player.getUniqueId().toString()) == ClaimPermission.Build) {
            return true;
        }
        return playerData.ignoreClaims || claim.isAdminClaim() && player.hasPermission("griefprevention.adminclaims");
    }

    static {
        IBootstrap.dasBoot();
    }
}

