/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.protector;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.protection.Protector;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ResidenceProtector
implements Protector {
    public ResidenceProtector() {
        FlagPermissions.addFlag((String)"use-adaptations");
    }

    @Override
    public boolean checkRegion(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkPerm(player, location, "use-adaptations");
    }

    @Override
    public boolean canBlockBreak(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.destroy);
    }

    @Override
    public boolean canBlockPlace(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.place);
    }

    @Override
    public boolean canPVP(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.pvp);
    }

    @Override
    public boolean canPVE(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.damage);
    }

    @Override
    public boolean canInteract(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.use);
    }

    @Override
    public boolean canAccessChest(Player player, Location location, Adaptation<?> adaptation) {
        return this.checkRegion(player, location, adaptation) && this.checkPerm(player, location, Flags.container);
    }

    private boolean checkPerm(Player player, Location location, Flags flags) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        J.s(() -> {
            ClaimedResidence claimedResidence;
            if (!Residence.getInstance().isDisabledWorld(location.getWorld()) && (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(location)) != null) {
                atomicBoolean.set(claimedResidence.getPermissions().playerHas(player.getName(), flags, true));
            }
        });
        return atomicBoolean.get();
    }

    private boolean checkPerm(Player player, Location location, String string) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        J.s(() -> {
            ClaimedResidence claimedResidence;
            if (!Residence.getInstance().isDisabledWorld(location.getWorld()) && (claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(location)) != null) {
                atomicBoolean.set(claimedResidence.getPermissions().playerHas(player.getName(), string, true));
            }
        });
        return true;
    }

    @Override
    public String getName() {
        return "Residence";
    }

    @Override
    public boolean isEnabledByDefault() {
        return AdaptConfig.get().getProtectorSupport().isResidence();
    }

    static {
        IBootstrap.dasBoot();
    }
}

