/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.axe.AxeChop;
import com.volmit.adapt.content.adaptation.axe.AxeCraftLogSwap;
import com.volmit.adapt.content.adaptation.axe.AxeDropToInventory;
import com.volmit.adapt.content.adaptation.axe.AxeGroundSmash;
import com.volmit.adapt.content.adaptation.axe.AxeLeafVeinminer;
import com.volmit.adapt.content.adaptation.axe.AxeWoodVeinminer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillAxes
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillAxes() {
        super("axes", Localizer.dLocalize("skill", "axes", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "axes", "description1") + C.ITALIC + Localizer.dLocalize("skill", "axes", "description2") + C.GRAY + " " + Localizer.dLocalize("skill", "axes", "description3"));
        this.setDisplayName(Localizer.dLocalize("skill", "axes", "name"));
        this.setInterval(5251L);
        this.setIcon(Material.GOLDEN_AXE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new AxeGroundSmash());
        this.registerAdaptation(new AxeChop());
        this.registerAdaptation(new AxeDropToInventory());
        this.registerAdaptation(new AxeLeafVeinminer());
        this.registerAdaptation(new AxeWoodVeinminer());
        this.registerAdaptation(new AxeCraftLogSwap());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_AXE).key("challenge_chop_1k").title(Localizer.dLocalize("advancement", "challenge_chop_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_AXE).key("challenge_chop_5k").title(Localizer.dLocalize("advancement", "challenge_chop_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_AXE).key("challenge_chop_50k").title(Localizer.dLocalize("advancement", "challenge_chop_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_AXE).key("challenge_chop_500k").title(Localizer.dLocalize("advancement", "challenge_chop_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHERITE_AXE).key("challenge_chop_5m").title(Localizer.dLocalize("advancement", "challenge_chop_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_chop_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_1k").goal(1000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_5k").goal(5000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_50k").goal(50000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_500k").goal(500000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_chop_5m").goal(5000000.0).stat("axes.blocks.broken").reward(((Config)this.getConfig()).challengeChopReward).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) {
                if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
                    return;
                }
                this.shouldReturnForPlayer(player, () -> {
                    if (entityDamageByEntityEvent.getEntity().isDead() || entityDamageByEntityEvent.getEntity().isInvulnerable() || player.isDead() || player.isInvulnerable()) {
                        return;
                    }
                    AdaptPlayer adaptPlayer = this.getPlayer(player);
                    ItemStack itemStack = adaptPlayer.getPlayer().getInventory().getItemInMainHand();
                    if (this.isAxe(itemStack)) {
                        this.handleCooldown(player, () -> {
                            adaptPlayer.getData().addStat("axes.swings", 1.0);
                            adaptPlayer.getData().addStat("axes.damage", entityDamageByEntityEvent.getDamage());
                            this.xp(adaptPlayer.getPlayer(), entityDamageByEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).axeDamageXPMultiplier * entityDamageByEntityEvent.getDamage());
                        });
                    }
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(player, () -> {
            if (this.isAxe(player.getInventory().getItemInMainHand()) && this.isLog(new ItemStack(blockBreakEvent.getBlock().getType()))) {
                double d = this.getValue(blockBreakEvent.getBlock().getType());
                AdaptPlayer adaptPlayer = this.getPlayer(player);
                adaptPlayer.getData().addStat("axes.blocks.broken", 1.0);
                adaptPlayer.getData().addStat("axes.blocks.value", this.getValue(blockBreakEvent.getBlock().getBlockData()));
                this.handleCooldown(player, () -> this.xp(player, blockBreakEvent.getBlock().getLocation().clone().add(0.5, 0.5, 0.5), this.blockXP(blockBreakEvent.getBlock(), d)));
            }
        });
    }

    private void handleCooldown(Player player, Runnable runnable) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        runnable.run();
    }

    @Override
    public double getValue(Material material) {
        double d = super.getValue(material) * ((Config)this.getConfig()).valueXPMultiplier;
        d += Math.min(((Config)this.getConfig()).maxHardnessBonus, (double)material.getHardness());
        d += Math.min(((Config)this.getConfig()).maxBlastResistanceBonus, (double)material.getBlastResistance());
        if (material.name().endsWith("_LOG") || material.name().endsWith("_WOOD")) {
            d += ((Config)this.getConfig()).logOrWoodXPMultiplier;
        }
        if (material.name().endsWith("_LEAVES")) {
            d += ((Config)this.getConfig()).leavesMultiplier;
        }
        if (material.getHardness() == 0.0f) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double challengeChopReward = 1750.0;
        double logOrWoodXPMultiplier = 2.67;
        double leavesMultiplier = 1.11;
        long cooldownDelay = 2250L;
        double valueXPMultiplier = 0.225;
        double axeDamageXPMultiplier = 13.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

