/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.brewing.BrewingAbsorption;
import com.volmit.adapt.content.adaptation.brewing.BrewingBlindness;
import com.volmit.adapt.content.adaptation.brewing.BrewingDarkness;
import com.volmit.adapt.content.adaptation.brewing.BrewingDecay;
import com.volmit.adapt.content.adaptation.brewing.BrewingFatigue;
import com.volmit.adapt.content.adaptation.brewing.BrewingHaste;
import com.volmit.adapt.content.adaptation.brewing.BrewingHealthBoost;
import com.volmit.adapt.content.adaptation.brewing.BrewingHunger;
import com.volmit.adapt.content.adaptation.brewing.BrewingLingering;
import com.volmit.adapt.content.adaptation.brewing.BrewingNausea;
import com.volmit.adapt.content.adaptation.brewing.BrewingResistance;
import com.volmit.adapt.content.adaptation.brewing.BrewingSaturation;
import com.volmit.adapt.content.adaptation.brewing.BrewingSuperHeated;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.content.matter.BrewingStandOwnerMatter;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.spatial.matter.SpatialMatter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;

public class SkillBrewing
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillBrewing() {
        super("brewing", Localizer.dLocalize("skill", "brewing", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.LIGHT_PURPLE);
        this.setDescription(Localizer.dLocalize("skill", "brewing", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "brewing", "name"));
        this.setInterval(5851L);
        this.setIcon(Material.LINGERING_POTION);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new BrewingLingering());
        this.registerAdaptation(new BrewingSuperHeated());
        this.registerAdaptation(new BrewingAbsorption());
        this.registerAdaptation(new BrewingBlindness());
        this.registerAdaptation(new BrewingDarkness());
        this.registerAdaptation(new BrewingDecay());
        this.registerAdaptation(new BrewingFatigue());
        this.registerAdaptation(new BrewingHaste());
        this.registerAdaptation(new BrewingHealthBoost());
        this.registerAdaptation(new BrewingHunger());
        this.registerAdaptation(new BrewingNausea());
        this.registerAdaptation(new BrewingResistance());
        this.registerAdaptation(new BrewingSaturation());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_1k").title(Localizer.dLocalize("advancement", "challenge_brew_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_5k").title(Localizer.dLocalize("advancement", "challenge_brew_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_50k").title(Localizer.dLocalize("advancement", "challenge_brew_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_500k").title(Localizer.dLocalize("advancement", "challenge_brew_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.POTION).key("challenge_brew_5m").title(Localizer.dLocalize("advancement", "challenge_brew_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_brew_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_1k").goal(1000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_5k").goal(5000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_50k").goal(50000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_500k").goal(500000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brew_5m").goal(5000000.0).stat("brewing.consumed").reward(((Config)this.getConfig()).challengeBrew1k).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_1k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_5k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_50k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_500k").title(Localizer.dLocalize("advancement", "challenge_brewsplash_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.SPLASH_POTION).key("challenge_brewsplash_5m").title(Localizer.dLocalize("advancement", "challenge_brewsplash_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_brewsplash_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_1k").goal(1000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_5k").goal(5000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_50k").goal(50000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_500k").goal(500000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_brewsplash_5m").goal(5000000.0).stat("brewing.splashes").reward(((Config)this.getConfig()).challengeBrewSplash1k).build());
        SpatialMatter.registerSliceType(new BrewingStandOwnerMatter());
    }

    private void handleCooldown(Player player, Runnable runnable) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        runnable.run();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerItemConsumeEvent playerItemConsumeEvent) {
        Player player = playerItemConsumeEvent.getPlayer();
        if (playerItemConsumeEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(player, (Cancellable)playerItemConsumeEvent, () -> {
            ItemMeta itemMeta = playerItemConsumeEvent.getItem().getItemMeta();
            if (itemMeta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                if (!(playerItemConsumeEvent.getItem().toString().contains("potion-type=minecraft:water") || playerItemConsumeEvent.getItem().toString().contains("potion-type=minecraft:mundane") || playerItemConsumeEvent.getItem().toString().contains("potion-type=minecraft:thick") || playerItemConsumeEvent.getItem().toString().contains("potion-type=minecraft:awkward"))) {
                    this.getPlayer(player).getData().addStat("brewing.consumed", 1.0);
                    this.handleCooldown(player, () -> this.xp(player, player.getLocation(), ((Config)this.getConfig()).splashXP + ((Config)this.getConfig()).splashMultiplier * potionMeta.getCustomEffects().stream().mapToDouble(potionEffect -> (double)(potionEffect.getAmplifier() + 1) * ((double)potionEffect.getDuration() / 20.0)).sum() + ((Config)this.getConfig()).splashMultiplier * (double)(potionMeta.getBasePotionData().isUpgraded() ? 50 : 25)));
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PotionSplashEvent potionSplashEvent) {
        if (potionSplashEvent.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = potionSplashEvent.getPotion().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            this.shouldReturnForPlayer(player, (Cancellable)potionSplashEvent, () -> {
                AdaptPlayer adaptPlayer = this.getPlayer(player);
                this.getPlayer(player).getData().addStat("brewing.splashes", 1.0);
                this.xp(adaptPlayer.getPlayer(), potionSplashEvent.getEntity().getLocation(), ((Config)this.getConfig()).splashXP + ((Config)this.getConfig()).splashMultiplier * potionSplashEvent.getPotion().getEffects().stream().mapToDouble(potionEffect -> (double)(potionEffect.getAmplifier() + 1) * ((double)potionEffect.getDuration() / 20.0)).sum());
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockPlaceEvent blockPlaceEvent) {
        if (blockPlaceEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(blockPlaceEvent.getPlayer(), (Cancellable)blockPlaceEvent, () -> {
            if (blockPlaceEvent.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
                WorldData.of(blockPlaceEvent.getBlock().getWorld()).getMantle().set(blockPlaceEvent.getBlock().getX(), blockPlaceEvent.getBlock().getY(), blockPlaceEvent.getBlock().getZ(), new BrewingStandOwner(blockPlaceEvent.getPlayer().getUniqueId()));
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        this.shouldReturnForPlayer(blockBreakEvent.getPlayer(), (Cancellable)blockBreakEvent, () -> {
            if (blockBreakEvent.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
                WorldData.of(blockBreakEvent.getBlock().getWorld()).getMantle().remove(blockBreakEvent.getBlock().getX(), blockBreakEvent.getBlock().getY(), blockBreakEvent.getBlock().getZ(), BrewingStandOwner.class);
            }
        });
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        double challengeBrew1k = 1000.0;
        double challengeBrewSplash1k = 1000.0;
        double splashXP = 100.0;
        long cooldownDelay = 3250L;
        double splashMultiplier = 0.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

