/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.hunter.HunterAdrenaline;
import com.volmit.adapt.content.adaptation.hunter.HunterDropToInventory;
import com.volmit.adapt.content.adaptation.hunter.HunterInvis;
import com.volmit.adapt.content.adaptation.hunter.HunterJumpBoost;
import com.volmit.adapt.content.adaptation.hunter.HunterLuck;
import com.volmit.adapt.content.adaptation.hunter.HunterRegen;
import com.volmit.adapt.content.adaptation.hunter.HunterResistance;
import com.volmit.adapt.content.adaptation.hunter.HunterSpeed;
import com.volmit.adapt.content.adaptation.hunter.HunterStrength;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class SkillHunter
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillHunter() {
        super("hunter", Localizer.dLocalize("skill", "hunter", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.RED);
        this.setDescription(Localizer.dLocalize("skill", "hunter", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "hunter", "name"));
        this.setInterval(4150L);
        this.setIcon(Material.BONE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new HunterAdrenaline());
        this.registerAdaptation(new HunterRegen());
        this.registerAdaptation(new HunterInvis());
        this.registerAdaptation(new HunterJumpBoost());
        this.registerAdaptation(new HunterLuck());
        this.registerAdaptation(new HunterSpeed());
        this.registerAdaptation(new HunterStrength());
        this.registerAdaptation(new HunterResistance());
        this.registerAdaptation(new HunterDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("horrible_person").title(Localizer.dLocalize("advancement", "horrible_person", "title")).description(Localizer.dLocalize("advancement", "horrible_person", "description")).frame(AdvancementDisplay.AdvancementFrame.GOAL).visibility(AdvancementVisibility.HIDDEN).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("challenge_turtle_egg_smasher").title(Localizer.dLocalize("advancement", "challenge_turtle_egg_smasher", "title")).description(Localizer.dLocalize("advancement", "challenge_turtle_egg_smasher", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.TURTLE_EGG).key("challenge_turtle_egg_annihilator").title(Localizer.dLocalize("advancement", "challenge_turtle_egg_annihilator", "title")).description(Localizer.dLocalize("advancement", "challenge_turtle_egg_annihilator", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.BONE).key("challenge_novice_hunter").title(Localizer.dLocalize("advancement", "challenge_novice_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_novice_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_SWORD).key("challenge_intermediate_hunter").title(Localizer.dLocalize("advancement", "challenge_intermediate_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_intermediate_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_SWORD).key("challenge_advanced_hunter").title(Localizer.dLocalize("advancement", "challenge_advanced_hunter", "title")).description(Localizer.dLocalize("advancement", "challenge_advanced_hunter", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.CREEPER_HEAD).key("challenge_creeper_conqueror").title(Localizer.dLocalize("advancement", "challenge_creeper_conqueror", "title")).description(Localizer.dLocalize("advancement", "challenge_creeper_conqueror", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.TNT).key("challenge_creeper_annihilator").title(Localizer.dLocalize("advancement", "challenge_creeper_annihilator", "title")).description(Localizer.dLocalize("advancement", "challenge_creeper_annihilator", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("horrible_person").goal(1.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_turtle_egg_smasher").goal(100.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_turtle_egg_annihilator").goal(1000.0).stat("killed.turtleeggs").reward(((Config)this.getConfig()).turtleEggKillXP * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_novice_hunter").goal(100.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_intermediate_hunter").goal(1000.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_advanced_hunter").goal(10000.0).stat("killed.monsters").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_creeper_conqueror").goal(100.0).stat("killed.creepers").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_creeper_annihilator").goal(1000.0).stat("killed.creepers").reward(((Config)this.getConfig()).turtleEggKillXP * 3.0).build());
    }

    private void handleCooldownAndXp(Player player, double d) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        this.xp(player, d);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(blockBreakEvent.getPlayer(), (Cancellable)blockBreakEvent, () -> {
            if (blockBreakEvent.getBlock().getType().equals((Object)Material.TURTLE_EGG)) {
                this.handleCooldownAndXp(player, ((Config)this.getConfig()).turtleEggKillXP);
                this.getPlayer(player).getData().addStat("killed.tutleeggs", 1.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.isCancelled()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        this.shouldReturnForPlayer(playerInteractEvent.getPlayer(), (Cancellable)playerInteractEvent, () -> {
            if (playerInteractEvent.getAction().equals((Object)Action.PHYSICAL) && playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getClickedBlock().getType().equals((Object)Material.TURTLE_EGG)) {
                this.handleCooldownAndXp(player, ((Config)this.getConfig()).turtleEggKillXP);
                this.getPlayer(player).getData().addStat("killed.tutleeggs", 1.0);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntity().getKiller() == null) {
            return;
        }
        Player player = entityDeathEvent.getEntity().getKiller();
        if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
            return;
        }
        this.shouldReturnForPlayer(player, () -> {
            if (entityDeathEvent.getEntity().getType().equals((Object)EntityType.CREEPER)) {
                double d = ((Config)this.getConfig()).creeperKillMultiplier;
                double d2 = entityDeathEvent.getEntity().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * ((Config)this.getConfig()).killMaxHealthXPMultiplier * d;
                if (entityDeathEvent.getEntity().getPortalCooldown() > 0) {
                    d2 *= ((Config)this.getConfig()).spawnerMobReductionXpMultiplier;
                }
                this.getPlayer(player).getData().addStat("killed.kills", 1.0);
                this.handleCooldownAndXp(player, d2);
            } else {
                this.handleEntityKill(player, (Entity)entityDeathEvent.getEntity());
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(CreatureSpawnEvent creatureSpawnEvent) {
        if (!this.isEnabled() || creatureSpawnEvent.isCancelled()) {
            return;
        }
        if (creatureSpawnEvent.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            LivingEntity livingEntity = creatureSpawnEvent.getEntity();
            livingEntity.setPortalCooldown(630726000);
        }
    }

    private void handleEntityKill(Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double d = livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * ((Config)this.getConfig()).killMaxHealthXPMultiplier;
            if (entity.getPortalCooldown() > 0) {
                d *= ((Config)this.getConfig()).spawnerMobReductionXpMultiplier;
            }
            this.getPlayer(player).getData().addStat("killed.kills", 1.0);
            this.handleCooldownAndXp(player, d);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double turtleEggKillXP = 100.0;
        double creeperKillMultiplier = 2.0;
        double killMaxHealthXPMultiplier = 4.0;
        long cooldownDelay = 1000L;
        double spawnerMobReductionXpMultiplier = 0.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

