/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptStatTracker;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeAutosmelt;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeChisel;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeDropToInventory;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeVeinminer;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillPickaxes
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillPickaxes() {
        super("pickaxe", Localizer.dLocalize("skill", "pickaxe", "icon"));
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("skill", "pickaxe", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "pickaxe", "name"));
        this.setColor(C.GOLD);
        this.setInterval(2750L);
        this.setIcon(Material.NETHERITE_PICKAXE);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new PickaxeChisel());
        this.registerAdaptation(new PickaxeVeinminer());
        this.registerAdaptation(new PickaxeAutosmelt());
        this.registerAdaptation(new PickaxeDropToInventory());
        this.registerAdvancement(AdaptAdvancement.builder().icon(Material.WOODEN_PICKAXE).key("challenge_pickaxe_1k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_1k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_1k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.STONE_PICKAXE).key("challenge_pickaxe_5k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_5k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_5k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.IRON_PICKAXE).key("challenge_pickaxe_50k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_50k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_50k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.DIAMOND_PICKAXE).key("challenge_pickaxe_500k").title(Localizer.dLocalize("advancement", "challenge_pickaxe_500k", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_500k", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).child(AdaptAdvancement.builder().icon(Material.NETHERITE_PICKAXE).key("challenge_pickaxe_5m").title(Localizer.dLocalize("advancement", "challenge_pickaxe_5m", "title")).description(Localizer.dLocalize("advancement", "challenge_pickaxe_5m", "description")).frame(AdvancementDisplay.AdvancementFrame.CHALLENGE).visibility(AdvancementVisibility.PARENT_GRANTED).build()).build()).build()).build()).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_1k").goal(100.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 2.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_5k").goal(500.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 5.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_50k").goal(5000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_500k").goal(50000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 10.0).build());
        this.registerStatTracker(AdaptStatTracker.builder().advancement("challenge_pickaxe_5m").goal(500000.0).stat("pickaxe.blocks.broken").reward(((Config)this.getConfig()).emeraldBonus * 50.0).build());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Player player;
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Player player2 = player = entityDamageByEntityEvent.getDamager() instanceof Player ? (Player)entityDamageByEntityEvent.getDamager() : null;
        if (!((Config)this.getConfig()).getXpForAttackingWithTools) {
            return;
        }
        this.shouldReturnForPlayer(player, () -> {
            if (this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) {
                AdaptPlayer adaptPlayer = this.getPlayer(player);
                ItemStack itemStack = player.getInventory().getItemInMainHand();
                if (this.isPickaxe(itemStack)) {
                    adaptPlayer.getData().addStat("pickaxe.swings", 1.0);
                    adaptPlayer.getData().addStat("pickaxe.damage", entityDamageByEntityEvent.getDamage());
                    this.handleCooldown(player, () -> this.xp(player, entityDamageByEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).damageXPMultiplier * entityDamageByEntityEvent.getDamage()));
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Player player = blockBreakEvent.getPlayer();
        this.shouldReturnForPlayer(player, () -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (this.isPickaxe(itemStack)) {
                Material material = blockBreakEvent.getBlock().getType();
                double d = this.getValue(material);
                AdaptPlayer adaptPlayer = this.getPlayer(player);
                adaptPlayer.getData().addStat("pickaxe.blocks.broken", 1.0);
                adaptPlayer.getData().addStat("pickaxe.blocks.value", d);
                this.handleCooldown(player, () -> {
                    if (itemStack.getEnchantments().containsKey(Enchantment.SILK_TOUCH)) {
                        this.xp(player, 5.0);
                    } else {
                        Location location = blockBreakEvent.getBlock().getLocation().clone().add(0.5, 0.5, 0.5);
                        J.a(() -> this.xp(player, location, this.blockXP(blockBreakEvent.getBlock(), d)));
                    }
                });
            }
        });
    }

    @Override
    public double getValue(Material material) {
        Config config = (Config)this.getConfig();
        double d = super.getValue(material) * config.blockValueMultiplier;
        d += Math.min(config.maxHardnessBonus, (double)material.getHardness());
        d += Math.min(config.maxBlastResistanceBonus, (double)material.getBlastResistance());
        return (d += (switch (material) {
            case Material.COAL_ORE -> config.coalBonus;
            case Material.COPPER_ORE -> config.copperBonus;
            case Material.IRON_ORE -> config.ironBonus;
            case Material.GOLD_ORE -> config.goldBonus;
            case Material.LAPIS_ORE -> config.lapisBonus;
            case Material.DIAMOND_ORE -> config.diamondBonus;
            case Material.EMERALD_ORE -> config.emeraldBonus;
            case Material.NETHER_GOLD_ORE -> config.netherGoldBonus;
            case Material.NETHER_QUARTZ_ORE -> config.netherQuartzBonus;
            case Material.REDSTONE_ORE -> config.redstoneBonus;
            case Material.ANCIENT_DEBRIS -> config.debrisBonus;
            case Material.DEEPSLATE_COAL_ORE -> config.coalBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_COPPER_ORE -> config.copperBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_IRON_ORE -> config.ironBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_GOLD_ORE -> config.goldBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_LAPIS_ORE -> config.lapisBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_DIAMOND_ORE -> config.diamondBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_EMERALD_ORE -> config.emeraldBonus * config.deepslateMultiplier;
            case Material.DEEPSLATE_REDSTONE_ORE -> config.redstoneBonus * config.deepslateMultiplier;
            default -> 0.0;
        })) * 0.48;
    }

    private void handleCooldown(Player player, Runnable runnable) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return;
            }
            this.cooldowns.remove(player);
        }
        this.cooldowns.put(player, System.currentTimeMillis());
        runnable.run();
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public double debrisBonus = 300.0;
        boolean enabled = true;
        boolean getXpForAttackingWithTools = true;
        double damageXPMultiplier = 13.26;
        double blockValueMultiplier = 0.125;
        double maxHardnessBonus = 9.0;
        double maxBlastResistanceBonus = 10.0;
        double coalBonus = 25.0;
        double ironBonus = 40.0;
        double redstoneBonus = 75.0;
        double copperBonus = 30.0;
        double goldBonus = 50.0;
        double lapisBonus = 105.0;
        long cooldownDelay = 1250L;
        double diamondBonus = 250.0;
        double emeraldBonus = 300.0;
        double netherGoldBonus = 150.0;
        double netherQuartzBonus = 175.0;
        double deepslateMultiplier = 1.35;

        static {
            IBootstrap.dasBoot();
        }
    }
}

