/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.skill;

import com.volmit.adapt.api.skill.SimpleSkill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.content.adaptation.sword.SwordsBloodyBlade;
import com.volmit.adapt.content.adaptation.sword.SwordsMachete;
import com.volmit.adapt.content.adaptation.sword.SwordsPoisonedBlade;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;

public class SkillSwords
extends SimpleSkill<Config> {
    private final Map<Player, Long> cooldowns;

    public SkillSwords() {
        super("swords", Localizer.dLocalize("skill", "swords", "icon"));
        this.registerConfiguration(Config.class);
        this.setColor(C.YELLOW);
        this.setDescription(Localizer.dLocalize("skill", "swords", "description"));
        this.setDisplayName(Localizer.dLocalize("skill", "swords", "name"));
        this.setInterval(2150L);
        this.setIcon(Material.DIAMOND_SWORD);
        this.cooldowns = new HashMap<Player, Long>();
        this.registerAdaptation(new SwordsMachete());
        this.registerAdaptation(new SwordsPoisonedBlade());
        this.registerAdaptation(new SwordsBloodyBlade());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.checkValidEntity(entityDamageByEntityEvent.getEntity().getType())) {
                this.shouldReturnForPlayer(player, (Cancellable)entityDamageByEntityEvent, () -> {
                    AdaptPlayer adaptPlayer = this.getPlayer(player);
                    ItemStack itemStack = adaptPlayer.getPlayer().getInventory().getItemInMainHand();
                    if (this.isSword(itemStack)) {
                        this.getPlayer(player).getData().addStat("sword.hits", 1.0);
                        this.getPlayer(player).getData().addStat("sword.damage", entityDamageByEntityEvent.getDamage());
                        if (!this.isOnCooldown(player)) {
                            this.setCooldown(player);
                            this.xp(adaptPlayer.getPlayer(), entityDamageByEntityEvent.getEntity().getLocation(), ((Config)this.getConfig()).damageXPMultiplier * entityDamageByEntityEvent.getDamage());
                        }
                    }
                });
            }
        }
    }

    private boolean isOnCooldown(Player player) {
        if (this.cooldowns.containsKey(player)) {
            if (this.cooldowns.get(player) + ((Config)this.getConfig()).cooldownDelay > System.currentTimeMillis()) {
                return true;
            }
            this.cooldowns.remove(player);
        }
        return false;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player, System.currentTimeMillis());
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean enabled = true;
        long cooldownDelay = 1250L;
        double damageXPMultiplier = 7.26;

        static {
            IBootstrap.dasBoot();
        }
    }
}

