/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.NibbleArray;
import com.volmit.adapt.util.Writable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class DataPalette<T>
implements Writable {
    private static final int DEFAULT_BITS_PER_BLOCK = 4;
    private static final int CAPACITY = 4096;
    private int bpb = 4;
    private NibbleArray data;
    private List<T> palette = new ArrayList<T>();

    public DataPalette(T t) {
        this.data = new NibbleArray(this.bpb, 4096);
        this.data.setAll((byte)-128);
        this.getPaletteId(t);
    }

    public abstract T readType(DataInputStream var1);

    public abstract void writeType(T var1, DataOutputStream var2);

    @Override
    public void write(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.bpb + -128);
        dataOutputStream.writeByte(this.palette.size() + -128);
        for (T t : this.palette) {
            this.writeType(t, dataOutputStream);
        }
        this.data.write(dataOutputStream);
    }

    @Override
    public void read(DataInputStream dataInputStream) {
        this.bpb = dataInputStream.readByte() - -128;
        this.palette = new ArrayList<T>();
        int n = dataInputStream.readByte() - -128;
        for (int i = 0; i < n; ++i) {
            this.palette.add(this.readType(dataInputStream));
        }
        this.data = new NibbleArray(4096, dataInputStream);
    }

    private final void expand() {
        if (this.bpb >= 8) {
            throw new IndexOutOfBoundsException("The Data Palette can only handle at most 256 block types per 16x16x16 region. We cannot use more than 8 bits per block!");
        }
        this.changeBitsPerBlock(this.bpb + 1);
    }

    public final void optimize() {
        int n = this.bpb;
        int n2 = this.palette.size();
        for (int i = 1; i < this.bpb; ++i) {
            if (!(Math.pow(2.0, i) > (double)n2)) continue;
            n = i;
            break;
        }
        this.changeBitsPerBlock(n);
    }

    private final void changeBitsPerBlock(int n) {
        this.bpb = n;
        this.data = new NibbleArray(this.bpb, 4096, this.data);
    }

    public final void set(int n, int n2, int n3, T t) {
        this.data.set(this.getCoordinateIndex(n, n2, n3), this.getPaletteId(t));
    }

    public final T get(int n, int n2, int n3) {
        return this.palette.get(this.data.get(this.getCoordinateIndex(n, n2, n3)));
    }

    private final int getPaletteId(T t) {
        int n = this.palette.indexOf(t);
        if (n == -1) {
            n = this.palette.size();
            this.palette.add(t);
            if ((double)this.palette.size() > Math.pow(2.0, this.bpb)) {
                this.expand();
            }
        }
        return n + -128;
    }

    private final int getCoordinateIndex(int n, int n2, int n3) {
        return n2 << 8 | n3 << 4 | n;
    }

    static {
        IBootstrap.dasBoot();
    }
}

