/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.MaterialBlock;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class Items {
    public static boolean is(ItemStack itemStack) {
        return itemStack != null && !itemStack.getType().equals((Object)Material.AIR);
    }

    public static boolean is(ItemStack itemStack, Material material) {
        return Items.is(itemStack) && itemStack.getType().equals((Object)material);
    }

    public static boolean is(ItemStack itemStack, MaterialBlock materialBlock) {
        return Items.is(itemStack, materialBlock.getMaterial()) && itemStack.getData().getData() == materialBlock.getData().byteValue();
    }

    public static boolean is(ItemStack itemStack, Material material, byte by) {
        return Items.is(itemStack, new MaterialBlock(material, by));
    }

    public static boolean is(ItemStack itemStack, Material material, int n) {
        return Items.is(itemStack, material, (byte)n);
    }

    public static boolean hasMeta(ItemStack itemStack) {
        return Items.is(itemStack) && itemStack.hasItemMeta();
    }

    public static boolean hasName(ItemStack itemStack) {
        return Items.hasMeta(itemStack) && itemStack.getItemMeta().hasDisplayName();
    }

    public static boolean hasLore(ItemStack itemStack) {
        return Items.hasMeta(itemStack) && itemStack.getItemMeta().hasLore();
    }

    public static boolean hasName(ItemStack itemStack, String string) {
        return Items.hasName(itemStack) && itemStack.getItemMeta().getDisplayName().equals(string);
    }

    public static boolean hasEnchantment(ItemStack itemStack, Enchantment enchantment) {
        return Items.is(itemStack) && itemStack.getEnchantments().containsKey(enchantment);
    }

    public static boolean hasEnchantment(ItemStack itemStack, Enchantment enchantment, int n) {
        if (!Items.is(itemStack)) {
            return false;
        }
        return Items.hasEnchantment(itemStack, enchantment) && itemStack.getEnchantmentLevel(enchantment) == n;
    }

    public static boolean hasEnchantments(ItemStack itemStack) {
        if (!Items.is(itemStack)) {
            return false;
        }
        return !itemStack.getEnchantments().isEmpty();
    }

    public static MaterialBlock toMaterialBlock(ItemStack itemStack) {
        if (itemStack != null) {
            return new MaterialBlock(itemStack.getType(), itemStack.getData().getData());
        }
        return null;
    }

    public static boolean isBroken(ItemStack itemStack) {
        return Items.is(itemStack) && Items.getMaxDurability(itemStack) == Items.getDurability(itemStack) && Items.hasDurability(itemStack);
    }

    public static boolean hasDurability(ItemStack itemStack) {
        return Items.is(itemStack) && Items.getMaxDurability(itemStack) > 0;
    }

    public static double getDurabilityPercent(ItemStack itemStack) {
        if (!Items.is(itemStack)) {
            return 0.0;
        }
        if (Items.getMaxDurability(itemStack) == 0) {
            return 1.0;
        }
        return 1.0 - (double)Items.getDurability(itemStack) / (double)Items.getMaxDurability(itemStack);
    }

    public static void setDurabilityPercent(ItemStack itemStack, double d) {
        if (!Items.is(itemStack)) {
            return;
        }
        double d2 = d > 1.0 ? 1.0 : (d = d < 0.0 ? 0.0 : d);
        if (Items.getDurability(itemStack) == 0) {
            return;
        }
        Items.setDurability(itemStack, (int)((double)Items.getMaxDurability(itemStack) * (1.0 - d)));
    }

    public static short getMaxDurability(ItemStack itemStack) {
        if (!Items.is(itemStack)) {
            return 0;
        }
        return itemStack.getType().getMaxDurability();
    }

    public static short getDurability(ItemStack itemStack) {
        if (!Items.is(itemStack)) {
            return 0;
        }
        return itemStack.getDurability();
    }

    public static void setDurability(ItemStack itemStack, short s) {
        if (!Items.is(itemStack)) {
            return;
        }
        itemStack.setDurability(s > Items.getMaxDurability(itemStack) ? Items.getMaxDurability(itemStack) : s);
    }

    public static void setDurability(ItemStack itemStack, int n) {
        if (!Items.is(itemStack)) {
            return;
        }
        Items.setDurability(itemStack, (short)n);
    }

    public static void damage(ItemStack itemStack, int n) {
        if (!Items.is(itemStack)) {
            return;
        }
        Items.setDurability(itemStack, Items.getDurability(itemStack) + n);
    }

    public static boolean isMergable(ItemStack itemStack, ItemStack itemStack2) {
        if (Items.is(itemStack) && Items.is(itemStack2)) {
            if (!itemStack.getType().equals((Object)itemStack2.getType())) {
                return false;
            }
            if (itemStack.getData().getData() != itemStack2.getData().getData()) {
                return false;
            }
            if (itemStack.hasItemMeta() != itemStack2.hasItemMeta()) {
                return false;
            }
            if (itemStack.getDurability() != itemStack2.getDurability()) {
                return false;
            }
            if (itemStack.hasItemMeta()) {
                if (!itemStack.getItemMeta().getDisplayName().equals(itemStack2.getItemMeta().getDisplayName())) {
                    return false;
                }
                if (!new ArrayList(itemStack.getItemMeta().getLore()).equals(new ArrayList(itemStack2.getItemMeta().getLore()))) {
                    return false;
                }
            }
            return itemStack.getMaxStackSize() >= itemStack.getAmount() + itemStack2.getAmount();
        }
        return false;
    }

    static {
        IBootstrap.dasBoot();
    }
}

