/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.NBTUtils;
import com.volmit.adapt.util.Tag;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collections;
import java.util.List;

public final class ListTag
extends Tag {
    private final Class<? extends Tag> type;
    private final List<Tag> value;

    public ListTag(String string, Class<? extends Tag> clazz, List<Tag> list) {
        super(string);
        this.type = clazz;
        this.value = Collections.unmodifiableList(list);
    }

    public Class<? extends Tag> getType() {
        return this.type;
    }

    @Override
    public List<Tag> getValue() {
        return this.value;
    }

    public String toString() {
        String string = this.getName();
        Object object = "";
        if (string != null && !string.equals("")) {
            object = "(\"" + this.getName() + "\")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TAG_List" + (String)object + ": " + this.value.size() + " entries of type " + NBTUtils.getTypeName(this.type) + "\r\n{\r\n");
        for (Tag tag : this.value) {
            stringBuilder.append("   " + tag.toString().replaceAll("\r\n", "\r\n   ") + "\r\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static {
        IBootstrap.dasBoot();
    }
}

