/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.ByteArrayTag;
import com.volmit.adapt.util.ByteTag;
import com.volmit.adapt.util.CompoundTag;
import com.volmit.adapt.util.DoubleTag;
import com.volmit.adapt.util.EndTag;
import com.volmit.adapt.util.FloatTag;
import com.volmit.adapt.util.IntArrayTag;
import com.volmit.adapt.util.IntTag;
import com.volmit.adapt.util.ListTag;
import com.volmit.adapt.util.LongTag;
import com.volmit.adapt.util.NBTConstants;
import com.volmit.adapt.util.NBTUtils;
import com.volmit.adapt.util.ShortTag;
import com.volmit.adapt.util.StringTag;
import com.volmit.adapt.util.Tag;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class NBTOutputStream
implements Closeable {
    private final DataOutputStream os;

    public NBTOutputStream(DataOutputStream dataOutputStream) {
        this.os = dataOutputStream;
    }

    public NBTOutputStream(OutputStream outputStream) {
        this.os = new DataOutputStream(new GZIPOutputStream(outputStream));
    }

    public void writeTag(Tag tag) {
        int n = NBTUtils.getTypeCode(tag.getClass());
        String string = tag.getName();
        byte[] byArray = string.getBytes(NBTConstants.CHARSET);
        this.os.writeByte(n);
        this.os.writeShort(byArray.length);
        this.os.write(byArray);
        if (n == 0) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTagPayload(tag);
    }

    private void writeTagPayload(Tag tag) {
        int n = NBTUtils.getTypeCode(tag.getClass());
        switch (n) {
            case 0: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case 1: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case 2: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case 3: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case 4: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case 5: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case 6: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case 7: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case 8: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case 9: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case 10: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            case 11: {
                this.writeIntArrayTagPayload((IntArrayTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + n + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag byteTag) {
        this.os.writeByte(byteTag.getValue().byteValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag byteArrayTag) {
        byte[] byArray = byteArrayTag.getValue();
        this.os.writeInt(byArray.length);
        this.os.write(byArray);
    }

    private void writeCompoundTagPayload(CompoundTag compoundTag) {
        for (Tag tag : compoundTag.getValue().values()) {
            this.writeTag(tag);
        }
        this.os.writeByte(0);
    }

    private void writeListTagPayload(ListTag listTag) {
        Class<? extends Tag> clazz = listTag.getType();
        Object object = listTag.getValue();
        int n = object.size();
        this.os.writeByte(NBTUtils.getTypeCode(clazz));
        this.os.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeTagPayload((Tag)object.get(i));
        }
    }

    private void writeStringTagPayload(StringTag stringTag) {
        byte[] byArray = stringTag.getValue().getBytes(NBTConstants.CHARSET);
        this.os.writeShort(byArray.length);
        this.os.write(byArray);
    }

    private void writeDoubleTagPayload(DoubleTag doubleTag) {
        this.os.writeDouble(doubleTag.getValue());
    }

    private void writeFloatTagPayload(FloatTag floatTag) {
        this.os.writeFloat(floatTag.getValue().floatValue());
    }

    private void writeLongTagPayload(LongTag longTag) {
        this.os.writeLong(longTag.getValue());
    }

    private void writeIntTagPayload(IntTag intTag) {
        this.os.writeInt(intTag.getValue());
    }

    private void writeShortTagPayload(ShortTag shortTag) {
        this.os.writeShort(shortTag.getValue().shortValue());
    }

    private void writeEndTagPayload(EndTag endTag) {
    }

    private void writeIntArrayTagPayload(IntArrayTag intArrayTag) {
        int[] nArray = intArrayTag.getValue();
        this.os.writeInt(nArray.length);
        for (int n : nArray) {
            this.os.writeInt(n);
        }
    }

    @Override
    public void close() {
        this.os.close();
    }

    static {
        IBootstrap.dasBoot();
    }
}

