/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;

public enum NMSVersion {
    R1_16,
    R1_15,
    R1_14,
    R1_13,
    R1_13_1,
    R1_12,
    R1_11,
    R1_10,
    R1_9_4,
    R1_9_2,
    R1_8;


    public static NMSVersion getMinimum() {
        return NMSVersion.values()[NMSVersion.values().length - 1];
    }

    public static NMSVersion getMaximum() {
        return NMSVersion.values()[0];
    }

    public static NMSVersion current() {
        if (NMSVersion.tryVersion("1_8_R3")) {
            return R1_8;
        }
        if (NMSVersion.tryVersion("1_9_R1")) {
            return R1_9_2;
        }
        if (NMSVersion.tryVersion("1_9_R2")) {
            return R1_9_4;
        }
        if (NMSVersion.tryVersion("1_10_R1")) {
            return R1_10;
        }
        if (NMSVersion.tryVersion("1_11_R1")) {
            return R1_11;
        }
        if (NMSVersion.tryVersion("1_12_R1")) {
            return R1_12;
        }
        if (NMSVersion.tryVersion("1_13_R1")) {
            return R1_13;
        }
        if (NMSVersion.tryVersion("1_13_R2")) {
            return R1_13_1;
        }
        if (NMSVersion.tryVersion("1_14_R1")) {
            return R1_14;
        }
        if (NMSVersion.tryVersion("1_15_R1")) {
            return R1_15;
        }
        if (NMSVersion.tryVersion("1_16_R1")) {
            return R1_16;
        }
        return null;
    }

    private static boolean tryVersion(String string) {
        try {
            Class.forName("org.bukkit.craftbukkit.v" + string + ".CraftWorld");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public List<NMSVersion> getAboveInclusive() {
        ArrayList<NMSVersion> arrayList = new ArrayList<NMSVersion>();
        for (NMSVersion nMSVersion : NMSVersion.values()) {
            if (nMSVersion.ordinal() < this.ordinal()) continue;
            arrayList.add(nMSVersion);
        }
        return arrayList;
    }

    public List<NMSVersion> betweenInclusive(NMSVersion nMSVersion) {
        ArrayList<NMSVersion> arrayList = new ArrayList<NMSVersion>();
        for (NMSVersion nMSVersion2 : NMSVersion.values()) {
            if (nMSVersion2.ordinal() > Math.max(nMSVersion.ordinal(), this.ordinal()) || nMSVersion2.ordinal() < Math.min(this.ordinal(), nMSVersion.ordinal())) continue;
            arrayList.add(nMSVersion2);
        }
        return arrayList;
    }

    public List<NMSVersion> getBelowInclusive() {
        ArrayList<NMSVersion> arrayList = new ArrayList<NMSVersion>();
        for (NMSVersion nMSVersion : NMSVersion.values()) {
            if (nMSVersion.ordinal() > this.ordinal()) continue;
            arrayList.add(nMSVersion);
        }
        return arrayList;
    }

    static {
        IBootstrap.dasBoot();
    }
}

