/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.Writable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.StringJoiner;

public class NibbleArray
implements Writable {
    private static final int[] MASKS;
    private final int size;
    private final Object lock = new Object();
    private byte[] data;
    private int depth;
    private byte mask;
    private transient int bitIndex;
    private transient int byteIndex;
    private transient int bitInByte;

    public NibbleArray(int n, DataInputStream dataInputStream) {
        this.size = n;
        this.read(dataInputStream);
    }

    public NibbleArray(int n, int n2) {
        if (n > 8 || n < 1) {
            throw new IllegalArgumentException();
        }
        int n3 = n * n2;
        this.size = n2;
        this.depth = n;
        this.data = new byte[(n3 + n3 % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(n);
    }

    public NibbleArray(int n, int n2, NibbleArray nibbleArray) {
        if (n > 8 || n < 1) {
            throw new IllegalArgumentException();
        }
        int n3 = n * n2;
        this.size = n2;
        this.depth = n;
        this.data = new byte[(n3 + n3 % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(n);
        for (int i = 0; i < Math.min(this.size, nibbleArray.size()); ++i) {
            this.set(i, nibbleArray.get(i));
        }
    }

    public static int maskFor(int n) {
        return NibbleArray.powerOfTwo(n) - 1;
    }

    public static int powerOfTwo(int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 2;
        }
        return n2;
    }

    public static String binaryString(byte by, ByteOrder byteOrder) {
        String string = String.format("%8s", Integer.toBinaryString(by & 0xFF)).replace(' ', '0');
        return byteOrder.equals(ByteOrder.BIG_ENDIAN) ? string : NibbleArray.reverse(string);
    }

    public static String reverse(String string) {
        return new StringBuilder(string).reverse().toString();
    }

    @Override
    public void write(DataOutputStream dataOutputStream) {
        dataOutputStream.writeByte(this.depth + -128);
        dataOutputStream.write(this.data);
    }

    @Override
    public void read(DataInputStream dataInputStream) {
        this.depth = dataInputStream.readByte() - -128;
        int n = this.depth * this.size;
        this.data = new byte[(n + n % 8) / 8];
        this.mask = (byte)NibbleArray.maskFor(this.depth);
        dataInputStream.read(this.data);
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.bitIndex = n * this.depth;
            this.byteIndex = this.bitIndex >> 3;
            this.bitInByte = this.bitIndex & 7;
            int n2 = this.data[this.byteIndex] >> this.bitInByte;
            if (this.bitInByte + this.depth > 8) {
                n2 |= this.data[this.byteIndex + 1] << this.bitInByte;
            }
            return (byte)(n2 & this.mask);
        }
    }

    public byte getAsync(int n) {
        int n2 = n * this.depth;
        int n3 = n2 >> 3;
        int n4 = n2 & 7;
        int n5 = this.data[n3] >> n4;
        if (n4 + this.depth > 8) {
            n5 |= this.data[n3 + 1] << n4;
        }
        return (byte)(n5 & this.mask);
    }

    public void set(int n, int n2) {
        this.set(n, (byte)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int n, byte by) {
        Object object = this.lock;
        synchronized (object) {
            this.bitIndex = n * this.depth;
            this.byteIndex = this.bitIndex >> 3;
            this.bitInByte = this.bitIndex & 7;
            this.data[this.byteIndex] = (byte)((~(this.data[this.byteIndex] & this.mask << this.bitInByte) & this.data[this.byteIndex] | (by & this.mask) << this.bitInByte) & 0xFF);
            if (this.bitInByte + this.depth > 8) {
                this.data[this.byteIndex + 1] = (byte)((~(this.data[this.byteIndex + 1] & MASKS[this.bitInByte + this.depth - 8]) & this.data[this.byteIndex + 1] | (by & this.mask) >> 8 - this.bitInByte) & 0xFF);
            }
        }
    }

    public String toBitsString() {
        return this.toBitsString(ByteOrder.BIG_ENDIAN);
    }

    public String toBitsString(ByteOrder byteOrder) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (int i = 0; i < this.data.length; ++i) {
            stringJoiner.add(NibbleArray.binaryString(this.data[i], byteOrder));
        }
        return stringJoiner.toString();
    }

    public void clear() {
        Arrays.fill(this.data, (byte)0);
    }

    public void setAll(byte by) {
        for (int i = 0; i < this.size; ++i) {
            this.set(i, by);
        }
    }

    public void setAll(int n) {
        for (int i = 0; i < this.size; ++i) {
            this.set(i, (byte)n);
        }
    }

    static {
        IBootstrap.dasBoot();
        MASKS = new int[8];
        for (int i = 0; i < MASKS.length; ++i) {
            NibbleArray.MASKS[i] = NibbleArray.maskFor(i);
        }
    }
}

