/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.NastyRunnable;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class TaskExecutor {
    private final ExecutorService service;
    private int xc = 1;

    public TaskExecutor(int n, final int n2, final String string) {
        if (n == 1) {
            this.service = Executors.newSingleThreadExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName(string);
                thread.setPriority(n2);
                return thread;
            });
        } else if (n > 1) {
            ForkJoinPool.ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

                @Override
                public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
                    ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(forkJoinPool);
                    forkJoinWorkerThread.setName(string + " " + TaskExecutor.this.xc++);
                    forkJoinWorkerThread.setPriority(n2);
                    return forkJoinWorkerThread;
                }
            };
            this.service = new ForkJoinPool(n, forkJoinWorkerThreadFactory, null, false);
        } else {
            this.service = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName(string + " " + this.xc++);
                thread.setPriority(n2);
                return thread;
            });
        }
    }

    public TaskGroup startWork() {
        return new TaskGroup(this);
    }

    public void close() {
        J.a(() -> {
            J.sleep(10000L);
            this.service.shutdown();
        });
    }

    public void closeNow() {
        this.service.shutdown();
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class TaskGroup {
        private final List<AssignedTask> tasks = new ArrayList<AssignedTask>();
        private final TaskExecutor e;

        public TaskGroup(TaskExecutor taskExecutor) {
            this.e = taskExecutor;
        }

        public TaskGroup queue(NastyRunnable ... nastyRunnableArray) {
            for (NastyRunnable nastyRunnable : nastyRunnableArray) {
                this.tasks.add(new AssignedTask(nastyRunnable));
            }
            return this;
        }

        public TaskGroup queue(List<NastyRunnable> list) {
            for (NastyRunnable nastyRunnable : list) {
                this.tasks.add(new AssignedTask(nastyRunnable));
            }
            return this;
        }

        public TaskResult execute() {
            double d = 0.0;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            this.tasks.forEach(assignedTask -> assignedTask.go(this.e));
            long l = M.ns();
            block2: while (true) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    Adapt.verbose("Interrupted while waiting for tasks to complete");
                }
                for (AssignedTask assignedTask2 : this.tasks) {
                    if (!assignedTask2.state.equals((Object)TaskState.QUEUED) && !assignedTask2.state.equals((Object)TaskState.RUNNING)) continue;
                    continue block2;
                }
                break;
            }
            d = (double)(M.ns() - l) / 1000000.0;
            for (AssignedTask assignedTask2 : this.tasks) {
                if (assignedTask2.state.equals((Object)TaskState.COMPLETED)) {
                    ++n3;
                } else {
                    ++n2;
                }
                ++n;
            }
            return new TaskResult(d, n, n2, n3);
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class AssignedTask {
        private final NastyRunnable task;
        private TaskState state;

        public AssignedTask(NastyRunnable nastyRunnable) {
            this.task = nastyRunnable;
            this.state = TaskState.QUEUED;
        }

        public void go(TaskExecutor taskExecutor) {
            taskExecutor.service.execute(() -> {
                this.state = TaskState.RUNNING;
                try {
                    this.task.run();
                    this.state = TaskState.COMPLETED;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.state = TaskState.FAILED;
                }
            });
        }

        public NastyRunnable getTask() {
            return this.task;
        }

        public TaskState getState() {
            return this.state;
        }

        public void setState(TaskState taskState) {
            this.state = taskState;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static class TaskResult {
        public final double timeElapsed;
        public final int tasksExecuted;
        public final int tasksFailed;
        public final int tasksCompleted;

        public TaskResult(double d, int n, int n2, int n3) {
            this.timeElapsed = d;
            this.tasksExecuted = n;
            this.tasksFailed = n2;
            this.tasksCompleted = n3;
        }

        public String toString() {
            return "TaskExecutor.TaskResult(timeElapsed=" + this.timeElapsed + ", tasksExecuted=" + this.tasksExecuted + ", tasksFailed=" + this.tasksFailed + ", tasksCompleted=" + this.tasksCompleted + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public static enum TaskState {
        QUEUED,
        RUNNING,
        COMPLETED,
        FAILED;


        static {
            IBootstrap.dasBoot();
        }
    }
}

