/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util;

import com.volmit.adapt.util.CDou;
import com.volmit.adapt.util.Direction;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.GListAdapter;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class VectorMath {
    public static Vector scaleStatic(Axis axis, Vector vector, double d) {
        switch (axis) {
            case X: {
                return VectorMath.scaleX(vector, d);
            }
            case Y: {
                return VectorMath.scaleY(vector, d);
            }
            case Z: {
                return VectorMath.scaleZ(vector, d);
            }
        }
        return null;
    }

    public static Vector scaleX(Vector vector, double d) {
        double d2 = vector.getX();
        double d3 = vector.getY();
        double d4 = vector.getZ();
        double d5 = d2 == 0.0 ? 1.0 : d / d2;
        return new Vector(d2 * d5, d3 * d5, d4 * d5);
    }

    public static Vector scaleY(Vector vector, double d) {
        double d2 = vector.getX();
        double d3 = vector.getY();
        double d4 = vector.getZ();
        double d5 = d3 == 0.0 ? 1.0 : d / d3;
        return new Vector(d2 * d5, d3 * d5, d4 * d5);
    }

    public static Vector scaleZ(Vector vector, double d) {
        double d2 = vector.getX();
        double d3 = vector.getY();
        double d4 = vector.getZ();
        double d5 = d4 == 0.0 ? 1.0 : d / d4;
        return new Vector(d2 * d5, d3 * d5, d4 * d5);
    }

    public static Vector reverseXZ(Vector vector) {
        vector.setX(-vector.getX());
        vector.setZ(-vector.getZ());
        return vector;
    }

    public static boolean isLookingNear(Location location, Location location2, double d) {
        Vector vector;
        Vector vector2 = VectorMath.direction(location, location2);
        return vector2.distance(vector = location.getDirection()) <= d;
    }

    public static Vector rotate(Direction direction, Direction direction2, Vector vector) {
        if (direction.equals((Object)direction2)) {
            return vector;
        }
        if (direction.equals((Object)direction2.reverse())) {
            if (direction.isVertical()) {
                return new Vector(vector.getX(), -vector.getY(), vector.getZ());
            }
            return new Vector(-vector.getX(), vector.getY(), -vector.getZ());
        }
        Vector vector2 = direction.toVector().clone().add(direction2.toVector());
        if (vector2.getX() == 0.0) {
            if (vector2.getY() != vector2.getZ()) {
                return VectorMath.rotate90CX(vector);
            }
            return VectorMath.rotate90CCX(vector);
        }
        if (vector2.getY() == 0.0) {
            if (vector2.getX() != vector2.getZ()) {
                return VectorMath.rotate90CY(vector);
            }
            return VectorMath.rotate90CCY(vector);
        }
        if (vector2.getZ() == 0.0) {
            if (vector2.getX() != vector2.getY()) {
                return VectorMath.rotate90CZ(vector);
            }
            return VectorMath.rotate90CCZ(vector);
        }
        return vector;
    }

    public static Vector rotate(Direction direction, Direction direction2, Vector vector, int n, int n2, int n3) {
        if (direction.equals((Object)direction2)) {
            return vector;
        }
        if (direction.equals((Object)direction2.reverse())) {
            if (direction.isVertical()) {
                return new Vector(vector.getX(), -vector.getY() + (double)n2, vector.getZ());
            }
            return new Vector(-vector.getX() + (double)n, vector.getY(), -vector.getZ() + (double)n3);
        }
        Vector vector2 = direction.toVector().clone().add(direction2.toVector());
        if (vector2.getX() == 0.0) {
            if (vector2.getY() != vector2.getZ()) {
                return VectorMath.rotate90CX(vector, n3);
            }
            return VectorMath.rotate90CCX(vector, n2);
        }
        if (vector2.getY() == 0.0) {
            if (vector2.getX() != vector2.getZ()) {
                return VectorMath.rotate90CY(vector, n3);
            }
            return VectorMath.rotate90CCY(vector, n);
        }
        if (vector2.getZ() == 0.0) {
            if (vector2.getX() != vector2.getY()) {
                return VectorMath.rotate90CZ(vector, n);
            }
            return VectorMath.rotate90CCZ(vector, n2);
        }
        return vector;
    }

    public static Vector rotate90CX(Vector vector) {
        return new Vector(vector.getX(), -vector.getZ(), vector.getY());
    }

    public static Vector rotate90CCX(Vector vector) {
        return new Vector(vector.getX(), vector.getZ(), -vector.getY());
    }

    public static Vector rotate90CY(Vector vector) {
        return new Vector(-vector.getZ(), vector.getY(), vector.getX());
    }

    public static Vector rotate90CCY(Vector vector) {
        return new Vector(vector.getZ(), vector.getY(), -vector.getX());
    }

    public static Vector rotate90CZ(Vector vector) {
        return new Vector(vector.getY(), -vector.getX(), vector.getZ());
    }

    public static Vector rotate90CCZ(Vector vector) {
        return new Vector(-vector.getY(), vector.getX(), vector.getZ());
    }

    public static Vector rotate90CX(Vector vector, int n) {
        return new Vector(vector.getX(), -vector.getZ() + (double)n, vector.getY());
    }

    public static Vector rotate90CCX(Vector vector, int n) {
        return new Vector(vector.getX(), vector.getZ(), -vector.getY() + (double)n);
    }

    public static Vector rotate90CY(Vector vector, int n) {
        return new Vector(-vector.getZ() + (double)n, vector.getY(), vector.getX());
    }

    public static Vector rotate90CCY(Vector vector, int n) {
        return new Vector(vector.getZ(), vector.getY(), -vector.getX() + (double)n);
    }

    public static Vector rotate90CZ(Vector vector, int n) {
        return new Vector(vector.getY(), -vector.getX() + (double)n, vector.getZ());
    }

    public static Vector rotate90CCZ(Vector vector, int n) {
        return new Vector(-vector.getY() + (double)n, vector.getX(), vector.getZ());
    }

    public static Vector getAxis(Direction direction, Direction direction2) {
        if (direction.equals((Object)Direction.U) || direction.equals((Object)Direction.D)) {
            if (direction2.equals((Object)Direction.U) || direction2.equals((Object)Direction.D)) {
                return new Vector(1, 0, 0);
            }
            if (direction.equals((Object)Direction.N) || direction.equals((Object)Direction.S)) {
                return Direction.E.toVector();
            }
            return Direction.S.toVector();
        }
        return new Vector(0, 1, 0);
    }

    private static double round(double d, int n) {
        return Double.valueOf(Form.f(d, n));
    }

    public static Vector clip(Vector vector, int n) {
        vector.setX(VectorMath.round(vector.getX(), n));
        vector.setY(VectorMath.round(vector.getY(), n));
        vector.setZ(VectorMath.round(vector.getZ(), n));
        return vector;
    }

    public static Vector rotateVectorCC(Vector vector, Vector vector2, double d) {
        double d2 = Math.toRadians(d);
        double d3 = vector.getX();
        double d4 = vector.getY();
        double d5 = vector.getZ();
        double d6 = vector2.getX();
        double d7 = vector2.getY();
        double d8 = vector2.getZ();
        double d9 = d6 * (d6 * d3 + d7 * d4 + d8 * d5) * (1.0 - Math.cos(d2)) + d3 * Math.cos(d2) + (-d8 * d4 + d7 * d5) * Math.sin(d2);
        double d10 = d7 * (d6 * d3 + d7 * d4 + d8 * d5) * (1.0 - Math.cos(d2)) + d4 * Math.cos(d2) + (d8 * d3 - d6 * d5) * Math.sin(d2);
        double d11 = d8 * (d6 * d3 + d7 * d4 + d8 * d5) * (1.0 - Math.cos(d2)) + d5 * Math.cos(d2) + (-d7 * d3 + d6 * d4) * Math.sin(d2);
        return VectorMath.clip(new Vector(d9, d10, d11), 4);
    }

    public static List<BlockFace> split(BlockFace blockFace) {
        ArrayList<BlockFace> arrayList = new ArrayList<BlockFace>();
        switch (blockFace) {
            case DOWN: {
                arrayList.add(BlockFace.DOWN);
                break;
            }
            case EAST: {
                arrayList.add(BlockFace.EAST);
                break;
            }
            case EAST_NORTH_EAST: {
                arrayList.add(BlockFace.EAST);
                arrayList.add(BlockFace.EAST);
                arrayList.add(BlockFace.NORTH);
                break;
            }
            case EAST_SOUTH_EAST: {
                arrayList.add(BlockFace.EAST);
                arrayList.add(BlockFace.EAST);
                arrayList.add(BlockFace.SOUTH);
                break;
            }
            case NORTH: {
                arrayList.add(BlockFace.NORTH);
                break;
            }
            case NORTH_EAST: {
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.EAST);
                break;
            }
            case NORTH_NORTH_EAST: {
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.EAST);
                break;
            }
            case NORTH_NORTH_WEST: {
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.WEST);
                break;
            }
            case NORTH_WEST: {
                arrayList.add(BlockFace.NORTH);
                arrayList.add(BlockFace.WEST);
                break;
            }
            case SELF: {
                arrayList.add(BlockFace.SELF);
                break;
            }
            case SOUTH: {
                arrayList.add(BlockFace.SOUTH);
                break;
            }
            case SOUTH_EAST: {
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.EAST);
                break;
            }
            case SOUTH_SOUTH_EAST: {
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.EAST);
                break;
            }
            case SOUTH_SOUTH_WEST: {
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.WEST);
                break;
            }
            case SOUTH_WEST: {
                arrayList.add(BlockFace.SOUTH);
                arrayList.add(BlockFace.WEST);
                break;
            }
            case UP: {
                arrayList.add(BlockFace.UP);
                break;
            }
            case WEST: {
                arrayList.add(BlockFace.WEST);
                break;
            }
            case WEST_NORTH_WEST: {
                arrayList.add(BlockFace.WEST);
                arrayList.add(BlockFace.WEST);
                arrayList.add(BlockFace.NORTH);
                break;
            }
            case WEST_SOUTH_WEST: {
                arrayList.add(BlockFace.WEST);
                arrayList.add(BlockFace.WEST);
                arrayList.add(BlockFace.SOUTH);
                break;
            }
        }
        return arrayList;
    }

    public static Vector direction(Location location, Location location2) {
        return location2.clone().subtract(location.clone()).toVector().normalize();
    }

    public static Vector directionNoNormal(Location location, Location location2) {
        return location2.clone().subtract(location.clone()).toVector();
    }

    public static Vector toVector(float f, float f2) {
        return new Vector(Math.cos(f2) * Math.cos(f), Math.sin(f2), Math.cos(f2) * Math.sin(-f));
    }

    public static void impulse(Entity entity, Vector vector) {
        VectorMath.impulse(entity, vector, 1.0);
    }

    public static void impulse(Entity entity, Vector vector, double d) {
        Vector vector2 = entity.getVelocity();
        vector2.add(vector.clone().multiply(d));
        entity.setVelocity(vector2);
    }

    public static Vector reverse(Vector vector) {
        if (vector.getX() != 0.0) {
            vector.setX(-vector.getX());
        }
        if (vector.getY() != 0.0) {
            vector.setY(-vector.getY());
        }
        if (vector.getZ() != 0.0) {
            vector.setZ(-vector.getZ());
        }
        return vector;
    }

    public static double getSpeed(Vector vector) {
        Vector vector2 = new Vector(0, 0, 0);
        Vector vector3 = new Vector(0, 0, 0).add(vector);
        return vector2.distance(vector3);
    }

    public static List<Vector> shift(final Vector vector, List<Vector> list) {
        return new ArrayList<Vector>(new GListAdapter<Vector, Vector>(){

            @Override
            public Vector onAdapt(Vector vector2) {
                return vector2.add(vector);
            }
        }.adapt(list));
    }

    public static BlockFace getBlockFace(Vector vector) {
        Vector vector2 = VectorMath.triNormalize(vector);
        for (BlockFace blockFace : BlockFace.values()) {
            if (vector2.getX() != (double)blockFace.getModX() || vector2.getY() != (double)blockFace.getModY() || vector2.getZ() != (double)blockFace.getModZ()) continue;
            return blockFace;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            if (vector2.getX() != (double)blockFace.getModX() || vector2.getZ() != (double)blockFace.getModZ()) continue;
            return blockFace;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            if (vector2.getY() != (double)blockFace.getModY() || vector2.getZ() != (double)blockFace.getModZ()) continue;
            return blockFace;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            if (vector2.getX() != (double)blockFace.getModX() && vector2.getY() != (double)blockFace.getModY()) continue;
            return blockFace;
        }
        for (BlockFace blockFace : BlockFace.values()) {
            if (vector2.getX() != (double)blockFace.getModX() && vector2.getY() != (double)blockFace.getModY() && vector2.getZ() != (double)blockFace.getModZ()) continue;
            return blockFace;
        }
        return null;
    }

    public static Vector angleLeft(Vector vector, float f) {
        Location location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        location.setDirection(vector);
        float f2 = location.getYaw();
        float f3 = location.getPitch();
        CDou cDou = new CDou(360.0);
        CDou cDou2 = new CDou(180.0);
        cDou.set(f2);
        cDou2.set(f3);
        cDou.sub(f);
        location.setYaw((float)cDou.get());
        location.setPitch((float)cDou2.get());
        return location.getDirection();
    }

    public static Vector angleRight(Vector vector, float f) {
        Location location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        location.setDirection(vector);
        float f2 = location.getYaw();
        float f3 = location.getPitch();
        CDou cDou = new CDou(360.0);
        CDou cDou2 = new CDou(180.0);
        cDou.set(f2);
        cDou2.set(f3);
        cDou.add(f);
        location.setYaw((float)cDou.get());
        location.setPitch((float)cDou2.get());
        return location.getDirection();
    }

    public static Vector angleUp(Vector vector, float f) {
        Location location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        location.setDirection(vector);
        float f2 = location.getYaw();
        float f3 = location.getPitch();
        CDou cDou = new CDou(360.0);
        cDou.set(f2);
        location.setYaw((float)cDou.get());
        location.setPitch(Math.max(-90.0f, f3 - f));
        return location.getDirection();
    }

    public static Vector angleDown(Vector vector, float f) {
        Location location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0);
        location.setDirection(vector);
        float f2 = location.getYaw();
        float f3 = location.getPitch();
        CDou cDou = new CDou(360.0);
        cDou.set(f2);
        location.setYaw((float)cDou.get());
        location.setPitch(Math.min(90.0f, f3 + f));
        return location.getDirection();
    }

    public static Vector triNormalize(Vector vector) {
        Vector vector2 = vector.clone();
        vector2.normalize();
        if (vector2.getX() > 0.333) {
            vector2.setX(1);
        } else if (vector2.getX() < -0.333) {
            vector2.setX(-1);
        } else {
            vector2.setX(0);
        }
        if (vector2.getY() > 0.333) {
            vector2.setY(1);
        } else if (vector2.getY() < -0.333) {
            vector2.setY(-1);
        } else {
            vector2.setY(0);
        }
        if (vector2.getZ() > 0.333) {
            vector2.setZ(1);
        } else if (vector2.getZ() < -0.333) {
            vector2.setZ(-1);
        } else {
            vector2.setZ(0);
        }
        return vector2;
    }

    static {
        IBootstrap.dasBoot();
    }
}

