/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements;

import com.volmit.adapt.util.advancements.CrazyAdvancementsAPI;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.event.AdvancementScreenCloseEvent;
import com.volmit.adapt.util.advancements.event.AdvancementTabChangeEvent;
import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AdvancementPacketReceiver {
    private static final HashMap<String, ChannelHandler> handlers;
    private static Field channelField;

    public AdvancementPacketReceiver() {
        for (Field field : NetworkManager.class.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Channel.class)) continue;
            channelField = field;
            channelField.setAccessible(true);
            break;
        }
    }

    public ChannelHandler listen(final Player player, final PacketReceivingHandler packetReceivingHandler) {
        Channel channel = this.getNettyChannel(player);
        ChannelPipeline channelPipeline = channel.pipeline();
        MessageToMessageDecoder messageToMessageDecoder = new MessageToMessageDecoder<Packet<?>>(){

            protected void decode(ChannelHandlerContext channelHandlerContext, Packet<?> packet, List<Object> list) {
                if (packet instanceof PacketPlayInAdvancements) {
                    if (!packetReceivingHandler.handle(player, (PacketPlayInAdvancements)packet)) {
                        list.add(packet);
                    }
                    return;
                }
                list.add(packet);
            }
        };
        channelPipeline.addAfter("decoder", "endercentral_crazy_advancements_listener_" + packetReceivingHandler.hashCode(), (ChannelHandler)messageToMessageDecoder);
        return messageToMessageDecoder;
    }

    public Channel getNettyChannel(Player player) {
        NetworkManager networkManager = (NetworkManager)Curse.on(((CraftPlayer)player).getHandle().c).get("h");
        Channel channel = null;
        try {
            channel = (Channel)channelField.get(networkManager);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            exception.printStackTrace();
        }
        return channel;
    }

    public boolean close(Player player, ChannelHandler channelHandler) {
        try {
            ChannelPipeline channelPipeline = this.getNettyChannel(player).pipeline();
            channelPipeline.remove(channelHandler);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HashMap<String, ChannelHandler> getHandlers() {
        return handlers;
    }

    public void initPlayer(Player player) {
        handlers.put(player.getName(), this.listen(player, new PacketReceivingHandler(){

            @Override
            public boolean handle(Player player, PacketPlayInAdvancements packetPlayInAdvancements) {
                if (packetPlayInAdvancements.c() == PacketPlayInAdvancements.Status.a) {
                    NameKey nameKey = new NameKey(packetPlayInAdvancements.d());
                    AdvancementTabChangeEvent advancementTabChangeEvent = new AdvancementTabChangeEvent(player, nameKey);
                    Bukkit.getPluginManager().callEvent((Event)advancementTabChangeEvent);
                    if (advancementTabChangeEvent.isCancelled()) {
                        CrazyAdvancementsAPI.clearActiveTab(player);
                        return false;
                    }
                    if (!advancementTabChangeEvent.getTabAdvancement().equals(nameKey)) {
                        CrazyAdvancementsAPI.setActiveTab(player, advancementTabChangeEvent.getTabAdvancement());
                    } else {
                        CrazyAdvancementsAPI.setActiveTab(player, nameKey, false);
                    }
                } else {
                    AdvancementScreenCloseEvent advancementScreenCloseEvent = new AdvancementScreenCloseEvent(player);
                    Bukkit.getPluginManager().callEvent((Event)advancementScreenCloseEvent);
                }
                return true;
            }
        }));
    }

    static {
        IBootstrap.dasBoot();
        handlers = new HashMap();
    }

    static interface PacketReceivingHandler {
        public boolean handle(Player var1, PacketPlayInAdvancements var2);
    }
}

