/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.advancement;

import com.volmit.adapt.util.advancements.JSONMessage;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.advancements.AdvancementFrameType;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdvancementDisplay {
    private ItemStack icon;
    private JSONMessage title;
    private JSONMessage description;
    private AdvancementFrame frame;
    private transient AdvancementVisibility vis;
    private String backgroundTexture;
    private float x = 0.0f;
    private float y = 0.0f;
    private Advancement positionOrigin;

    public AdvancementDisplay(Material material, JSONMessage jSONMessage, JSONMessage jSONMessage2, AdvancementFrame advancementFrame, AdvancementVisibility advancementVisibility) {
        this.icon = new ItemStack(material);
        this.title = jSONMessage;
        this.description = jSONMessage2;
        this.frame = advancementFrame;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(Material material, String string, String string2, AdvancementFrame advancementFrame, AdvancementVisibility advancementVisibility) {
        this.icon = new ItemStack(material);
        TextComponent textComponent = new TextComponent(string);
        this.title = new JSONMessage((BaseComponent)textComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(string2));
        this.frame = advancementFrame;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(Material material, JSONMessage jSONMessage, JSONMessage jSONMessage2, AdvancementFrame advancementFrame, String string, AdvancementVisibility advancementVisibility) {
        this.icon = new ItemStack(material);
        this.title = jSONMessage;
        this.description = jSONMessage2;
        this.frame = advancementFrame;
        this.backgroundTexture = string;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(Material material, String string, String string2, AdvancementFrame advancementFrame, String string3, AdvancementVisibility advancementVisibility) {
        this.icon = new ItemStack(material);
        TextComponent textComponent = new TextComponent(string);
        this.title = new JSONMessage((BaseComponent)textComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(string2));
        this.frame = advancementFrame;
        this.backgroundTexture = string3;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(ItemStack itemStack, JSONMessage jSONMessage, JSONMessage jSONMessage2, AdvancementFrame advancementFrame, AdvancementVisibility advancementVisibility) {
        this.icon = itemStack;
        this.title = jSONMessage;
        this.description = jSONMessage2;
        this.frame = advancementFrame;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(ItemStack itemStack, String string, String string2, AdvancementFrame advancementFrame, AdvancementVisibility advancementVisibility) {
        this.icon = itemStack;
        TextComponent textComponent = new TextComponent(string);
        this.title = new JSONMessage((BaseComponent)textComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(string2));
        this.frame = advancementFrame;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(ItemStack itemStack, JSONMessage jSONMessage, JSONMessage jSONMessage2, AdvancementFrame advancementFrame, String string, AdvancementVisibility advancementVisibility) {
        this.icon = itemStack;
        this.title = jSONMessage;
        this.description = jSONMessage2;
        this.frame = advancementFrame;
        this.backgroundTexture = string;
        this.setVisibility(advancementVisibility);
    }

    public AdvancementDisplay(ItemStack itemStack, String string, String string2, AdvancementFrame advancementFrame, String string3, AdvancementVisibility advancementVisibility) {
        this.icon = itemStack;
        TextComponent textComponent = new TextComponent(string);
        this.title = new JSONMessage((BaseComponent)textComponent);
        this.description = new JSONMessage((BaseComponent)new TextComponent(string2));
        this.frame = advancementFrame;
        this.backgroundTexture = string3;
        this.setVisibility(advancementVisibility);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(Material material) {
        this.icon = new ItemStack(material);
    }

    public void setIcon(ItemStack itemStack) {
        this.icon = itemStack;
    }

    public JSONMessage getTitle() {
        return this.title;
    }

    public void setTitle(JSONMessage jSONMessage) {
        this.title = jSONMessage;
    }

    public void setTitle(String string) {
        TextComponent textComponent = new TextComponent(string);
        this.title = new JSONMessage((BaseComponent)textComponent);
    }

    public JSONMessage getDescription() {
        return this.description;
    }

    public void setDescription(JSONMessage jSONMessage) {
        this.description = jSONMessage;
    }

    public void setDescription(String string) {
        this.description = new JSONMessage((BaseComponent)new TextComponent(string));
    }

    public AdvancementFrame getFrame() {
        return this.frame;
    }

    public void setFrame(AdvancementFrame advancementFrame) {
        this.frame = advancementFrame;
    }

    @Nullable
    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setBackgroundTexture(@Nullable String string) {
        this.backgroundTexture = string;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float generateX() {
        if (this.getPositionOrigin() == null) {
            return this.x;
        }
        return this.getPositionOrigin().getDisplay().generateX() + this.x;
    }

    public float generateY() {
        if (this.getPositionOrigin() == null) {
            return this.y;
        }
        return this.getPositionOrigin().getDisplay().generateY() + this.y;
    }

    public AdvancementVisibility getVisibility() {
        return this.vis != null ? this.vis : AdvancementVisibility.VANILLA;
    }

    public void setVisibility(AdvancementVisibility advancementVisibility) {
        this.vis = advancementVisibility;
    }

    public boolean isVisible(Player player, Advancement advancement) {
        AdvancementVisibility advancementVisibility = this.getVisibility();
        Advancement advancement2 = advancement.getParent();
        boolean bl = advancement2 == null || advancement2.getDisplay().isVisible(player, advancement2);
        return bl && advancementVisibility.isVisible(player, advancement) || advancement.isGranted(player) || advancementVisibility.isAlwaysVisibleWhenAnyChildIsGranted() && advancement.isAnythingGrantedAfter(player);
    }

    public Advancement getPositionOrigin() {
        return this.positionOrigin;
    }

    public void setPositionOrigin(@Nullable Advancement advancement) {
        this.positionOrigin = advancement;
    }

    public void setCoordinates(float f, float f2) {
        this.setX(f);
        this.setY(f2);
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum AdvancementFrame {
        TASK(AdvancementFrameType.a),
        GOAL(AdvancementFrameType.c),
        CHALLENGE(AdvancementFrameType.b);

        private final AdvancementFrameType nms;

        private AdvancementFrame(AdvancementFrameType advancementFrameType) {
            this.nms = advancementFrameType;
        }

        public static AdvancementFrame parse(String string) {
            for (AdvancementFrame advancementFrame : AdvancementFrame.values()) {
                if (!advancementFrame.name().equalsIgnoreCase(string)) continue;
                return advancementFrame;
            }
            return TASK;
        }

        public static AdvancementFrame parseStrict(String string) {
            for (AdvancementFrame advancementFrame : AdvancementFrame.values()) {
                if (!advancementFrame.name().equalsIgnoreCase(string)) continue;
                return advancementFrame;
            }
            return null;
        }

        public AdvancementFrameType getNMS() {
            return this.nms;
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

