/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.command;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ProgressChangeOperation {
    SET{

        @Override
        public int apply(int n, int n2) {
            return n2;
        }
    }
    ,
    ADD{

        @Override
        public int apply(int n, int n2) {
            return n + n2;
        }
    }
    ,
    REMOVE{

        @Override
        public int apply(int n, int n2) {
            return n - n2;
        }
    }
    ,
    MULTIPLY{

        @Override
        public int apply(int n, int n2) {
            return n * n2;
        }
    }
    ,
    DIVIDE{

        @Override
        public int apply(int n, int n2) {
            return (int)Math.floor((double)n * 1.0 / (double)n2);
        }
    }
    ,
    POWER{

        @Override
        public int apply(int n, int n2) {
            return (int)Math.pow(n, n2);
        }
    };


    public static ProgressChangeOperation parse(String string) {
        for (ProgressChangeOperation progressChangeOperation : ProgressChangeOperation.values()) {
            if (!progressChangeOperation.name().equalsIgnoreCase(string)) continue;
            return progressChangeOperation;
        }
        return SET;
    }

    public abstract int apply(int var1, int var2);

    static {
        IBootstrap.dasBoot();
    }
}

