/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.advancements.manager;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.volmit.adapt.util.advancements.CrazyAdvancementsAPI;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementReward;
import com.volmit.adapt.util.advancements.advancement.criteria.CriteriaType;
import com.volmit.adapt.util.advancements.advancement.progress.AdvancementProgress;
import com.volmit.adapt.util.advancements.advancement.progress.GenericResult;
import com.volmit.adapt.util.advancements.advancement.progress.GrantCriteriaResult;
import com.volmit.adapt.util.advancements.advancement.progress.SetCriteriaResult;
import com.volmit.adapt.util.advancements.event.AdvancementGrantEvent;
import com.volmit.adapt.util.advancements.event.AdvancementRevokeEvent;
import com.volmit.adapt.util.advancements.packet.AdvancementsPacket;
import com.volmit.adapt.util.advancements.packet.PacketConverter;
import com.volmit.adapt.util.advancements.save.CriteriaData;
import com.volmit.adapt.util.advancements.save.ProgressData;
import com.volmit.adapt.util.advancements.save.SaveFile;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class AdvancementManager {
    private static final HashMap<String, AdvancementManager> accessibleManagers;
    private final NameKey name;
    private final ArrayList<Player> players;
    private final ArrayList<Advancement> advancements = new ArrayList();

    public AdvancementManager(NameKey nameKey, Player ... playerArray) {
        this.name = nameKey;
        this.players = new ArrayList();
        for (Player player : playerArray) {
            this.addPlayer(player);
        }
    }

    public static AdvancementManager getAccessibleManager(NameKey nameKey) {
        return accessibleManagers.getOrDefault(nameKey.toString(), null);
    }

    public static Collection<AdvancementManager> getAccessibleManagers() {
        return accessibleManagers.values();
    }

    private static boolean isOnline(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        return player != null && player.isOnline();
    }

    private static SaveFile generateSaveFile(File file) {
        if (file.exists() && file.isFile()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                JsonElement jsonElement = JsonParser.parseReader((Reader)fileReader);
                fileReader.close();
                return SaveFile.fromJSON(jsonElement);
            }
            catch (Exception exception) {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                System.err.println("Unable to read Save File!");
                exception.printStackTrace();
            }
        }
        return new SaveFile(new ArrayList<ProgressData>(), new ArrayList<CriteriaData>());
    }

    public NameKey getName() {
        return this.name;
    }

    public void addPlayer(Player player) {
        if (player == null) {
            throw new RuntimeException("Player may not be null");
        }
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        for (Advancement advancement : this.getAdvancements()) {
            AdvancementDisplay advancementDisplay = advancement.getDisplay();
            boolean bl = advancementDisplay.isVisible(player, advancement);
            advancement.saveVisibilityStatus(player, bl);
            if (!bl) continue;
            arrayList.add(advancement);
        }
        AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, arrayList, null);
        advancementsPacket.send();
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
        ArrayList<NameKey> arrayList = new ArrayList<NameKey>();
        for (Advancement advancement : this.getAdvancements()) {
            arrayList.add(advancement.getName());
        }
        AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, null, arrayList);
        advancementsPacket.send();
    }

    public ArrayList<Player> getPlayers() {
        this.players.removeIf(player -> player == null || !player.isOnline());
        return this.players;
    }

    public void addAdvancement(Advancement ... advancementArray) {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        for (Advancement advancement : advancementArray) {
            if (this.advancements.contains(advancement)) continue;
            this.advancements.add(advancement);
            arrayList.add(advancement);
        }
        HashSet hashSet = new HashSet();
        for (Advancement advancement : arrayList) {
            float f = PacketConverter.getSmallestX(advancement.getTab());
            float f2 = advancement.getDisplay().generateX();
            if (f2 < f) {
                f = f2;
                hashSet.add(advancement.getTab());
                PacketConverter.setSmallestX(advancement.getTab(), f);
            }
            float f3 = PacketConverter.getSmallestY(advancement.getTab());
            float f4 = advancement.getDisplay().generateY();
            if (!(f4 < f3)) continue;
            f3 = f4;
            hashSet.add(advancement.getTab());
            PacketConverter.setSmallestY(advancement.getTab(), f3);
        }
        Iterator<Object> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            NameKey nameKey = (NameKey)iterator.next();
            for (Player player : this.getPlayers()) {
                this.updateTab(player, nameKey);
            }
        }
        for (Player player : this.getPlayers()) {
            ArrayList<Advancement> arrayList2 = new ArrayList<Advancement>();
            for (Advancement advancement : arrayList) {
                AdvancementDisplay advancementDisplay = advancement.getDisplay();
                boolean bl = advancementDisplay.isVisible(player, advancement);
                advancement.saveVisibilityStatus(player, bl);
                if (!bl) continue;
                arrayList2.add(advancement);
            }
            AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, arrayList2, null);
            advancementsPacket.send();
        }
    }

    public void updateAdvancement(Advancement ... advancementArray) {
        HashSet<NameKey> hashSet = new HashSet<NameKey>();
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        ArrayList<NameKey> arrayList2 = new ArrayList<NameKey>();
        for (Advancement object : advancementArray) {
            boolean bl = false;
            float f = PacketConverter.getSmallestX(object.getTab());
            float f2 = object.getDisplay().generateX();
            if (f2 < f) {
                bl = true;
                f = f2;
                hashSet.add(object.getTab());
                PacketConverter.setSmallestX(object.getTab(), f);
            }
            float f3 = PacketConverter.getSmallestY(object.getTab());
            float f4 = object.getDisplay().generateY();
            if (f4 < f3) {
                bl = true;
                f3 = f4;
                hashSet.add(object.getTab());
                PacketConverter.setSmallestY(object.getTab(), f3);
            }
            if (bl) continue;
            arrayList.add(object);
        }
        for (NameKey nameKey : hashSet) {
            for (Player player : this.getPlayers()) {
                this.updateTab(player, nameKey);
            }
        }
        if (arrayList.size() > 0) {
            for (Player player : this.getPlayers()) {
                NameKey nameKey = CrazyAdvancementsAPI.getActiveTab(player);
                CrazyAdvancementsAPI.clearActiveTab(player);
                AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, arrayList, arrayList2);
                advancementsPacket.send();
                CrazyAdvancementsAPI.setActiveTab(player, nameKey);
            }
        }
    }

    public void removeAdvancement(Advancement ... advancementArray) {
        ArrayList<NameKey> arrayList = new ArrayList<NameKey>();
        for (Advancement advancement : advancementArray) {
            if (!this.advancements.contains(advancement)) continue;
            this.advancements.remove(advancement);
            arrayList.add(advancement.getName());
        }
        for (Player player : this.getPlayers()) {
            AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, null, arrayList);
            advancementsPacket.send();
        }
    }

    public ArrayList<Advancement> getAdvancements() {
        return new ArrayList<Advancement>(this.advancements);
    }

    public ArrayList<Advancement> getAdvancements(String string) {
        ArrayList<Advancement> arrayList = this.getAdvancements();
        arrayList.removeIf(advancement -> !advancement.getName().getNamespace().equalsIgnoreCase(string));
        return arrayList;
    }

    public Advancement getAdvancement(NameKey nameKey) {
        for (Advancement advancement : this.advancements) {
            if (!advancement.hasName(nameKey)) continue;
            return advancement;
        }
        return null;
    }

    public void makeAccessible() {
        if (accessibleManagers.containsKey(this.name.toString())) {
            throw new RuntimeException("There is already an AdvancementManager with Name '" + this.name + "'!");
        }
        if (accessibleManagers.containsValue(this)) {
            throw new RuntimeException("AdvancementManager is already accessible!");
        }
        accessibleManagers.put(this.name.toString(), this);
    }

    public void resetAccessible() {
        Iterator<String> iterator = accessibleManagers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!accessibleManagers.get(string).equals(this)) continue;
            iterator.remove();
            break;
        }
    }

    public void updateTab(Player player, NameKey nameKey) {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        ArrayList<NameKey> arrayList2 = new ArrayList<NameKey>();
        for (Advancement object2 : this.getAdvancements()) {
            if (!object2.getTab().isSimilar(nameKey) || !object2.getDisplay().isVisible(player, object2)) continue;
            arrayList.add(object2);
            arrayList2.add(object2.getName());
        }
        NameKey nameKey2 = CrazyAdvancementsAPI.getActiveTab(player);
        CrazyAdvancementsAPI.clearActiveTab(player);
        AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, arrayList, arrayList2);
        advancementsPacket.send();
        CrazyAdvancementsAPI.setActiveTab(player, nameKey2);
    }

    public void updateProgress(Player player, Advancement ... advancementArray) {
        ArrayList<Advancement> arrayList = new ArrayList<Advancement>();
        for (Advancement advancement : advancementArray) {
            boolean bl = advancement.getDisplay().isVisible(player, advancement);
            advancement.saveVisibilityStatus(player, bl);
            if (!bl) continue;
            arrayList.add(advancement);
        }
        AdvancementsPacket advancementsPacket = new AdvancementsPacket(player, false, arrayList, null);
        advancementsPacket.send();
    }

    public void updateVisibility(Player player) {
        for (Advancement advancement : this.getAdvancements()) {
            AdvancementsPacket advancementsPacket;
            boolean bl;
            boolean bl2 = advancement.getVisibilityStatus(player);
            if (bl2 == (bl = advancement.getDisplay().isVisible(player, advancement))) continue;
            advancement.saveVisibilityStatus(player, bl);
            if (bl) {
                advancementsPacket = new AdvancementsPacket(player, false, Arrays.asList(advancement), null);
                advancementsPacket.send();
                continue;
            }
            advancementsPacket = new AdvancementsPacket(player, false, null, Arrays.asList(advancement.getName()));
            advancementsPacket.send();
        }
    }

    public GenericResult grantAdvancement(Player player, Advancement advancement) {
        if (advancement == null || player == null) {
            return null;
        }
        AdvancementProgress advancementProgress = advancement.getProgress(player);
        GenericResult genericResult = advancementProgress.grant();
        if (genericResult == GenericResult.CHANGED) {
            AdvancementReward advancementReward;
            AdvancementGrantEvent advancementGrantEvent = new AdvancementGrantEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)advancementGrantEvent);
            if (advancementGrantEvent.isShowToast() && player.getPlayer() != null) {
                advancement.displayToast(player);
            }
            if (advancementGrantEvent.isDisplayMessage()) {
                advancement.displayMessageToEverybody(player);
            }
            if ((advancementReward = advancement.getReward()) != null) {
                advancementReward.onGrant(player);
            }
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return genericResult;
    }

    public GenericResult grantAdvancement(UUID uUID, Advancement advancement) {
        if (AdvancementManager.isOnline(uUID)) {
            return this.grantAdvancement(Bukkit.getPlayer((UUID)uUID), advancement);
        }
        AdvancementProgress advancementProgress = advancement.getProgress(uUID);
        return advancementProgress.grant();
    }

    public GenericResult revokeAdvancement(Player player, Advancement advancement) {
        AdvancementProgress advancementProgress = advancement.getProgress(player);
        GenericResult genericResult = advancementProgress.revoke();
        if (genericResult == GenericResult.CHANGED) {
            AdvancementRevokeEvent advancementRevokeEvent = new AdvancementRevokeEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)advancementRevokeEvent);
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return genericResult;
    }

    public GenericResult revokeAdvancement(UUID uUID, Advancement advancement) {
        if (AdvancementManager.isOnline(uUID)) {
            return this.revokeAdvancement(Bukkit.getPlayer((UUID)uUID), advancement);
        }
        AdvancementProgress advancementProgress = advancement.getProgress(uUID);
        return advancementProgress.revoke();
    }

    public GrantCriteriaResult grantCriteria(Player player, Advancement advancement, String ... stringArray) {
        AdvancementProgress advancementProgress = advancement.getProgress(player);
        GrantCriteriaResult grantCriteriaResult = advancementProgress.grantCriteria(stringArray);
        switch (grantCriteriaResult) {
            case COMPLETED: {
                AdvancementReward advancementReward;
                AdvancementGrantEvent advancementGrantEvent = new AdvancementGrantEvent(this, advancement, player);
                Bukkit.getPluginManager().callEvent((Event)advancementGrantEvent);
                if (advancementGrantEvent.isShowToast() && player.getPlayer() != null) {
                    advancement.displayToast(player);
                }
                if (advancementGrantEvent.isDisplayMessage()) {
                    advancement.displayMessageToEverybody(player);
                }
                if ((advancementReward = advancement.getReward()) != null) {
                    advancementReward.onGrant(player);
                }
                this.updateVisibility(player);
            }
            case CHANGED: {
                this.updateProgress(player, advancement);
                break;
            }
        }
        return grantCriteriaResult;
    }

    public GrantCriteriaResult grantCriteria(UUID uUID, Advancement advancement, String ... stringArray) {
        if (AdvancementManager.isOnline(uUID)) {
            return this.grantCriteria(Bukkit.getPlayer((UUID)uUID), advancement, stringArray);
        }
        AdvancementProgress advancementProgress = advancement.getProgress(uUID);
        return advancementProgress.grantCriteria(stringArray);
    }

    public GenericResult revokeCriteria(Player player, Advancement advancement, String ... stringArray) {
        AdvancementProgress advancementProgress = advancement.getProgress(player);
        GenericResult genericResult = advancementProgress.revokeCriteria(stringArray);
        if (genericResult == GenericResult.CHANGED) {
            AdvancementRevokeEvent advancementRevokeEvent = new AdvancementRevokeEvent(this, advancement, player);
            Bukkit.getPluginManager().callEvent((Event)advancementRevokeEvent);
            this.updateVisibility(player);
            this.updateProgress(player, advancement);
        }
        return genericResult;
    }

    public GenericResult revokeCriteria(UUID uUID, Advancement advancement, String ... stringArray) {
        if (AdvancementManager.isOnline(uUID)) {
            return this.revokeCriteria(Bukkit.getPlayer((UUID)uUID), advancement, stringArray);
        }
        AdvancementProgress advancementProgress = advancement.getProgress(uUID);
        return advancementProgress.revokeCriteria(stringArray);
    }

    public SetCriteriaResult setCriteriaProgress(Player player, Advancement advancement, int n) {
        if (advancement.getCriteria().getType() == CriteriaType.NUMBER) {
            AdvancementProgress advancementProgress = advancement.getProgress(player);
            boolean bl = advancementProgress.isDone();
            SetCriteriaResult setCriteriaResult = advancementProgress.setCriteriaProgress(n);
            switch (setCriteriaResult) {
                case COMPLETED: {
                    AdvancementReward advancementReward;
                    AdvancementGrantEvent advancementGrantEvent = new AdvancementGrantEvent(this, advancement, player);
                    Bukkit.getPluginManager().callEvent((Event)advancementGrantEvent);
                    if (advancementGrantEvent.isShowToast() && player.getPlayer() != null) {
                        advancement.displayToast(player);
                    }
                    if (advancementGrantEvent.isDisplayMessage()) {
                        advancement.displayMessageToEverybody(player);
                    }
                    if ((advancementReward = advancement.getReward()) != null) {
                        advancementReward.onGrant(player);
                    }
                    this.updateVisibility(player);
                }
                case CHANGED: {
                    if (bl) {
                        AdvancementRevokeEvent advancementRevokeEvent = new AdvancementRevokeEvent(this, advancement, player);
                        Bukkit.getPluginManager().callEvent((Event)advancementRevokeEvent);
                    }
                    this.updateProgress(player, advancement);
                    break;
                }
            }
            return setCriteriaResult;
        }
        return SetCriteriaResult.INVALID;
    }

    public SetCriteriaResult setCriteriaProgress(UUID uUID, Advancement advancement, int n) {
        if (AdvancementManager.isOnline(uUID)) {
            return this.setCriteriaProgress(Bukkit.getPlayer((UUID)uUID), advancement, n);
        }
        if (advancement.getCriteria().getType() == CriteriaType.NUMBER) {
            AdvancementProgress advancementProgress = advancement.getProgress(uUID);
            return advancementProgress.setCriteriaProgress(n);
        }
        return SetCriteriaResult.INVALID;
    }

    public int getCriteriaProgress(Player player, Advancement advancement) {
        return advancement.getProgress(player).getCriteriaProgress();
    }

    public int getCriteriaProgress(UUID uUID, Advancement advancement) {
        return advancement.getProgress(uUID).getCriteriaProgress();
    }

    private String getSavePath(UUID uUID) {
        return CrazyAdvancementsAPI.getInstance().getDataFolder().getAbsolutePath() + File.separator + "saved_data" + File.separator + this.name.getNamespace() + File.separator + this.name.getKey() + File.separator + uUID + ".json";
    }

    private File getSaveFile(UUID uUID) {
        File file = new File(this.getSavePath(uUID));
        file.getParentFile().mkdirs();
        return file;
    }

    public SaveFile createNewSave(Player player, Advancement ... advancementArray) {
        return this.createNewSave(player.getUniqueId(), advancementArray);
    }

    public SaveFile createNewSave(UUID uUID, Advancement ... advancementArray) {
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        ArrayList<ProgressData> arrayList = new ArrayList<ProgressData>();
        ArrayList<CriteriaData> arrayList2 = new ArrayList<CriteriaData>();
        for (Advancement advancement : list) {
            switch (advancement.getCriteria().getType()) {
                case NUMBER: {
                    arrayList.add(new ProgressData(advancement.getName(), this.getCriteriaProgress(uUID, advancement)));
                    break;
                }
                case LIST: {
                    arrayList2.add(new CriteriaData(advancement.getName(), Lists.newArrayList(advancement.getProgress(uUID).getAwardedCriteria())));
                }
            }
        }
        return new SaveFile(arrayList, arrayList2);
    }

    public void saveProgress(Player player, Advancement ... advancementArray) {
        this.saveProgress(player.getUniqueId(), advancementArray);
    }

    public void saveProgress(UUID uUID, Advancement ... advancementArray) {
        File file = this.getSaveFile(uUID);
        SaveFile saveFile = AdvancementManager.generateSaveFile(file);
        SaveFile saveFile2 = this.createNewSave(uUID, advancementArray);
        saveFile.merge(saveFile2);
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else if (!file.isFile()) {
                if (file.listFiles().length > 0) {
                    throw new RuntimeException("Could not create Save File: A Non-Empty Folder with the File Name already exists: " + file.getName());
                }
                file.delete();
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(saveFile.toJson());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadProgress(Player player, Advancement ... advancementArray) {
        this.loadProgress(player.getUniqueId(), advancementArray);
    }

    public void loadProgress(UUID uUID, Advancement ... advancementArray) {
        File file = this.getSaveFile(uUID);
        SaveFile saveFile = AdvancementManager.generateSaveFile(file);
        this.loadProgress(uUID, saveFile, advancementArray);
    }

    public void loadProgress(Player player, SaveFile saveFile, Advancement ... advancementArray) {
        this.loadProgress(player.getUniqueId(), saveFile, advancementArray);
    }

    public void loadProgress(UUID uUID, SaveFile saveFile, Advancement ... advancementArray) {
        NameKey nameKey;
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        block0: for (ProgressData object : saveFile.getProgressData()) {
            nameKey = object.getName();
            int n = object.getProgress();
            for (Advancement advancement : list) {
                if (advancement.getCriteria().getType() != CriteriaType.NUMBER || !advancement.hasName(nameKey)) continue;
                advancement.getProgress(uUID).setCriteriaProgress(n);
                continue block0;
            }
        }
        block2: for (CriteriaData criteriaData : saveFile.getCriteriaData()) {
            nameKey = criteriaData.getName();
            List<String> list2 = criteriaData.getCriteria();
            for (Advancement advancement : list) {
                if (advancement.getCriteria().getType() != CriteriaType.LIST || !advancement.hasName(nameKey)) continue;
                advancement.getProgress(uUID).grantCriteria((String[])Iterables.toArray(list2, String.class));
                continue block2;
            }
        }
    }

    public void unloadProgress(Player player, Advancement ... advancementArray) {
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        for (Advancement advancement : list) {
            advancement.getProgress(player).revoke();
            this.updateProgress(player, advancementArray);
            advancement.unloadProgress(player);
        }
    }

    public void unloadProgress(UUID uUID, Advancement ... advancementArray) {
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        for (Advancement advancement : list) {
            advancement.unloadProgress(uUID);
        }
    }

    public void unloadVisibilityStatus(Player player, Advancement ... advancementArray) {
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        for (Advancement advancement : list) {
            advancement.unloadVisibilityStatus(player);
        }
    }

    public void unloadVisibilityStatus(UUID uUID, Advancement ... advancementArray) {
        List<Advancement> list = advancementArray.length == 0 ? this.getAdvancements() : Arrays.asList(advancementArray);
        for (Advancement advancement : list) {
            advancement.unloadVisibilityStatus(uUID);
        }
    }

    static {
        IBootstrap.dasBoot();
        accessibleManagers = new HashMap();
    }
}

