/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.geometry;

import com.volmit.adapt.util.arcane.amulet.fx.Ray;
import com.volmit.adapt.util.arcane.amulet.geometry.VecImpl3;
import com.volmit.adapt.util.extensions.java.lang.Math.XMath;
import com.volmit.adapt.util.extensions.java.util.Random.XRandom;
import com.volmit.adapt.util.manifold.ext.rt.RuntimeMethods;
import com.volmit.adapt.util.manifold.ext.rt.api.Structural;
import java.util.Random;

@Structural
public interface Vec {
    public static final double epsilon = 1.0E-6;

    public static Vec of(Vec other) {
        return ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).copy();
    }

    public static Vec of(double x, double y, double z) {
        return new VecImpl3(x, y, z);
    }

    public static Vec of(int x, int y, int z) {
        return new VecImpl3(x, y, z);
    }

    public static Vec of(double x) {
        return new VecImpl3(x);
    }

    default public Vec add(double x, double y, double z) {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(this.x() + x), Vec.class)).y(this.y() + y), Vec.class)).z(this.z() + z);
    }

    default public Vec multiply(double mult) {
        return this.multiply(mult, mult, mult);
    }

    default public Vec add(double all) {
        return this.add(all, all, all);
    }

    default public Vec copy() {
        return new VecImpl3(this.x(), this.y(), this.z());
    }

    default public Vec rem(double d) {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).modulus(d);
    }

    default public Vec plus(double d) {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).add(d);
    }

    default public Ray rayTo(Vec vec, int hits) {
        vec = RuntimeMethods.unFakeProxy(vec);
        return new Ray(this, (Vec)vec, hits);
    }

    default public Vec minus(double d) {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).subtract(d);
    }

    default public Vec times(double d) {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).multiply(d);
    }

    default public Vec div(double d) {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).divide(d);
    }

    default public Vec rem(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).modulus((Vec)d);
    }

    default public Vec plus(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).add((Vec)d);
    }

    default public Vec minus(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).subtract((Vec)d);
    }

    default public Vec times(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).multiply((Vec)d);
    }

    default public Vec div(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).divide((Vec)d);
    }

    default public Vec modulus(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return this.modulus(((Vec)RuntimeMethods.constructProxy(d, Vec.class)).x(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).y(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).z());
    }

    default public Vec divide(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return this.divide(((Vec)RuntimeMethods.constructProxy(d, Vec.class)).x(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).y(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).z());
    }

    default public Vec multiply(Vec d) {
        d = RuntimeMethods.unFakeProxy(d);
        return this.multiply(((Vec)RuntimeMethods.constructProxy(d, Vec.class)).x(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).y(), ((Vec)RuntimeMethods.constructProxy(d, Vec.class)).z());
    }

    default public Vec inc() {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).add(1.0);
    }

    default public Vec dec() {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).subtract(1.0);
    }

    default public Vec unaryMinus() {
        return ((Vec)RuntimeMethods.constructProxy(this.copy(), Vec.class)).reverse();
    }

    default public Vec divide(double d) {
        return this.divide(d, d, d);
    }

    default public Vec modulus(double d) {
        return this.modulus(d, d, d);
    }

    default public Vec subtract(double d) {
        return this.add(-d);
    }

    default public Vec direction(Vec to) {
        to = RuntimeMethods.unFakeProxy(to);
        return ((Vec)RuntimeMethods.constructProxy(this.directionNoNormal((Vec)to), Vec.class)).normalize();
    }

    default public Vec directionNoNormal(Vec to) {
        to = RuntimeMethods.unFakeProxy(to);
        return ((Vec)RuntimeMethods.constructProxy(to, Vec.class)).minus(this);
    }

    default public Vec multiply(double x, double y, double z) {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(this.x() * x), Vec.class)).y(this.y() * y), Vec.class)).z(this.z() * z);
    }

    default public Vec divide(double x, double y, double z) {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(this.x() / x), Vec.class)).y(this.y() / y), Vec.class)).z(this.z() / z);
    }

    default public Vec modulus(double x, double y, double z) {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(this.x() % x), Vec.class)).y(this.y() % y), Vec.class)).z(this.z() % z);
    }

    default public Vec reverse() {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(-this.x()), Vec.class)).y(-this.y()), Vec.class)).z(-this.z());
    }

    default public Vec reverseX() {
        return this.x(-this.x());
    }

    default public Vec reverseY() {
        return this.y(-this.y());
    }

    default public Vec reverseZ() {
        return this.z(-this.z());
    }

    default public double get(int index) {
        if (index == 0) {
            return this.x();
        }
        if (index == 1) {
            return this.y();
        }
        if (index == 2) {
            return this.z();
        }
        throw new IndexOutOfBoundsException("0, 1, or 2 (provided: " + index + ")");
    }

    default public double set(int index, double value) {
        if (index == 0) {
            this.x(value);
            return value;
        }
        if (index == 1) {
            this.y(value);
            return value;
        }
        if (index == 2) {
            this.z(value);
            return value;
        }
        throw new IndexOutOfBoundsException("0, 1, or 2 (provided: " + index + ")");
    }

    default public Vec subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    default public Vec add(Vec v) {
        v = RuntimeMethods.unFakeProxy(v);
        return this.add(((Vec)RuntimeMethods.constructProxy(v, Vec.class)).x(), ((Vec)RuntimeMethods.constructProxy(v, Vec.class)).y(), ((Vec)RuntimeMethods.constructProxy(v, Vec.class)).z());
    }

    default public Vec subtract(Vec v) {
        v = RuntimeMethods.unFakeProxy(v);
        return this.subtract(((Vec)RuntimeMethods.constructProxy(v, Vec.class)).x(), ((Vec)RuntimeMethods.constructProxy(v, Vec.class)).y(), ((Vec)RuntimeMethods.constructProxy(v, Vec.class)).z());
    }

    public double x();

    public Vec x(double var1);

    public double y();

    public Vec y(double var1);

    public double z();

    public Vec z(double var1);

    default public double length() {
        return Math.sqrt(XMath.sq(this.x()) + XMath.sq(this.y()) + XMath.sq(this.z()));
    }

    default public double lengthSquared() {
        return XMath.sq(this.x()) + XMath.sq(this.y()) + XMath.sq(this.z());
    }

    default public double distance(Vec o) {
        o = RuntimeMethods.unFakeProxy(o);
        return Math.sqrt(XMath.sq(this.x() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x()) + XMath.sq(this.y() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y()) + XMath.sq(this.z() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z()));
    }

    default public double distanceSquared(Vec o) {
        o = RuntimeMethods.unFakeProxy(o);
        return XMath.sq(this.x() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x()) + XMath.sq(this.y() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y()) + XMath.sq(this.z() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z());
    }

    default public float angle(Vec other) {
        other = RuntimeMethods.unFakeProxy(other);
        double dot = XMath.constrainToRange(this.dot((Vec)other) / (this.length() * ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).length()), -1.0, 1.0);
        return (float)Math.acos(dot);
    }

    default public double dot(Vec other) {
        other = RuntimeMethods.unFakeProxy(other);
        return this.x() * ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).x() + this.y() * ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).y() + this.z() * ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).z();
    }

    default public Vec midpoint(Vec other) {
        other = RuntimeMethods.unFakeProxy(other);
        this.x((this.x() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).x()) / 2.0);
        this.y((this.y() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).y()) / 2.0);
        this.z((this.z() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).z()) / 2.0);
        return this;
    }

    default public Vec getMidpoint(Vec other) {
        other = RuntimeMethods.unFakeProxy(other);
        double x = (((Vec)RuntimeMethods.constructProxy(this, Vec.class)).x() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).x()) / 2.0;
        double y = (((Vec)RuntimeMethods.constructProxy(this, Vec.class)).y() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).y()) / 2.0;
        double z = (((Vec)RuntimeMethods.constructProxy(this, Vec.class)).z() + ((Vec)RuntimeMethods.constructProxy(other, Vec.class)).z()) / 2.0;
        return new VecImpl3(x, y, z);
    }

    default public Vec crossProduct(Vec o) {
        o = RuntimeMethods.unFakeProxy(o);
        double newX = this.y() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y() * this.z();
        double newY = this.z() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z() * this.x();
        double newZ = this.x() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x() * this.y();
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(newX), Vec.class)).y(newY), Vec.class)).z(newZ);
    }

    default public Vec getCrossProduct(Vec o) {
        o = RuntimeMethods.unFakeProxy(o);
        double x = ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).y() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y() * ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).z();
        double y = ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).z() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).z() * ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).x();
        double z = ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).x() * ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).y() - ((Vec)RuntimeMethods.constructProxy(o, Vec.class)).x() * ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).y();
        return new VecImpl3(x, y, z);
    }

    default public Vec normalize() {
        return this.divide(this.length());
    }

    default public Vec zero() {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(0.0), Vec.class)).y(0.0), Vec.class)).z(0.0);
    }

    default public Vec normalizeZeros() {
        if (this.x() == -0.0) {
            this.x(0.0);
        }
        if (this.y() == -0.0) {
            this.y(0.0);
        }
        if (this.z() == -0.0) {
            this.z(0.0);
        }
        return this;
    }

    default public boolean isInAABB(Vec min, Vec max) {
        max = RuntimeMethods.unFakeProxy(max);
        min = RuntimeMethods.unFakeProxy(min);
        return this.x() >= ((Vec)RuntimeMethods.constructProxy(min, Vec.class)).x() && this.x() <= ((Vec)RuntimeMethods.constructProxy(max, Vec.class)).x() && this.y() >= ((Vec)RuntimeMethods.constructProxy(min, Vec.class)).y() && this.y() <= ((Vec)RuntimeMethods.constructProxy(max, Vec.class)).y() && this.z() >= ((Vec)RuntimeMethods.constructProxy(min, Vec.class)).z() && this.z() <= ((Vec)RuntimeMethods.constructProxy(max, Vec.class)).z();
    }

    default public boolean isInSphere(Vec origin, double radius) {
        return XMath.sq(((Vec)RuntimeMethods.constructProxy(origin = RuntimeMethods.unFakeProxy(origin), Vec.class)).x() - this.x()) + XMath.sq(((Vec)RuntimeMethods.constructProxy(origin, Vec.class)).y() - this.y()) + XMath.sq(((Vec)RuntimeMethods.constructProxy(origin, Vec.class)).z() - this.z()) <= XMath.sq(radius);
    }

    default public boolean isNormalized() {
        return Math.abs(((Vec)RuntimeMethods.constructProxy(this, Vec.class)).lengthSquared() - 1.0) < Vec.getEpsilon();
    }

    public static double getEpsilon() {
        return 1.0E-6;
    }

    default public Vec rotateAroundX(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double y = angleCos * this.y() - angleSin * this.z();
        double z = angleSin * this.y() + angleCos * this.z();
        return ((Vec)RuntimeMethods.constructProxy(this.y(y), Vec.class)).z(z);
    }

    default public Vec rotateAroundY(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * this.x() + angleSin * this.z();
        double z = -angleSin * this.x() + angleCos * this.z();
        return ((Vec)RuntimeMethods.constructProxy(this.x(x), Vec.class)).z(z);
    }

    default public Vec rotateAroundZ(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double x = angleCos * this.x() - angleSin * this.y();
        double y = angleSin * this.x() + angleCos * this.y();
        return ((Vec)RuntimeMethods.constructProxy(this.x(x), Vec.class)).y(y);
    }

    default public Vec rotateAroundAxis(Vec axis, double angle) throws IllegalArgumentException {
        return this.rotateAroundNonUnitAxis((Vec)(((Vec)RuntimeMethods.constructProxy(axis = RuntimeMethods.unFakeProxy(axis), Vec.class)).isNormalized() ? axis : ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(axis, Vec.class)).copy(), Vec.class)).normalize()), angle);
    }

    default public Vec rotateAroundNonUnitAxis(Vec axis, double angle) throws IllegalArgumentException {
        axis = RuntimeMethods.unFakeProxy(axis);
        double x = this.x();
        double y = this.y();
        double z = this.z();
        double x2 = ((Vec)RuntimeMethods.constructProxy(axis, Vec.class)).x();
        double y2 = ((Vec)RuntimeMethods.constructProxy(axis, Vec.class)).y();
        double z2 = ((Vec)RuntimeMethods.constructProxy(axis, Vec.class)).z();
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        double dotProduct = ((Vec)RuntimeMethods.constructProxy(this, Vec.class)).dot((Vec)axis);
        double xPrime = x2 * dotProduct * (1.0 - cosTheta) + x * cosTheta + (-z2 * y + y2 * z) * sinTheta;
        double yPrime = y2 * dotProduct * (1.0 - cosTheta) + y * cosTheta + (z2 * x - x2 * z) * sinTheta;
        double zPrime = z2 * dotProduct * (1.0 - cosTheta) + z * cosTheta + (-y2 * x + x2 * y) * sinTheta;
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(xPrime), Vec.class)).y(yPrime), Vec.class)).z(zPrime);
    }

    default public Vec floor() {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(Math.floor(this.x())), Vec.class)).y(Math.floor(this.y())), Vec.class)).z(Math.floor(this.z()));
    }

    default public Vec ceil() {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.x(Math.ceil(this.x())), Vec.class)).y(Math.ceil(this.y())), Vec.class)).z(Math.ceil(this.z()));
    }

    default public Vec floorDiv(int m) {
        return ((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(((Vec)RuntimeMethods.constructProxy(this.floor(), Vec.class)).x(Math.floorDiv((int)this.x(), m)), Vec.class)).y(Math.floorDiv((int)this.y(), m)), Vec.class)).z(Math.floorDiv((int)this.z(), m));
    }

    public static Vec random(Random random) {
        return new VecImpl3(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public static Vec random() {
        return Vec.random(XRandom.r());
    }
}

